/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.protocol.http;

import com.amazon.opendistroforelasticsearch.jdbc.protocol.ClusterMetadata;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.ConnectionResponse;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.Protocol;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.QueryRequest;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.QueryResponse;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.exceptions.ResponseException;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.http.JsonClusterMetadata;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.http.JsonConnectionResponse;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.http.JsonHttpResponseHandler;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.http.JsonQueryRequest;
import com.amazon.opendistroforelasticsearch.jdbc.protocol.http.JsonQueryResponse;
import com.amazon.opendistroforelasticsearch.jdbc.transport.http.HttpParam;
import com.amazon.opendistroforelasticsearch.jdbc.transport.http.HttpTransport;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.fasterxml.jackson.databind.ObjectMapper;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.Header;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.client.methods.CloseableHttpResponse;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.message.BasicHeader;
import java.io.IOException;
import java.io.InputStream;

public class JsonHttpProtocol
implements Protocol {
    public static final String DEFAULT_SQL_CONTEXT_PATH = "/_opendistro/_sql";
    private static final Header acceptJson = new BasicHeader("Accept", "application/json");
    private static final Header contentTypeJson = new BasicHeader("Content-Type", "application/json");
    private static final HttpParam requestJdbcFormatParam = new HttpParam("format", "jdbc");
    protected static final Header[] defaultJsonHeaders = new Header[]{acceptJson, contentTypeJson};
    private static final Header[] defaultEmptyRequestBodyJsonHeaders = new Header[]{acceptJson};
    protected static final HttpParam[] defaultJdbcParams = new HttpParam[]{requestJdbcFormatParam};
    protected static final ObjectMapper mapper = new ObjectMapper();
    private String sqlContextPath;
    private HttpTransport transport;
    private JsonHttpResponseHandler jsonHttpResponseHandler;

    public JsonHttpProtocol(HttpTransport transport) {
        this(transport, DEFAULT_SQL_CONTEXT_PATH);
    }

    public JsonHttpProtocol(HttpTransport transport, String sqlContextPath) {
        this.transport = transport;
        this.sqlContextPath = sqlContextPath;
        this.jsonHttpResponseHandler = new JsonHttpResponseHandler(this);
    }

    public String getSqlContextPath() {
        return this.sqlContextPath;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public JsonHttpResponseHandler getJsonHttpResponseHandler() {
        return this.jsonHttpResponseHandler;
    }

    @Override
    public ConnectionResponse connect(int timeout) throws ResponseException, IOException {
        try (CloseableHttpResponse response = this.transport.doGet("/", defaultEmptyRequestBodyJsonHeaders, null, timeout);){
            ConnectionResponse connectionResponse = this.jsonHttpResponseHandler.handleResponse(response, this::processConnectionResponse);
            return connectionResponse;
        }
    }

    @Override
    public QueryResponse execute(QueryRequest request) throws ResponseException, IOException {
        try (CloseableHttpResponse response = this.transport.doPost(this.sqlContextPath, defaultJsonHeaders, defaultJdbcParams, this.buildQueryRequestBody(request), 0);){
            QueryResponse queryResponse = this.jsonHttpResponseHandler.handleResponse(response, this::processQueryResponse);
            return queryResponse;
        }
    }

    private String buildQueryRequestBody(QueryRequest queryRequest) throws IOException {
        JsonQueryRequest jsonQueryRequest = new JsonQueryRequest(queryRequest);
        String requestBody = mapper.writeValueAsString(jsonQueryRequest);
        return requestBody;
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    private JsonConnectionResponse processConnectionResponse(InputStream contentStream) throws IOException {
        ClusterMetadata clusterMetadata = mapper.readValue(contentStream, JsonClusterMetadata.class);
        return new JsonConnectionResponse(clusterMetadata);
    }

    private JsonQueryResponse processQueryResponse(InputStream contentStream) throws IOException {
        return mapper.readValue(contentStream, JsonQueryResponse.class);
    }
}

