/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.transport.http;

import com.amazon.opendistroforelasticsearch.jdbc.transport.http.LoggingManagedHttpClientConnection;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.commons.logging.Log;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.HttpRequest;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.HttpResponse;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.annotation.Contract;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.annotation.ThreadingBehavior;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.config.ConnectionConfig;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.HttpConnectionFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.ManagedHttpClientConnection;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.routing.HttpRoute;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.entity.ContentLengthStrategy;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.conn.DefaultHttpResponseParserFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.entity.LaxContentLengthStrategy;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.entity.StrictContentLengthStrategy;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.io.HttpMessageParserFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.io.HttpMessageWriterFactory;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.atomic.AtomicLong;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ApacheHttpClientConnectionFactory
implements HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> {
    private static final AtomicLong COUNTER = new AtomicLong();
    private Log log;
    private final HttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final HttpMessageParserFactory<HttpResponse> responseParserFactory;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;

    public ApacheHttpClientConnectionFactory(HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy) {
        this.requestWriterFactory = requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE;
        this.responseParserFactory = responseParserFactory != null ? responseParserFactory : DefaultHttpResponseParserFactory.INSTANCE;
        this.incomingContentStrategy = incomingContentStrategy != null ? incomingContentStrategy : LaxContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = outgoingContentStrategy != null ? outgoingContentStrategy : StrictContentLengthStrategy.INSTANCE;
    }

    public ApacheHttpClientConnectionFactory(HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        this(requestWriterFactory, responseParserFactory, null, null);
    }

    public ApacheHttpClientConnectionFactory(HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        this(null, responseParserFactory);
    }

    public ApacheHttpClientConnectionFactory() {
        this(null, null);
    }

    public ApacheHttpClientConnectionFactory(Log log) {
        this(null, null);
        this.log = log;
    }

    @Override
    public ManagedHttpClientConnection create(HttpRoute route, ConnectionConfig config) {
        CodingErrorAction unmappableInputAction;
        ConnectionConfig cconfig = config != null ? config : ConnectionConfig.DEFAULT;
        CharsetDecoder chardecoder = null;
        CharsetEncoder charencoder = null;
        Charset charset = cconfig.getCharset();
        CodingErrorAction malformedInputAction = cconfig.getMalformedInputAction() != null ? cconfig.getMalformedInputAction() : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction = unmappableInputAction = cconfig.getUnmappableInputAction() != null ? cconfig.getUnmappableInputAction() : CodingErrorAction.REPORT;
        if (charset != null) {
            chardecoder = charset.newDecoder();
            chardecoder.onMalformedInput(malformedInputAction);
            chardecoder.onUnmappableCharacter(unmappableInputAction);
            charencoder = charset.newEncoder();
            charencoder.onMalformedInput(malformedInputAction);
            charencoder.onUnmappableCharacter(unmappableInputAction);
        }
        String id = "http-outgoing-" + Long.toString(COUNTER.getAndIncrement());
        return new LoggingManagedHttpClientConnection(id, this.log, cconfig.getBufferSize(), cconfig.getFragmentSizeHint(), chardecoder, charencoder, cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestWriterFactory, this.responseParserFactory);
    }
}

