/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.transport.http;

import com.amazon.opendistroforelasticsearch.jdbc.auth.AuthenticationType;
import com.amazon.opendistroforelasticsearch.jdbc.config.ConnectionConfig;
import com.amazon.opendistroforelasticsearch.jdbc.logging.Logger;
import com.amazon.opendistroforelasticsearch.jdbc.logging.LoggingSource;
import com.amazon.opendistroforelasticsearch.jdbc.transport.TransportException;
import com.amazon.opendistroforelasticsearch.jdbc.transport.http.ApacheHttpClientConnectionFactory;
import com.amazon.opendistroforelasticsearch.jdbc.transport.http.HttpParam;
import com.amazon.opendistroforelasticsearch.jdbc.transport.http.HttpTransport;
import com.amazon.opendistroforelasticsearch.jdbc.transport.http.JclLoggerAdapter;
import com.amazon.opendistroforelasticsearch.jdbc.transport.http.auth.aws.AWSRequestSigningApacheInterceptor;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.auth.AWS4Signer;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.Header;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.auth.AuthScope;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.auth.UsernamePasswordCredentials;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.client.config.RequestConfig;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.client.methods.CloseableHttpResponse;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.client.methods.HttpGet;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.client.methods.HttpPost;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.client.utils.URIBuilder;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.config.Registry;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.config.RegistryBuilder;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.config.SocketConfig;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.HttpConnectionFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.ManagedHttpClientConnection;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.routing.HttpRoute;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.socket.ConnectionSocketFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.ssl.NoopHostnameVerifier;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.entity.ContentType;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.entity.StringEntity;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.client.BasicCredentialsProvider;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.client.CloseableHttpClient;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.client.HttpClientBuilder;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.client.HttpClients;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.ssl.SSLContextBuilder;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.ssl.SSLContexts;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.ssl.TrustStrategy;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class ApacheHttpTransport
implements HttpTransport,
LoggingSource {
    String scheme;
    String host;
    int port;
    String path;
    int readTimeout;
    private RequestConfig requestConfig;
    private CloseableHttpClient httpClient;

    public ApacheHttpTransport(ConnectionConfig connectionConfig, Logger log, String userAgent) throws TransportException {
        this.host = connectionConfig.getHost();
        this.port = connectionConfig.getPort();
        this.scheme = connectionConfig.isUseSSL() ? "https" : "http";
        this.path = connectionConfig.getPath();
        this.updateRequestConfig();
        ConnectionSocketFactory sslConnectionSocketFactory = null;
        try {
            sslConnectionSocketFactory = this.getSslConnectionSocketFactory(connectionConfig);
        }
        catch (Exception e) {
            throw new TransportException("Exception building SSL/TLS socket factory " + e, e);
        }
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)sslConnectionSocketFactory).build();
        ApacheHttpClientConnectionFactory connectionFactory = new ApacheHttpClientConnectionFactory(new JclLoggerAdapter(log, this.getSource()));
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(new BasicHttpClientConnectionManager(socketFactoryRegistry, (HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection>)connectionFactory)).setDefaultSocketConfig(this.buildDefaultSocketConfig()).setDefaultRequestConfig(this.getRequestConfig()).setUserAgent(userAgent);
        if (!connectionConfig.requestCompression()) {
            httpClientBuilder.disableContentCompression();
        }
        if (connectionConfig.getAuthenticationType() == AuthenticationType.BASIC) {
            BasicCredentialsProvider basicCredsProvider = new BasicCredentialsProvider();
            basicCredsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(connectionConfig.getUser(), connectionConfig.getPassword()));
            httpClientBuilder.setDefaultCredentialsProvider(basicCredsProvider);
        } else if (connectionConfig.getAuthenticationType() == AuthenticationType.AWS_SIGV4) {
            AWS4Signer signer = new AWS4Signer();
            signer.setServiceName("es");
            signer.setRegionName(connectionConfig.getRegion());
            AWSCredentialsProvider provider = connectionConfig.getAwsCredentialsProvider() != null ? connectionConfig.getAwsCredentialsProvider() : new DefaultAWSCredentialsProviderChain();
            httpClientBuilder.addInterceptorLast(new AWSRequestSigningApacheInterceptor("es", signer, provider));
        }
        this.httpClient = httpClientBuilder.build();
    }

    @Override
    public CloseableHttpResponse doGet(String path, Header[] headers, HttpParam[] params, int timeout) throws TransportException {
        return this.doGet(this.buildRequestURI(path, params), headers, timeout);
    }

    @Override
    public CloseableHttpResponse doPost(String path, Header[] headers, HttpParam[] params, String body, int timeout) throws TransportException {
        return this.doPost(this.buildRequestURI(path, params), headers, body, timeout);
    }

    @Override
    public void close() throws TransportException {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private ConnectionSocketFactory getSslConnectionSocketFactory(ConnectionConfig connectionConfig) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException, KeyManagementException {
        TrustSelfSignedStrategy trustStrategy = connectionConfig.trustSelfSigned() ? new TrustSelfSignedStrategy() : null;
        SSLContextBuilder builder = SSLContexts.custom();
        if (connectionConfig.getKeyStoreLocation() != null || connectionConfig.getTrustStoreLocation() != null) {
            char[] password;
            if (connectionConfig.getTrustStoreLocation() != null) {
                String trustStorePassword = connectionConfig.getTrustStorePassword();
                password = trustStorePassword == null ? "".toCharArray() : trustStorePassword.toCharArray();
                builder.loadTrustMaterial(new File(connectionConfig.getTrustStoreLocation()), password, (TrustStrategy)trustStrategy);
            }
            if (connectionConfig.getKeyStoreLocation() != null) {
                String keyStorePassword = connectionConfig.getKeyStorePassword();
                password = keyStorePassword == null ? "".toCharArray() : keyStorePassword.toCharArray();
                builder.loadKeyMaterial(new File(connectionConfig.getKeyStoreLocation()), password, password).build();
            }
        } else {
            builder.loadTrustMaterial(null, trustStrategy);
        }
        HostnameVerifier hostnameVerifier = connectionConfig.hostnameVerification() ? SSLConnectionSocketFactory.getDefaultHostnameVerifier() : new NoopHostnameVerifier();
        SSLContext sslContext = builder.build();
        return new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
    }

    private SocketConfig buildDefaultSocketConfig() {
        return SocketConfig.custom().setSoKeepAlive(true).setSoTimeout(this.readTimeout).build();
    }

    private void updateRequestConfig() {
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.readTimeout).build();
    }

    private RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        if (readTimeout != this.readTimeout) {
            this.readTimeout = readTimeout;
            this.updateRequestConfig();
        }
    }

    private URIBuilder getUriBuilder(String path) {
        return new URIBuilder().setScheme(this.scheme).setHost(this.host).setPort(this.port).setPath(this.path + path);
    }

    private URI buildRequestURI(String path, HttpParam ... params) throws TransportException {
        try {
            URIBuilder uriBuilder = this.getUriBuilder(path);
            if (params != null) {
                for (HttpParam param : params) {
                    uriBuilder.setParameter(param.getName(), param.getValue());
                }
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new TransportException(e);
        }
    }

    private CloseableHttpResponse doGet(URI uri, Header[] headers, int readTimeout) throws TransportException {
        try {
            this.setReadTimeout(readTimeout);
            HttpGet request = new HttpGet(uri);
            request.setHeaders(headers);
            request.setConfig(this.getRequestConfig());
            return this.httpClient.execute(request);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private CloseableHttpResponse doPost(URI uri, Header[] headers, String body, int readTimeout) throws TransportException {
        try {
            this.setReadTimeout(readTimeout);
            HttpPost request = new HttpPost(uri);
            request.setHeaders(headers);
            request.setEntity(new StringEntity(body, ContentType.APPLICATION_JSON));
            request.setConfig(this.getRequestConfig());
            return this.httpClient.execute(request);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }
}

