/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.transport.http.auth.aws;

import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.DefaultRequest;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.auth.Signer;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.HttpMethodName;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.Header;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.HttpEntityEnclosingRequest;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.HttpException;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.HttpHost;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.HttpRequest;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.HttpRequestInterceptor;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.NameValuePair;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.client.utils.URIBuilder;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.entity.BasicHttpEntity;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.message.BasicHeader;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AWSRequestSigningApacheInterceptor
implements HttpRequestInterceptor {
    private final String service;
    private final Signer signer;
    private final AWSCredentialsProvider awsCredentialsProvider;

    public AWSRequestSigningApacheInterceptor(String service, Signer signer, AWSCredentialsProvider awsCredentialsProvider) {
        this.service = service;
        this.signer = signer;
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntityEnclosingRequest httpEntityEnclosingRequest;
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(request.getRequestLine().getUri());
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI", e);
        }
        DefaultRequest signableRequest = new DefaultRequest(this.service);
        HttpHost host = (HttpHost)context.getAttribute("http.target_host");
        if (host != null) {
            signableRequest.setEndpoint(URI.create(host.toURI()));
        }
        HttpMethodName httpMethod = HttpMethodName.fromValue(request.getRequestLine().getMethod());
        signableRequest.setHttpMethod(httpMethod);
        try {
            signableRequest.setResourcePath(uriBuilder.build().getRawPath());
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI", e);
        }
        if (request instanceof HttpEntityEnclosingRequest && (httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            signableRequest.setContent(httpEntityEnclosingRequest.getEntity().getContent());
        }
        signableRequest.setParameters(AWSRequestSigningApacheInterceptor.nvpToMapParams(uriBuilder.getQueryParams()));
        signableRequest.setHeaders(AWSRequestSigningApacheInterceptor.headerArrayToMap(request.getAllHeaders()));
        this.signer.sign(signableRequest, this.awsCredentialsProvider.getCredentials());
        request.setHeaders(AWSRequestSigningApacheInterceptor.mapToHeaderArray(signableRequest.getHeaders()));
        if (request instanceof HttpEntityEnclosingRequest && (httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
            basicHttpEntity.setContent(signableRequest.getContent());
            httpEntityEnclosingRequest.setEntity(basicHttpEntity);
        }
    }

    private static Map<String, List<String>> nvpToMapParams(List<NameValuePair> params) {
        TreeMap<String, List<String>> parameterMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (NameValuePair nvp : params) {
            List argsList = parameterMap.computeIfAbsent(nvp.getName(), k -> new ArrayList());
            argsList.add(nvp.getValue());
        }
        return parameterMap;
    }

    private static Map<String, String> headerArrayToMap(Header[] headers) {
        TreeMap<String, String> headersMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : headers) {
            if (AWSRequestSigningApacheInterceptor.skipHeader(header)) continue;
            headersMap.put(header.getName(), header.getValue());
        }
        return headersMap;
    }

    private static boolean skipHeader(Header header) {
        return "content-length".equalsIgnoreCase(header.getName()) && "0".equals(header.getValue()) || "host".equalsIgnoreCase(header.getName());
    }

    private static Header[] mapToHeaderArray(Map<String, String> mapHeaders) {
        Header[] headers = new Header[mapHeaders.size()];
        int i = 0;
        for (Map.Entry<String, String> headerEntry : mapHeaders.entrySet()) {
            headers[i++] = new BasicHeader(headerEntry.getKey(), headerEntry.getValue());
        }
        return headers;
    }
}

