/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.types;

import com.amazon.opendistroforelasticsearch.jdbc.types.BooleanType;
import com.amazon.opendistroforelasticsearch.jdbc.types.ByteType;
import com.amazon.opendistroforelasticsearch.jdbc.types.DateType;
import com.amazon.opendistroforelasticsearch.jdbc.types.DoubleType;
import com.amazon.opendistroforelasticsearch.jdbc.types.FloatType;
import com.amazon.opendistroforelasticsearch.jdbc.types.IntegerType;
import com.amazon.opendistroforelasticsearch.jdbc.types.LongType;
import com.amazon.opendistroforelasticsearch.jdbc.types.ShortType;
import com.amazon.opendistroforelasticsearch.jdbc.types.StringType;
import com.amazon.opendistroforelasticsearch.jdbc.types.TimeType;
import com.amazon.opendistroforelasticsearch.jdbc.types.TimestampType;
import com.amazon.opendistroforelasticsearch.jdbc.types.TypeConverter;
import com.amazon.opendistroforelasticsearch.jdbc.types.TypeHelper;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class BaseTypeConverter
implements TypeConverter {
    static final Map<Class, TypeHelper> typeHandlerMap = new HashMap<Class, TypeHelper>();

    @Override
    public <T> T convert(Object value, Class<T> clazz, Map<String, Object> conversionParams) throws SQLException {
        TypeHelper<T> typeHelper;
        if (clazz == null) {
            clazz = this.getDefaultJavaClass();
        }
        if (this.getSupportedJavaClasses() != null && this.getSupportedJavaClasses().contains(clazz) && (typeHelper = this.getTypeHelper(clazz)) != null) {
            return typeHelper.fromValue(value, conversionParams);
        }
        throw this.objectConversionException(value, clazz);
    }

    private <T> TypeHelper<T> getTypeHelper(Class<T> clazz) {
        return typeHandlerMap.get(clazz);
    }

    public abstract Class getDefaultJavaClass();

    public abstract Set<Class> getSupportedJavaClasses();

    static {
        typeHandlerMap.put(String.class, StringType.INSTANCE);
        typeHandlerMap.put(Byte.class, ByteType.INSTANCE);
        typeHandlerMap.put(Short.class, ShortType.INSTANCE);
        typeHandlerMap.put(Integer.class, IntegerType.INSTANCE);
        typeHandlerMap.put(Long.class, LongType.INSTANCE);
        typeHandlerMap.put(Float.class, FloatType.INSTANCE);
        typeHandlerMap.put(Double.class, DoubleType.INSTANCE);
        typeHandlerMap.put(Boolean.class, BooleanType.INSTANCE);
        typeHandlerMap.put(Timestamp.class, TimestampType.INSTANCE);
        typeHandlerMap.put(Date.class, DateType.INSTANCE);
        typeHandlerMap.put(Time.class, TimeType.INSTANCE);
    }
}

