/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.types;

import com.amazon.opendistroforelasticsearch.jdbc.types.TypeHelper;
import java.sql.SQLException;
import java.util.Map;

public class BooleanType
implements TypeHelper<Boolean> {
    public static final BooleanType INSTANCE = new BooleanType();

    private BooleanType() {
    }

    @Override
    public Boolean fromValue(Object value, Map<String, Object> conversionParams) throws SQLException {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return this.asBoolean((String)value);
        }
        throw this.objectConversionException(value);
    }

    private Boolean asBoolean(String value) throws SQLException {
        try {
            return Boolean.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw this.stringConversionException(value, nfe);
        }
    }

    @Override
    public String getTypeName() {
        return "Boolean";
    }
}

