/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.types;

import com.amazon.opendistroforelasticsearch.jdbc.types.TypeHelper;
import java.sql.Date;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Map;

public class DateType
implements TypeHelper<Date> {
    public static final DateType INSTANCE = new DateType();

    private DateType() {
    }

    @Override
    public Date fromValue(Object value, Map<String, Object> conversionParams) throws SQLException {
        Calendar calendar;
        if (value == null) {
            return null;
        }
        Calendar calendar2 = calendar = conversionParams != null ? (Calendar)conversionParams.get("calendar") : null;
        if (value instanceof Date) {
            return this.asDate((Date)value, calendar);
        }
        if (value instanceof String) {
            return this.asDate((String)value, calendar);
        }
        if (value instanceof Number) {
            return this.asDate((Number)value);
        }
        throw this.objectConversionException(value);
    }

    public Date asDate(Date value, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return value;
        }
        return this.localDatetoSqlDate(value.toLocalDate(), calendar);
    }

    public Date asDate(String value, Calendar calendar) throws SQLException {
        try {
            if (calendar == null) {
                return Date.valueOf(this.toLocalDate(value));
            }
            return this.localDatetoSqlDate(this.toLocalDate(value), calendar);
        }
        catch (DateTimeParseException dpe) {
            throw this.stringConversionException(value, dpe);
        }
    }

    private Date localDatetoSqlDate(LocalDate localDate, Calendar calendar) {
        calendar.set(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth(), 0, 0, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public Date asDate(Number value) {
        return new Date(value.longValue());
    }

    private LocalDate toLocalDate(String value) throws SQLException {
        if (value == null || value.length() < 10) {
            throw this.stringConversionException(value, null);
        }
        return LocalDate.parse(value.substring(0, 10));
    }

    @Override
    public String getTypeName() {
        return "Date";
    }
}

