/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.types;

import com.amazon.opendistroforelasticsearch.jdbc.types.UnrecognizedElasticsearchTypeException;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum ElasticsearchType {
    BOOLEAN(JDBCType.BOOLEAN, Boolean.class, 1, 1, false),
    BYTE(JDBCType.TINYINT, Byte.class, 3, 5, true),
    SHORT(JDBCType.SMALLINT, Short.class, 5, 6, true),
    INTEGER(JDBCType.INTEGER, Integer.class, 10, 11, true),
    LONG(JDBCType.BIGINT, Long.class, 19, 20, true),
    HALF_FLOAT(JDBCType.REAL, Float.class, 7, 15, true),
    FLOAT(JDBCType.REAL, Float.class, 7, 15, true),
    DOUBLE(JDBCType.DOUBLE, Double.class, 15, 25, true),
    SCALED_FLOAT(JDBCType.DOUBLE, Double.class, 15, 25, true),
    KEYWORD(JDBCType.VARCHAR, String.class, 256, 0, false),
    TEXT(JDBCType.VARCHAR, String.class, Integer.MAX_VALUE, 0, false),
    STRING(JDBCType.VARCHAR, String.class, Integer.MAX_VALUE, 0, false),
    IP(JDBCType.VARCHAR, String.class, 15, 0, false),
    NESTED(JDBCType.STRUCT, null, 0, 0, false),
    OBJECT(JDBCType.STRUCT, null, 0, 0, false),
    DATE(JDBCType.DATE, Date.class, 24, 24, false),
    TIME(JDBCType.TIME, Time.class, 24, 24, false),
    TIMESTAMP(JDBCType.TIMESTAMP, Timestamp.class, 24, 24, false),
    BINARY(JDBCType.VARBINARY, String.class, Integer.MAX_VALUE, 0, false),
    NULL(JDBCType.NULL, null, 0, 0, false),
    UNDEFINED(JDBCType.NULL, null, 0, 0, false),
    UNSUPPORTED(JDBCType.OTHER, null, 0, 0, false);

    private static final Map<JDBCType, ElasticsearchType> jdbcTypeToESTypeMap;
    private final String typeName = this.name().toLowerCase(Locale.ROOT);
    private final JDBCType jdbcType;
    private final String javaClassName;
    private final int precision;
    private final int displaySize;
    private final boolean isSigned;

    private ElasticsearchType(JDBCType jdbcType, Class<?> javaClass, int precision, int displaySize, boolean isSigned) {
        this.jdbcType = jdbcType;
        this.javaClassName = javaClass == null ? null : javaClass.getName();
        this.precision = precision;
        this.displaySize = displaySize;
        this.isSigned = isSigned;
    }

    public static ElasticsearchType fromJdbcType(JDBCType jdbcType) {
        if (!jdbcTypeToESTypeMap.containsKey(jdbcType)) {
            throw new IllegalArgumentException("Unsupported JDBC type \"" + jdbcType + "\"");
        }
        return jdbcTypeToESTypeMap.get(jdbcType);
    }

    public static ElasticsearchType fromTypeName(String typeName) {
        return ElasticsearchType.fromTypeName(typeName, false);
    }

    public static ElasticsearchType fromTypeName(String typeName, boolean errorOnUnknownType) {
        try {
            return ElasticsearchType.valueOf(typeName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException iae) {
            if (errorOnUnknownType) {
                throw new UnrecognizedElasticsearchTypeException("Unknown Type: \"" + typeName + "\"", iae);
            }
            return UNSUPPORTED;
        }
    }

    public int sqlTypeNumber() {
        return this.jdbcType.getVendorTypeNumber();
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    static {
        jdbcTypeToESTypeMap = new HashMap<JDBCType, ElasticsearchType>();
        jdbcTypeToESTypeMap.put(JDBCType.NULL, UNDEFINED);
        jdbcTypeToESTypeMap.put(JDBCType.BOOLEAN, BOOLEAN);
        jdbcTypeToESTypeMap.put(JDBCType.TINYINT, BYTE);
        jdbcTypeToESTypeMap.put(JDBCType.SMALLINT, SHORT);
        jdbcTypeToESTypeMap.put(JDBCType.INTEGER, INTEGER);
        jdbcTypeToESTypeMap.put(JDBCType.BIGINT, LONG);
        jdbcTypeToESTypeMap.put(JDBCType.DOUBLE, DOUBLE);
        jdbcTypeToESTypeMap.put(JDBCType.REAL, FLOAT);
        jdbcTypeToESTypeMap.put(JDBCType.FLOAT, DOUBLE);
        jdbcTypeToESTypeMap.put(JDBCType.VARCHAR, KEYWORD);
        jdbcTypeToESTypeMap.put(JDBCType.TIMESTAMP, TIMESTAMP);
        jdbcTypeToESTypeMap.put(JDBCType.TIME, TIME);
        jdbcTypeToESTypeMap.put(JDBCType.DATE, DATE);
        jdbcTypeToESTypeMap.put(JDBCType.VARBINARY, BINARY);
    }
}

