/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.types;

import com.amazon.opendistroforelasticsearch.jdbc.types.NumberType;
import java.sql.SQLException;
import java.util.Map;

public class IntegerType
extends NumberType<Integer> {
    public static final IntegerType INSTANCE = new IntegerType();

    private IntegerType() {
    }

    @Override
    public Integer fromValue(Object value, Map<String, Object> conversionParams) throws SQLException {
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return this.asInteger((String)value);
        }
        if (value instanceof Number) {
            return this.asInteger((Number)value);
        }
        throw this.objectConversionException(value);
    }

    private Integer asInteger(String value) throws SQLException {
        try {
            return this.asInteger(Double.valueOf(value));
        }
        catch (NumberFormatException nfe) {
            throw this.stringConversionException(value, nfe);
        }
    }

    private Integer asInteger(Number value) throws SQLException {
        return (int)this.getDoubleValueWithinBounds(value, -2.147483648E9, 2.147483647E9);
    }

    @Override
    public String getTypeName() {
        return "Integer";
    }
}

