/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.types;

import com.amazon.opendistroforelasticsearch.jdbc.types.NumberType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Map;

public class LongType
extends NumberType<Long> {
    public static final LongType INSTANCE = new LongType();

    private LongType() {
    }

    @Override
    public Long fromValue(Object value, Map<String, Object> conversionParams) throws SQLException {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return this.asLong((String)value);
        }
        if (value instanceof Number) {
            return this.asLong((Number)value);
        }
        throw this.objectConversionException(value);
    }

    private Long asLong(String value) throws SQLException {
        try {
            if (value.length() > 14) {
                BigDecimal bd = new BigDecimal(value);
                bd = bd.setScale(0, RoundingMode.HALF_UP);
                return bd.longValueExact();
            }
            return this.asLong(Double.valueOf(value));
        }
        catch (ArithmeticException | NumberFormatException ex) {
            throw this.stringConversionException(value, ex);
        }
    }

    private Long asLong(Number value) throws SQLException {
        return (long)this.getDoubleValueWithinBounds(value, -9.223372036854776E18, 9.223372036854776E18);
    }

    @Override
    public String getTypeName() {
        return "Long";
    }
}

