/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.jdbc.types;

import com.amazon.opendistroforelasticsearch.jdbc.types.TypeHelper;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalTime;
import java.util.Map;

public class TimeType
implements TypeHelper<Time> {
    public static final TimeType INSTANCE = new TimeType();

    private TimeType() {
    }

    @Override
    public Time fromValue(Object value, Map<String, Object> conversionParams) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            return this.asTime((Time)value);
        }
        if (value instanceof String) {
            return this.asTime((String)value);
        }
        if (value instanceof Number) {
            return this.asTime((Number)value);
        }
        throw this.objectConversionException(value);
    }

    public Time asTime(Time value) {
        return this.localTimetoSqlTime(value.toLocalTime());
    }

    public Time asTime(String value) throws SQLException {
        return this.localTimetoSqlTime(this.toLocalTime(value));
    }

    private Time localTimetoSqlTime(LocalTime localTime) {
        return new Time(localTime.getHour(), localTime.getMinute(), localTime.getSecond());
    }

    public Time asTime(Number value) {
        return new Time(value.longValue());
    }

    private LocalTime toLocalTime(String value) throws SQLException {
        if (value == null) {
            throw this.stringConversionException(value, null);
        }
        return LocalTime.parse(value);
    }

    @Override
    public String getTypeName() {
        return "Time";
    }
}

