/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.auth;

import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.SdkClientException;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.auth.AWSCredentials;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.internal.CredentialsEndpointProvider;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.internal.EC2CredentialsUtils;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.util.DateUtils;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.util.json.Jackson;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.fasterxml.jackson.databind.JsonNode;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.commons.logging.Log;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;

@SdkInternalApi
class EC2CredentialsFetcher {
    private static final Log LOG = LogFactory.getLog(EC2CredentialsFetcher.class);
    private static final int REFRESH_THRESHOLD = 3600000;
    private static final int EXPIRATION_THRESHOLD = 900000;
    private static final String ACCESS_KEY_ID = "AccessKeyId";
    private static final String SECRET_ACCESS_KEY = "SecretAccessKey";
    private static final String TOKEN = "Token";
    private volatile AWSCredentials credentials;
    private volatile Date credentialsExpiration;
    protected volatile Date lastInstanceProfileCheck;
    private final CredentialsEndpointProvider credentialsEndpointProvider;

    public EC2CredentialsFetcher(CredentialsEndpointProvider credentialsEndpointProvider) {
        this.credentialsEndpointProvider = credentialsEndpointProvider;
    }

    public AWSCredentials getCredentials() {
        if (this.needsToLoadCredentials()) {
            this.fetchCredentials();
        }
        if (this.expired()) {
            throw new SdkClientException("The credentials received have been expired");
        }
        return this.credentials;
    }

    protected boolean needsToLoadCredentials() {
        if (this.credentials == null) {
            return true;
        }
        if (this.credentialsExpiration != null && this.isWithinExpirationThreshold()) {
            return true;
        }
        return this.lastInstanceProfileCheck != null && this.isPastRefreshThreshold();
    }

    private synchronized void fetchCredentials() {
        if (!this.needsToLoadCredentials()) {
            return;
        }
        try {
            this.lastInstanceProfileCheck = new Date();
            String credentialsResponse = EC2CredentialsUtils.getInstance().readResource(this.credentialsEndpointProvider.getCredentialsEndpoint(), this.credentialsEndpointProvider.getRetryPolicy(), this.credentialsEndpointProvider.getHeaders());
            JsonNode node = Jackson.jsonNodeOf(credentialsResponse);
            JsonNode accessKey = node.get(ACCESS_KEY_ID);
            JsonNode secretKey = node.get(SECRET_ACCESS_KEY);
            JsonNode token = node.get(TOKEN);
            if (null == accessKey || null == secretKey) {
                throw new SdkClientException("Unable to load credentials.");
            }
            this.credentials = null != token ? new BasicSessionCredentials(accessKey.asText(), secretKey.asText(), token.asText()) : new BasicAWSCredentials(accessKey.asText(), secretKey.asText());
            JsonNode expirationJsonNode = node.get("Expiration");
            if (null != expirationJsonNode) {
                String expiration = expirationJsonNode.asText();
                expiration = expiration.replaceAll("\\+0000$", "Z");
                try {
                    this.credentialsExpiration = DateUtils.parseISO8601Date(expiration);
                }
                catch (Exception ex) {
                    this.handleError("Unable to parse credentials expiration date from Amazon EC2 instance", ex);
                }
            }
        }
        catch (JsonMappingException e) {
            this.handleError("Unable to parse response returned from service endpoint", e);
        }
        catch (IOException e) {
            this.handleError("Unable to load credentials from service endpoint", e);
        }
        catch (URISyntaxException e) {
            this.handleError("Unable to load credentials from service endpoint", e);
        }
    }

    private void handleError(String errorMessage, Exception e) {
        if (this.credentials == null || this.expired()) {
            throw new SdkClientException(errorMessage, e);
        }
        LOG.debug(errorMessage, e);
    }

    public void refresh() {
        this.credentials = null;
    }

    private boolean isWithinExpirationThreshold() {
        return this.credentialsExpiration.getTime() - System.currentTimeMillis() < 900000L;
    }

    private boolean isPastRefreshThreshold() {
        return System.currentTimeMillis() - this.lastInstanceProfileCheck.getTime() > 3600000L;
    }

    private boolean expired() {
        return this.credentialsExpiration != null && this.credentialsExpiration.getTime() < System.currentTimeMillis();
    }

    public Date getCredentialsExpiration() {
        return this.credentialsExpiration;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

