/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.apache.client.impl;

import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.apache.SdkProxyRoutePlanner;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.apache.client.impl.ApacheConnectionManagerFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.apache.client.impl.CRC32ChecksumResponseInterceptor;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.apache.client.impl.SdkHttpClient;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.apache.utils.ApacheUtils;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.client.ConnectionManagerFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.client.HttpClientFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.conn.ClientConnectionManagerFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.conn.SdkConnectionKeepAliveStrategy;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.protocol.SdkHttpRequestExecutor;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.http.settings.HttpClientSettings;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.commons.logging.Log;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.commons.logging.LogFactory;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.ConnectionKeepAliveStrategy;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.conn.HttpClientConnectionManager;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.client.HttpClientBuilder;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.client.HttpClients;

public class ApacheHttpClientFactory
implements HttpClientFactory<ConnectionManagerAwareHttpClient> {
    private static final Log LOG = LogFactory.getLog(AmazonHttpClient.class);
    private final ConnectionManagerFactory<HttpClientConnectionManager> cmFactory = new ApacheConnectionManagerFactory();

    @Override
    public ConnectionManagerAwareHttpClient create(HttpClientSettings settings) {
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = this.cmFactory.create(settings);
        builder.setRequestExecutor(new SdkHttpRequestExecutor()).setKeepAliveStrategy(this.buildKeepAliveStrategy(settings)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        if (!settings.useGzip()) {
            builder.disableContentCompression();
        }
        CRC32ChecksumResponseInterceptor itcp = new CRC32ChecksumResponseInterceptor();
        if (settings.calculateCRC32FromCompressedData()) {
            builder.addInterceptorFirst(itcp);
        } else {
            builder.addInterceptorLast(itcp);
        }
        this.addProxyConfig(builder, settings);
        SdkHttpClient httpClient = new SdkHttpClient(builder.build(), cm);
        if (settings.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(cm, settings.getMaxIdleConnectionTime());
        }
        return httpClient;
    }

    private void addProxyConfig(HttpClientBuilder builder, HttpClientSettings settings) {
        if (settings.isProxyEnabled()) {
            LOG.info("Configuring Proxy. Proxy Host: " + settings.getProxyHost() + " Proxy Port: " + settings.getProxyPort());
            builder.setRoutePlanner(new SdkProxyRoutePlanner(settings.getProxyHost(), settings.getProxyPort(), settings.getProxyProtocol(), settings.getNonProxyHosts()));
            if (settings.isAuthenticatedProxy()) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(settings));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(HttpClientSettings settings) {
        return settings.getMaxIdleConnectionTime() > 0L ? new SdkConnectionKeepAliveStrategy(settings.getMaxIdleConnectionTime()) : null;
    }
}

