/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.monitoring;

import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.SdkClientException;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.monitoring.CsmConfiguration;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.monitoring.CsmConfigurationProvider;

@ThreadSafe
public final class SystemPropertyCsmConfigurationProvider
implements CsmConfigurationProvider {
    @Override
    public CsmConfiguration getConfiguration() throws SdkClientException {
        String enabled = System.getProperty("com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.sdk.csm.enabled");
        if (enabled == null) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from system properties variables!");
        }
        String port = System.getProperty("com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.sdk.csm.port");
        String clientId = System.getProperty("com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.sdk.csm.clientId", "");
        try {
            int portNumber = port == null ? 31000 : Integer.parseInt(port);
            return new CsmConfiguration(Boolean.parseBoolean(enabled), portNumber, clientId);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from system properties variables!", e);
        }
    }
}

