/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.partitions;

import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.partitions.PartitionRegionImpl;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.partitions.model.Partition;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.partitions.model.Region;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.AbstractRegionMetadataProvider;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SdkInternalApi
public class PartitionMetadataProvider
extends AbstractRegionMetadataProvider {
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region> regionCache = new ConcurrentHashMap<String, com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region>();

    public PartitionMetadataProvider(List<Partition> partitions) {
        ValidationUtils.assertNotNull(partitions, "partitions");
        for (Partition p : partitions) {
            this.partitionMap.put(p.getPartition(), p);
        }
    }

    @Override
    public List<com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region> getRegions() {
        ArrayList<com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region> regions = new ArrayList<com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region>();
        for (Partition p : this.partitionMap.values()) {
            for (Map.Entry<String, Region> entry : p.getRegions().entrySet()) {
                regions.add(new com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region(new PartitionRegionImpl(entry.getKey(), p)));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region getRegion(String regionName) {
        if (regionName == null) {
            return null;
        }
        com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region regionFromCache = this.getRegionFromCache(regionName);
        if (regionFromCache != null) {
            return regionFromCache;
        }
        return this.createNewRegion(regionName);
    }

    private com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region createNewRegion(String regionName) {
        for (Partition p : this.partitionMap.values()) {
            if (!p.hasRegion(regionName)) continue;
            return this.cacheRegion(new PartitionRegionImpl(regionName, p));
        }
        Partition awsPartition = this.partitionMap.get("aws");
        if (awsPartition != null) {
            return this.cacheRegion(new PartitionRegionImpl(regionName, awsPartition));
        }
        return null;
    }

    private com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region getRegionFromCache(String regionName) {
        return this.regionCache.get(regionName);
    }

    private com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region cacheRegion(PartitionRegionImpl regionImpl) {
        com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region region = new com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region(regionImpl);
        this.regionCache.put(region.getName(), region);
        return region;
    }

    @Override
    public List<com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region> getRegionsForService(String serviceName) {
        List<com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region> allRegions = this.getRegions();
        ArrayList<com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region> serviceSupportedRegions = new ArrayList<com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region>();
        for (com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.regions.Region r : allRegions) {
            if (!r.isServiceSupported(serviceName)) continue;
            serviceSupportedRegions.add(r);
        }
        return serviceSupportedRegions;
    }
}

