/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.retry;

import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.AmazonClientException;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.ClientConfiguration;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.retry.v2.RetryPolicy;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.retry.v2.RetryPolicyContext;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class RetryPolicyAdapter
implements RetryPolicy {
    private final com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.retry.RetryPolicy legacyRetryPolicy;
    private final ClientConfiguration clientConfiguration;

    public RetryPolicyAdapter(com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.retry.RetryPolicy legacyRetryPolicy, ClientConfiguration clientConfiguration) {
        this.legacyRetryPolicy = ValidationUtils.assertNotNull(legacyRetryPolicy, "legacyRetryPolicy");
        this.clientConfiguration = ValidationUtils.assertNotNull(clientConfiguration, "clientConfiguration");
    }

    @Override
    public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getBackoffStrategy().delayBeforeNextRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return !this.maxRetriesExceeded(context) && this.isRetryable(context);
    }

    public boolean isRetryable(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getRetryCondition().shouldRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    public com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.com.amazonaws.retry.RetryPolicy getLegacyRetryPolicy() {
        return this.legacyRetryPolicy;
    }

    private int getMaxErrorRetry() {
        if (this.legacyRetryPolicy.isMaxErrorRetryInClientConfigHonored() && this.clientConfiguration.getMaxErrorRetry() >= 0) {
            return this.clientConfiguration.getMaxErrorRetry();
        }
        return this.legacyRetryPolicy.getMaxErrorRetry();
    }

    public boolean maxRetriesExceeded(RetryPolicyContext context) {
        return context.retriesAttempted() >= this.getMaxErrorRetry();
    }
}

