/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.cookie;

import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.annotation.Contract;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.annotation.ThreadingBehavior;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.cookie.Cookie;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.cookie.CookieOrigin;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.cookie.MalformedCookieException;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.cookie.SetCookie;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.amazonaws.opendistro.elasticsearch.sql.jdbc.shadow.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

