/*
 * Copyright (c) 2016, PostgreSQL Global Development Group
 * See the LICENSE file in the project root for more information.
 */

package com.amazon.redshift.core.v3;

import com.amazon.redshift.copy.CopyDual;
import com.amazon.redshift.util.ByteStreamWriter;
import com.amazon.redshift.util.RedshiftException;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Queue;

public class CopyDualImpl extends CopyOperationImpl implements CopyDual {
  private Queue<byte[]> received = new LinkedList<byte[]>();

  public void writeToCopy(byte[] data, int off, int siz) throws SQLException {
    queryExecutor.writeToCopy(this, data, off, siz);
  }

  public void writeToCopy(ByteStreamWriter from) throws SQLException {
    queryExecutor.writeToCopy(this, from);
  }

  public void flushCopy() throws SQLException {
    queryExecutor.flushCopy(this);
  }

  public long endCopy() throws SQLException {
    return queryExecutor.endCopy(this);
  }

  public byte[] readFromCopy() throws SQLException {
    return readFromCopy(true);
  }

  @Override
  public byte[] readFromCopy(boolean block) throws SQLException {
    if (received.isEmpty()) {
      queryExecutor.readFromCopy(this, block);
    }

    return received.poll();
  }

  @Override
  public void handleCommandStatus(String status) throws RedshiftException {
  }

  protected void handleCopydata(byte[] data) {
    received.add(data);
  }
}
