/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.jdbc.MetadataAPIHelper;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.RedshiftException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class MetadataServerAPIHelper
extends MetadataAPIHelper {
    public MetadataServerAPIHelper(RedshiftConnectionImpl connection) {
        super(connection);
    }

    protected ResultSet getCatalogsServerAPI(String catalog) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling Server API SHOW DATABASES", new Object[0]);
        }
        String sql = null;
        ResultSet rs = null;
        sql = catalog == null ? "SHOW DATABASES;" : MessageFormat.format("SHOW DATABASES LIKE ''{0}'';", catalog);
        rs = this.runQuery(sql);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Successfully executed SHOW DATABASE for catalog = {0}", catalog);
        }
        return rs;
    }

    protected List<ResultSet> getSchemasServerAPI(String catalog, String schemaPattern, boolean retEmpty, boolean isSingleDatabaseMetaData) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling Server API SHOW SCHEMAS", new Object[0]);
        }
        ArrayList<ResultSet> intermediateRs = new ArrayList<ResultSet>();
        if (!retEmpty) {
            List<Object> catalogList;
            try {
                if (this.checkNameIsExactName(catalog)) {
                    catalogList = new ArrayList<String>();
                    catalogList.add(catalog);
                } else {
                    catalogList = this.getCatalogList(catalog, isSingleDatabaseMetaData);
                }
            }
            catch (Exception e) {
                throw new RedshiftException("MetadataServerAPIHelper.getSchemasServerAPI.getCatalogList " + e.getMessage());
            }
            if (catalogList == null) {
                throw new RedshiftException("Error when creating catalogList ... ");
            }
            for (String string : catalogList) {
                intermediateRs.add(this.callShowSchemas(string, schemaPattern));
            }
            if (RedshiftLogger.isEnable()) {
                this.connection.getLogger().logDebug("Successfully executed SHOW SCHEMAS for catalog = {0}, schemaPattern = {1}", catalog, schemaPattern);
            }
        }
        return intermediateRs;
    }

    protected List<ResultSet> getTablesServerAPI(String catalog, String schemaPattern, String tableNamePattern, boolean retEmpty, boolean isSingleDatabaseMetaData) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling Server API SHOW TABLES", new Object[0]);
        }
        ArrayList<ResultSet> intermediateRs = new ArrayList<ResultSet>();
        if (!retEmpty) {
            List<Object> catalogList;
            try {
                if (this.checkNameIsExactName(catalog)) {
                    catalogList = new ArrayList<String>();
                    catalogList.add(catalog);
                } else {
                    catalogList = this.getCatalogList(catalog, isSingleDatabaseMetaData);
                }
            }
            catch (Exception e) {
                throw new RedshiftException("MetadataServerAPIHelper.getTablesServerAPI.getCatalogList " + e.getMessage());
            }
            if (catalogList == null) {
                throw new RedshiftException("Error when creating catalogList ... ");
            }
            for (String string : catalogList) {
                if (this.checkNameIsExactName(schemaPattern) && catalogList.size() == 1) {
                    intermediateRs.add(this.callShowTables(string, schemaPattern, tableNamePattern));
                    continue;
                }
                ResultSet schemasRs = this.callShowSchemas(string, schemaPattern);
                while (schemasRs.next()) {
                    intermediateRs.add(this.callShowTables(string, schemasRs.getString("schema_name"), tableNamePattern));
                }
            }
            if (RedshiftLogger.isEnable()) {
                this.connection.getLogger().logDebug("Successfully executed SHOW TABLES for catalog = {0}, schemaPattern = {1}, tableNamePattern = {2}", catalog, schemaPattern, tableNamePattern);
            }
        }
        return intermediateRs;
    }

    protected List<ResultSet> getColumnsServerAPI(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, boolean retEmpty, boolean isSingleDatabaseMetaData) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling Server API SHOW COLUMNS", new Object[0]);
        }
        ArrayList<ResultSet> intermediateRs = new ArrayList<ResultSet>();
        if (!retEmpty) {
            List<Object> catalogList;
            try {
                if (this.checkNameIsExactName(catalog)) {
                    catalogList = new ArrayList<String>();
                    catalogList.add(catalog);
                } else {
                    catalogList = this.getCatalogList(catalog, isSingleDatabaseMetaData);
                }
            }
            catch (Exception e) {
                throw new RedshiftException("MetadataServerAPIHelper.getColumnsServerAPI.getCatalogList " + e.getMessage());
            }
            if (catalogList == null) {
                throw new RedshiftException("Error when creating catalogList ... ");
            }
            for (String string : catalogList) {
                if (this.checkNameIsExactName(schemaPattern) && catalogList.size() == 1) {
                    if (this.checkNameIsExactName(tableNamePattern)) {
                        intermediateRs.add(this.callShowColumns(string, schemaPattern, tableNamePattern, columnNamePattern));
                        continue;
                    }
                    ResultSet tablesRs = this.callShowTables(string, schemaPattern, tableNamePattern);
                    while (tablesRs.next()) {
                        intermediateRs.add(this.callShowColumns(string, schemaPattern, tablesRs.getString("table_name"), columnNamePattern));
                    }
                    continue;
                }
                ResultSet schemasRs = this.callShowSchemas(string, schemaPattern);
                while (schemasRs.next()) {
                    if (this.checkNameIsExactName(tableNamePattern)) {
                        intermediateRs.add(this.callShowColumns(string, schemasRs.getString("schema_name"), tableNamePattern, columnNamePattern));
                        continue;
                    }
                    ResultSet tablesRs = this.callShowTables(string, schemasRs.getString("schema_name"), tableNamePattern);
                    while (tablesRs.next()) {
                        intermediateRs.add(this.callShowColumns(string, schemasRs.getString("schema_name"), tablesRs.getString("table_name"), columnNamePattern));
                    }
                }
            }
            if (RedshiftLogger.isEnable()) {
                this.connection.getLogger().logDebug("Successfully executed SHOW COLUMNS for catalog = {0}, schema = {1}, tableName = {2}, columnNamePattern = {3}", catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
        }
        return intermediateRs;
    }

    protected List<String> getCatalogList(String catalog, boolean isSingleDatabaseMetaData) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Create catalog list for catalog = {0}", catalog);
        }
        String curConnectedCatalog = this.connection.getCatalog();
        ArrayList<String> catalogList = new ArrayList<String>();
        ResultSet catalogRs = this.getCatalogsServerAPI(catalog);
        while (catalogRs.next()) {
            if (isSingleDatabaseMetaData) {
                String curCatalog = catalogRs.getString("database_name");
                if (!curCatalog.equals(curConnectedCatalog)) continue;
                catalogList.add(curCatalog);
                continue;
            }
            catalogList.add(catalogRs.getString("database_name"));
        }
        return catalogList;
    }

    protected ResultSet callShowSchemas(String catalog, String schema) throws SQLException {
        String sqlSCHEMA = this.checkNameIsNotPattern(schema) ? MessageFormat.format("SHOW SCHEMAS FROM DATABASE {0};", catalog) : MessageFormat.format("SHOW SCHEMAS FROM DATABASE {0} LIKE ''{1}'';", catalog, schema);
        return this.runQuery(sqlSCHEMA);
    }

    protected ResultSet callShowTables(String catalog, String schema, String table) throws SQLException {
        String sqlTABLE = this.checkNameIsNotPattern(table) ? MessageFormat.format("SHOW TABLES FROM SCHEMA {0}.{1};", catalog, schema) : MessageFormat.format("SHOW TABLES FROM SCHEMA {0}.{1} LIKE ''{2}'';", catalog, schema, table);
        return this.runQuery(sqlTABLE);
    }

    protected ResultSet callShowColumns(String catalog, String schema, String table, String column) throws SQLException {
        String sqlCOLUMN = this.checkNameIsNotPattern(column) ? MessageFormat.format("SHOW COLUMNS FROM TABLE {0}.{1}.{2};", catalog, schema, table) : MessageFormat.format("SHOW COLUMNS FROM TABLE {0}.{1}.{2} LIKE ''{3}'';", catalog, schema, table, column);
        return this.runQuery(sqlCOLUMN);
    }
}

