/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.ssl.NonValidatingFactory;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;

abstract class IdpCredentialsProvider {
    protected static final String KEY_SSL_INSECURE = "ssl_insecure";
    protected boolean m_sslInsecure;

    IdpCredentialsProvider() {
    }

    protected CloseableHttpClient getHttpClient() throws GeneralSecurityException {
        RequestConfig rc = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setExpectContinueEnabled(false).setCookieSpec("standard").build();
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(rc).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).useSystemProperties();
        if (this.m_sslInsecure) {
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            TrustManager[] tma = new TrustManager[]{new NonValidatingFactory.NonValidatingTM()};
            ctx.init(null, tma, null);
            SSLSocketFactory factory = ctx.getSocketFactory();
            SSLConnectionSocketFactory sf = new SSLConnectionSocketFactory(factory, (HostnameVerifier)new NoopHostnameVerifier());
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sf);
        }
        return builder.build();
    }
}

