/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.manualtest;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import com.amazonaws.services.dynamodbv2.local.manualtest.BatchExecuteStatement;
import com.amazonaws.services.dynamodbv2.model.CancellationReason;
import com.amazonaws.services.dynamodbv2.model.ExecuteTransactionResult;
import com.amazonaws.services.dynamodbv2.model.ParameterizedStatement;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;

public class PartiQLTransaction {
    public static void main(String[] args2) throws Exception {
        String tableName = "GameScores";
        System.out.println("Testings DynamoDB Local Embedded - SDK v1");
        AmazonDynamoDB clientV1LocalEmbedded = DynamoDBEmbedded.create().amazonDynamoDB();
        DynamoDbClient dynamoDbClientv2LocalEmbedded = DynamoDbClient.create();
        BatchExecuteStatement.createTableV1(clientV1LocalEmbedded, tableName);
        BatchExecuteStatement.putItemsV1(clientV1LocalEmbedded, tableName);
        PartiQLTransaction.scanTablev2(tableName, dynamoDbClientv2LocalEmbedded);
        PartiQLTransaction.executeTransactionRequestV1InsertAndDelete(tableName, clientV1LocalEmbedded);
        System.out.println("Testings DynamoDB Prod - SDK v1");
        AmazonDynamoDB clientv1Prod = AmazonDynamoDBClientBuilder.defaultClient();
        DynamoDbClient dynamoDbClientv2Prod = (DynamoDbClient)DynamoDbClient.builder().build();
        BatchExecuteStatement.createTableV1(clientv1Prod, tableName);
        BatchExecuteStatement.putItemsV1(clientv1Prod, tableName);
        PartiQLTransaction.scanTablev2(tableName, dynamoDbClientv2Prod);
        PartiQLTransaction.executeTransactionRequestV1InsertAndDelete(tableName, clientv1Prod);
        String port = "8000";
        String uri = "http://localhost:" + port;
        System.out.println("Testings DynamoDB Local Server Runner - SDK v1");
        AmazonDynamoDB clientv1Local = (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration("http://localhost:8000", "us-west-2"))).build();
        DynamoDbClient ddbClientv2Local = (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().endpointOverride(URI.create(uri))).region(Region.US_WEST_2)).build();
        BatchExecuteStatement.createTableV1(clientv1Local, tableName);
        BatchExecuteStatement.putItemsV1(clientv1Local, tableName);
        PartiQLTransaction.scanTablev2(tableName, ddbClientv2Local);
        PartiQLTransaction.executeTransactionRequestSDkv2(tableName, ddbClientv2Local);
    }

    private static void scanTablev2(String tableName, DynamoDbClient dynamoDbClientv2LocalEmbedded) {
        software.amazon.awssdk.services.dynamodb.model.ScanRequest scanRequest = (software.amazon.awssdk.services.dynamodb.model.ScanRequest)software.amazon.awssdk.services.dynamodb.model.ScanRequest.builder().tableName(tableName).build();
        ScanResponse response = dynamoDbClientv2LocalEmbedded.scan(scanRequest);
        System.out.println("Scan Response: " + response);
    }

    private static void executeTransactionRequestV1(String tableName, AmazonDynamoDB clientv1Prod) {
        com.amazonaws.services.dynamodbv2.model.ExecuteTransactionRequest request = new com.amazonaws.services.dynamodbv2.model.ExecuteTransactionRequest();
        ArrayList<ParameterizedStatement> statements = new ArrayList<ParameterizedStatement>();
        statements.add(new ParameterizedStatement().withStatement("UPDATE " + tableName + " SET Score = ? WHERE UserId = ? AND GameTitle = ? AND Sample = ?").withParameters(new com.amazonaws.services.dynamodbv2.model.AttributeValue[]{new com.amazonaws.services.dynamodbv2.model.AttributeValue().withN("20"), new com.amazonaws.services.dynamodbv2.model.AttributeValue().withS("user2"), new com.amazonaws.services.dynamodbv2.model.AttributeValue().withS("Game2"), new com.amazonaws.services.dynamodbv2.model.AttributeValue().withN("1")}).withReturnValuesOnConditionCheckFailure("ALL_OLD"));
        request.setTransactStatements(statements);
        try {
            ExecuteTransactionResult executeTransactionResult = clientv1Prod.executeTransaction(request);
        }
        catch (com.amazonaws.services.dynamodbv2.model.TransactionCanceledException exception) {
            List cancellationReasons = exception.getCancellationReasons();
            for (CancellationReason cancellationReason : cancellationReasons) {
                System.out.println("Cancellation Reason Item: " + cancellationReason.getMessage());
                System.out.println("Cancellation Reason Message: " + cancellationReason.getItem());
            }
        }
    }

    private static void executeTransactionRequestSDkv2(String tableName, DynamoDbClient client) {
        AttributeValue att1 = (AttributeValue)AttributeValue.builder().s("20").build();
        AttributeValue att2 = (AttributeValue)AttributeValue.builder().s("user2").build();
        AttributeValue att3 = (AttributeValue)AttributeValue.builder().s("Game2").build();
        AttributeValue att4 = (AttributeValue)AttributeValue.builder().s("1").build();
        ArrayList<AttributeValue> parametersRec1 = new ArrayList<AttributeValue>();
        parametersRec1.add(att1);
        parametersRec1.add(att2);
        parametersRec1.add(att3);
        parametersRec1.add(att4);
        ExecuteTransactionRequest request = (ExecuteTransactionRequest)ExecuteTransactionRequest.builder().transactStatements(new software.amazon.awssdk.services.dynamodb.model.ParameterizedStatement[]{(software.amazon.awssdk.services.dynamodb.model.ParameterizedStatement)software.amazon.awssdk.services.dynamodb.model.ParameterizedStatement.builder().statement("UPDATE " + tableName + " SET Score = ? WHERE UserId = ? AND GameTitle = ? AND Sample = ?").returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD).parameters(parametersRec1).build()}).build();
        try {
            ExecuteTransactionResponse response = client.executeTransaction(request);
            System.out.println("Execute Transaction Response: " + response);
        }
        catch (TransactionCanceledException exception) {
            List cancellationReasons = exception.cancellationReasons();
            for (software.amazon.awssdk.services.dynamodb.model.CancellationReason cancellationReason : cancellationReasons) {
                System.out.println("Cancellation Reason Item: " + cancellationReason.message());
                System.out.println("Cancellation Reason Message: " + cancellationReason.item());
            }
        }
    }

    private static void executeTransactionRequestV1InsertAndDelete(String tableName, AmazonDynamoDB clientv1Prod) {
        com.amazonaws.services.dynamodbv2.model.ExecuteTransactionRequest request = new com.amazonaws.services.dynamodbv2.model.ExecuteTransactionRequest();
        ArrayList<ParameterizedStatement> statements = new ArrayList<ParameterizedStatement>();
        statements.add(new ParameterizedStatement().withStatement("INSERT INTO " + tableName + " VALUE {'UserId':?, 'GameTitle':?, 'Score':?}").withReturnValuesOnConditionCheckFailure("ALL_OLD").withParameters(new com.amazonaws.services.dynamodbv2.model.AttributeValue[]{new com.amazonaws.services.dynamodbv2.model.AttributeValue().withS("user2"), new com.amazonaws.services.dynamodbv2.model.AttributeValue().withS("Game2"), new com.amazonaws.services.dynamodbv2.model.AttributeValue().withN("30")}));
        statements.add(new ParameterizedStatement().withStatement("DELETE FROM " + tableName + " WHERE UserId = ? AND GameTitle = ? AND Score = ?").withReturnValuesOnConditionCheckFailure("ALL_OLD").withParameters(new com.amazonaws.services.dynamodbv2.model.AttributeValue[]{new com.amazonaws.services.dynamodbv2.model.AttributeValue().withS("user1"), new com.amazonaws.services.dynamodbv2.model.AttributeValue().withS("Game1"), new com.amazonaws.services.dynamodbv2.model.AttributeValue().withN("2")}));
        request.setTransactStatements(statements);
        try {
            ExecuteTransactionResult executeTransactionResult = clientv1Prod.executeTransaction(request);
        }
        catch (com.amazonaws.services.dynamodbv2.model.TransactionCanceledException exception) {
            List cancellationReasons = exception.getCancellationReasons();
            for (CancellationReason cancellationReason : cancellationReasons) {
                System.out.println("Cancellation Reason Item: " + cancellationReason.getMessage());
                System.out.println("Cancellation Reason Message: " + cancellationReason.getItem());
            }
        }
    }

    static void scanTable(String tableName, AmazonDynamoDB clientv1Prod) {
        ScanRequest scanRequest = new ScanRequest().withTableName(tableName);
        ScanResult result = clientv1Prod.scan(scanRequest);
        System.out.println("Scanning the table");
        System.out.println(result.getItems());
    }
}

