/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.cbor;

import com.amazon.cbor.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;

public class CborOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final OutputStream mOut;
    private final byte[] mBuffer;
    private int mEnd;

    public CborOutputStream() {
        this(new ByteArrayOutputStream());
    }

    public CborOutputStream(OutputStream output) {
        this(output, 8192);
    }

    public CborOutputStream(OutputStream output, int buffSize) {
        this.mOut = output;
        this.mBuffer = new byte[buffSize];
        this.mEnd = 0;
    }

    private void ensureBufSpace(int spaceNeeded) throws IOException {
        if (this.mEnd + spaceNeeded > this.mBuffer.length) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        this.mOut.write(this.mBuffer, 0, this.mEnd);
        this.mEnd = 0;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.mOut.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureBufSpace(1);
        this.mBuffer[this.mEnd++] = (byte)b;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (length > this.mBuffer.length) {
            this.flushBuffer();
            this.mOut.write(bytes, offset, length);
        } else {
            this.ensureBufSpace(length);
            System.arraycopy(bytes, offset, this.mBuffer, this.mEnd, length);
            this.mEnd += length;
        }
    }

    public void writeString(String s) throws IOException {
        byte[] bytes = Encoder.encodeUtf8(s);
        this.writeType(96, bytes.length);
        if (bytes.length > this.mBuffer.length) {
            this.flushBuffer();
            this.mOut.write(bytes);
        } else {
            this.ensureBufSpace(bytes.length);
            System.arraycopy(bytes, 0, this.mBuffer, this.mEnd, bytes.length);
            this.mEnd += bytes.length;
        }
    }

    public void writeString(byte[] utf8Bytes) throws IOException {
        this.writeType(96, utf8Bytes.length);
        this.write(utf8Bytes, 0, utf8Bytes.length);
    }

    public void writeBinary(ByteBuffer buff) throws IOException {
        buff.mark();
        byte[] bytes = new byte[buff.remaining()];
        buff.get(bytes, 0, bytes.length);
        buff.reset();
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
        this.writeType(64, length);
        this.write(bytes, offset, length);
    }

    public void writeRawBinary(ByteBuffer buff) throws IOException {
        if (buff.hasArray()) {
            this.mOut.write(buff.array(), buff.arrayOffset(), buff.limit());
        } else {
            buff.mark();
            byte[] bytes = new byte[buff.remaining()];
            buff.get(bytes, 0, bytes.length);
            buff.reset();
            this.write(bytes, 0, bytes.length);
        }
    }

    public void writeBoolean(boolean b) throws IOException {
        this.ensureBufSpace(1);
        this.mBuffer[this.mEnd++] = b ? -11 : -12;
    }

    public void writeNull() throws IOException {
        this.ensureBufSpace(1);
        this.mBuffer[this.mEnd++] = -10;
    }

    public void writeLong(long v) throws IOException {
        long signum = v >> 63;
        this.writeType(0 | (int)signum & 0x20, v ^ signum);
    }

    public void writeFloat(float f) throws IOException {
        int value = Float.floatToRawIntBits(f);
        this.ensureBufSpace(5);
        this.mBuffer[this.mEnd++] = -6;
        this.mBuffer[this.mEnd++] = (byte)(value >> 24);
        this.mBuffer[this.mEnd++] = (byte)(value >> 16);
        this.mBuffer[this.mEnd++] = (byte)(value >> 8);
        this.mBuffer[this.mEnd++] = (byte)value;
    }

    public void writeDouble(double d) throws IOException {
        this.writeType64(251, Double.doubleToRawLongBits(d));
    }

    public void writeInt(int i) throws IOException {
        this.writeLong(i);
    }

    public void writeBigInteger(BigInteger bi) throws IOException {
        int signum = bi.signum() >> 1;
        int bits = bi.bitLength();
        if (bits < 64) {
            this.writeLong(bi.longValue());
            return;
        }
        if (bits == 64) {
            this.writeType64(0x1B | signum & 0x20, bi.longValue() ^ (long)signum);
            return;
        }
        this.doWriteBigInteger(bi, signum);
    }

    void doWriteBigInteger(BigInteger bi) throws IOException {
        this.doWriteBigInteger(bi, bi.signum() >> 1);
    }

    private void doWriteBigInteger(BigInteger bi, int signum) throws IOException {
        byte[] bytes = bi.toByteArray();
        this.ensureBufSpace(1);
        this.mBuffer[this.mEnd++] = (byte)(0xC2 | signum & 1);
        this.writeType(64, bytes.length);
        if (bi.signum() >= 0) {
            this.ensureBufSpace(bytes.length);
            System.arraycopy(bytes, 0, this.mBuffer, this.mEnd, bytes.length);
        } else {
            this.ensureBufSpace(bytes.length);
            Encoder.flipCopy(bytes, 0, this.mBuffer, this.mEnd, bytes.length);
        }
        this.mEnd += bytes.length;
    }

    public void writeBigDecimal(BigDecimal bd) throws IOException {
        this.ensureBufSpace(1);
        this.mBuffer[this.mEnd++] = -60;
        this.writeArrayHeader(2);
        this.writeInt(-bd.scale());
        this.writeBigInteger(bd.unscaledValue());
    }

    public void writeNumber(String number) throws IOException {
        if (Encoder.isDecimal(number)) {
            this.writeBigDecimal(new BigDecimal(number));
        } else if (number.length() > 18) {
            this.writeBigInteger(new BigInteger(number));
        } else {
            this.writeLong(Long.parseLong(number));
        }
    }

    public void writeCollection(Collection<String> col) throws IOException {
        this.writeArrayHeader(col.size());
        for (String s : col) {
            this.writeString(s);
        }
    }

    public void writeArrayHeader(int numElems) throws IOException {
        this.writeType(128, numElems);
    }

    public void writeMapHeader(int numPairs) throws IOException {
        this.writeType(160, numPairs);
    }

    public void writeStringStreamHeader() throws IOException {
        this.write(127);
    }

    public void writeBytesStreamHeader() throws IOException {
        this.write(95);
    }

    public void writeArrayStreamHeader() throws IOException {
        this.write(159);
    }

    public void writeMapStreamHeader() throws IOException {
        this.write(191);
    }

    public void writeStreamBreak() throws IOException {
        this.write(255);
    }

    public void writeTag(long tagType) throws IOException {
        if (tagType >= 0L) {
            this.writeType(192, tagType);
        } else {
            this.writeType64(219, tagType);
        }
    }

    protected void writeType(int majorType, long value) throws IOException {
        if (value < 24L) {
            this.ensureBufSpace(1);
            this.mBuffer[this.mEnd++] = (byte)((long)majorType | value);
        } else {
            if (value < 256L) {
                this.ensureBufSpace(2);
                this.mBuffer[this.mEnd++] = (byte)(majorType + 24);
            } else {
                if (Math.abs(value) < 65536L) {
                    this.ensureBufSpace(3);
                    this.mBuffer[this.mEnd++] = (byte)(majorType + 25);
                } else {
                    if (Math.abs(value) < 0x100000000L) {
                        this.ensureBufSpace(5);
                        this.mBuffer[this.mEnd++] = (byte)(majorType + 26);
                    } else {
                        this.ensureBufSpace(9);
                        this.mBuffer[this.mEnd++] = (byte)(majorType + 27);
                        this.mBuffer[this.mEnd++] = (byte)(value >> 56);
                        this.mBuffer[this.mEnd++] = (byte)(value >> 48);
                        this.mBuffer[this.mEnd++] = (byte)(value >> 40);
                        this.mBuffer[this.mEnd++] = (byte)(value >> 32);
                    }
                    this.mBuffer[this.mEnd++] = (byte)(value >> 24);
                    this.mBuffer[this.mEnd++] = (byte)(value >> 16);
                }
                this.mBuffer[this.mEnd++] = (byte)(value >> 8);
            }
            this.mBuffer[this.mEnd++] = (byte)value;
        }
    }

    protected void writeType64(int type, long value) throws IOException {
        this.ensureBufSpace(9);
        byte[] b = this.mBuffer;
        int end = this.mEnd;
        b[end++] = (byte)type;
        b[end++] = (byte)(value >> 56);
        b[end++] = (byte)(value >> 48);
        b[end++] = (byte)(value >> 40);
        b[end++] = (byte)(value >> 32);
        b[end++] = (byte)(value >> 24);
        b[end++] = (byte)(value >> 16);
        b[end++] = (byte)(value >> 8);
        b[end++] = (byte)value;
        this.mEnd = end;
    }

    protected OutputStream getWrappedOutput() {
        return this.mOut;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.mOut.close();
    }

    public byte[] getBytesForTest() throws IOException {
        this.flush();
        ByteArrayOutputStream baout = (ByteArrayOutputStream)this.getWrappedOutput();
        byte[] bytes = baout.toByteArray();
        baout.reset();
        return bytes;
    }
}

