/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.cbor;

import com.amazon.cbor.SegmentPool;
import java.io.OutputStream;

public class SegmentOutputStream
extends OutputStream {
    private final SegmentPool mPool;
    private SegmentPool.Segment mHead;
    private SegmentPool.Segment mTail;

    public SegmentOutputStream(SegmentPool pool) {
        SegmentPool.Segment head;
        this.mPool = pool;
        this.mHead = head = pool.alloc();
        this.mTail = head;
    }

    public SegmentOutputStream(SegmentPool pool, SegmentPool.Segment head, SegmentPool.Segment tail) {
        this.mPool = pool;
        this.mHead = head;
        this.mTail = tail;
    }

    @Override
    public void write(int b) {
        if (this.mTail == null) {
            throw new IllegalStateException("SegmentOutputStream is closed.");
        }
        this.mTail = this.mPool.chainAppend(this.mTail, (byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.mTail == null) {
            throw new IllegalStateException("SegmentOutputStream is closed.");
        }
        this.mTail = this.mPool.chainAppend(this.mTail, b, off, len);
    }

    public SegmentPool.Segment getTail() {
        return this.mTail;
    }

    public byte[] toByteArray() {
        if (this.mHead == null) {
            throw new IllegalStateException("SegmentOutputStream is closed.");
        }
        return SegmentPool.chainCopy(this.mHead, 0);
    }

    public byte[] finish() {
        byte[] bytes = this.toByteArray();
        this.close();
        return bytes;
    }

    public void reset() {
        if (this.mHead != null) {
            this.mPool.chainTrim(this.mHead);
        }
        this.mTail = this.mHead;
    }

    @Override
    public void close() {
        if (this.mHead != null) {
            this.mPool.chainRecycle(this.mHead);
        }
        this.mHead = null;
        this.mTail = null;
    }
}

