/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits.dynamodb;

public class DynamoNumerals {

    public static enum ErrorCodes {
        VALIDATION_ERROR("ValidationException"),
        CONDITIONAL_CHECK_ERROR("ConditionalCheckFailedException"),
        PROVISIONED_THROUGHPUT_ERROR("ProvisionedThroughputExceededException"),
        LIMIT_EXCEEDED_ERROR("LimitExceededException"),
        RESOURCE_NOT_FOUND_ERROR("ResourceNotFoundException"),
        RESOURCE_IN_USE_ERROR("ResourceInUseException"),
        THROTTLING_ERROR("ThrottlingException"),
        ITEM_COLLECTION_SIZE_ERROR("ItemCollectionSizeLimitExceededException"),
        INTERNAL_SERVER_ERROR("InternalServerError"),
        INTERNAL_FAILURE("InternalFailure"),
        EXPIRED_TOKEN_ERROR("ExpiredToken");

        public final String mErrorCode;

        private ErrorCodes(String errorCode) {
            this.mErrorCode = errorCode;
        }

        public static ErrorCodes from(String errorCode) {
            switch (errorCode) {
                case "ValidationException": {
                    return VALIDATION_ERROR;
                }
                case "ConditionalCheckFailedException": {
                    return CONDITIONAL_CHECK_ERROR;
                }
                case "ProvisionedThroughputExceededException": {
                    return PROVISIONED_THROUGHPUT_ERROR;
                }
                case "LimitExceededException": {
                    return LIMIT_EXCEEDED_ERROR;
                }
                case "ResourceNotFoundException": {
                    return RESOURCE_NOT_FOUND_ERROR;
                }
                case "ResourceInUseException": {
                    return RESOURCE_IN_USE_ERROR;
                }
                case "ThrottlingException": {
                    return THROTTLING_ERROR;
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return ITEM_COLLECTION_SIZE_ERROR;
                }
                case "InternalServerError": {
                    return INTERNAL_SERVER_ERROR;
                }
                case "InternalFailure": {
                    return INTERNAL_FAILURE;
                }
                case "ExpiredTokenException": {
                    return EXPIRED_TOKEN_ERROR;
                }
            }
            return null;
        }
    }

    public static enum ReturnItemCollectionMetrics {
        NONE(0),
        SIZE(1);

        public final int mCode;

        private ReturnItemCollectionMetrics(int code) {
            this.mCode = code;
        }

        public static ReturnItemCollectionMetrics fromName(String retVal) {
            if (retVal == null) {
                return NONE;
            }
            switch (retVal) {
                default: {
                    return NONE;
                }
                case "SIZE": 
            }
            return SIZE;
        }

        public static ReturnItemCollectionMetrics fromInt(int code) {
            switch (code) {
                default: {
                    return NONE;
                }
                case 1: 
            }
            return SIZE;
        }
    }

    public static enum ReturnConsumedCapacity {
        NONE(0),
        TOTAL(1),
        INDEXES(2);

        public final int mCode;

        private ReturnConsumedCapacity(int code) {
            this.mCode = code;
        }

        public static ReturnConsumedCapacity fromName(String retVal) {
            if (retVal == null) {
                return NONE;
            }
            switch (retVal) {
                default: {
                    return NONE;
                }
                case "TOTAL": {
                    return TOTAL;
                }
                case "INDEXES": 
            }
            return INDEXES;
        }

        public static ReturnConsumedCapacity fromInt(int code) {
            switch (code) {
                default: {
                    return NONE;
                }
                case 1: {
                    return TOTAL;
                }
                case 2: 
            }
            return INDEXES;
        }
    }

    public static enum GSIUpdate {
        CREATE(1),
        DELETE(2),
        UPDATE(3);

        public final int mCode;

        private GSIUpdate(int code) {
            this.mCode = code;
        }

        public static GSIUpdate fromName(String action) {
            switch (action) {
                default: {
                    throw new IllegalArgumentException("Invalid GSI Update action name: " + action);
                }
                case "Create": {
                    return CREATE;
                }
                case "Delete": {
                    return DELETE;
                }
                case "Update": 
            }
            return UPDATE;
        }

        public static GSIUpdate fromInt(int code) {
            switch (code) {
                case 1: {
                    return CREATE;
                }
                case 2: {
                    return DELETE;
                }
                case 3: {
                    return UPDATE;
                }
            }
            throw new IllegalArgumentException("Invalid GSI Update action numeral: " + code);
        }
    }

    public static enum SelectValue {
        ALL_ATTRIBUTES(1),
        ALL_PROJECTED_ATTRIBUTES(2),
        COUNT(3),
        SPECIFIC_ATTRIBUTES(4);

        public final int mCode;

        private SelectValue(int code) {
            this.mCode = code;
        }

        public static SelectValue fromName(String select) {
            if (select == null) {
                return ALL_ATTRIBUTES;
            }
            switch (select) {
                default: {
                    return ALL_ATTRIBUTES;
                }
                case "ALL_PROJECTED_ATTRIBUTES": {
                    return ALL_PROJECTED_ATTRIBUTES;
                }
                case "COUNT": {
                    return COUNT;
                }
                case "SPECIFIC_ATTRIBUTES": 
            }
            return SPECIFIC_ATTRIBUTES;
        }

        public static SelectValue fromInt(int code) {
            switch (code) {
                default: {
                    return ALL_ATTRIBUTES;
                }
                case 2: {
                    return ALL_PROJECTED_ATTRIBUTES;
                }
                case 3: {
                    return COUNT;
                }
                case 4: 
            }
            return SPECIFIC_ATTRIBUTES;
        }
    }

    public static enum ConsumedCapacity {
        TableName,
        CapacityUnits;

    }

    public static enum Operation {
        GET,
        PUT,
        EXCHANGE,
        INSERT,
        REPLACE,
        UPDATE,
        DELETE,
        REMOVE,
        PARTIAL_UPDATE,
        BATCH_GET,
        BATCH_WRITE,
        SCAN,
        QUERY,
        CREATE_TABLE,
        DELETE_TABLE,
        DESCRIBE_TABLE,
        LIST_TABLES,
        UPDATE_TABLE;

    }

    public static enum ReturnValue {
        NONE(1),
        ALL_OLD(2),
        UPDATED_OLD(3),
        ALL_NEW(4),
        UPDATED_NEW(5);

        public final int mCode;

        private ReturnValue(int code) {
            this.mCode = code;
        }

        public static ReturnValue fromName(String retVal) {
            if (retVal == null) {
                return NONE;
            }
            switch (retVal) {
                default: {
                    return NONE;
                }
                case "ALL_OLD": {
                    return ALL_OLD;
                }
                case "UPDATED_OLD": {
                    return UPDATED_OLD;
                }
                case "ALL_NEW": {
                    return ALL_NEW;
                }
                case "UPDATED_NEW": 
            }
            return UPDATED_NEW;
        }

        public static ReturnValue fromInt(int code) {
            switch (code) {
                default: {
                    return NONE;
                }
                case 2: {
                    return ALL_OLD;
                }
                case 3: {
                    return UPDATED_OLD;
                }
                case 4: {
                    return ALL_NEW;
                }
                case 5: 
            }
            return UPDATED_NEW;
        }
    }
}

