/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.cluster;

import com.amazon.dax.bits.disco.ServiceEndpoint;
import com.amazon.dax.client.SessionVersion;
import com.amazon.dax.client.cluster.Cluster;
import com.amazon.dax.client.dynamodbv2.AmazonDaxClient;
import com.amazon.dax.client.dynamodbv2.ExceptionListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;

public class Backend
implements ExceptionListener {
    private final Cluster mCluster;
    private ServiceEndpoint mConfig;
    private InetSocketAddress mAddr;
    volatile boolean mActive;
    volatile boolean mHealthy;
    volatile SessionVersion mSession;
    volatile boolean mClosed;
    AmazonDaxClient mClient;
    private final AtomicInteger mErrorCount = new AtomicInteger(0);
    private final int mErrorCountForUnhealthy;
    private static final int MIN_ERROR_COUNT_FOR_UNHEALTHY = 5;
    long mPingLatency;
    ScheduledFuture<?> mConnect;

    public Backend(Cluster cluster, ServiceEndpoint cfg) throws IOException {
        this(cluster, cfg, 0);
    }

    public Backend(Cluster cluster, ServiceEndpoint cfg, int maxPendingConnectionPerHost) throws IOException {
        this.mCluster = cluster;
        this.mConfig = cfg;
        this.mAddr = Cluster.toAddr(cfg);
        this.mErrorCountForUnhealthy = Math.max(maxPendingConnectionPerHost / 2, 5);
    }

    public InetSocketAddress addr() {
        return this.mAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Backend newConfig) {
        if (!this.mConfig.equals(newConfig.mConfig)) {
            Backend backend = this;
            synchronized (backend) {
                this.mConfig = newConfig.mConfig;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AmazonDaxClient client;
        Backend backend = this;
        synchronized (backend) {
            if (this.mClosed) {
                return;
            }
            this.mClosed = true;
            this.mSession = SessionVersion.create();
            this.mHealthy = false;
            client = this.mClient;
        }
        ScheduledFuture<?> dial = this.mConnect;
        if (dial != null) {
            dial.cancel(false);
        }
        this.down();
        if (client != null) {
            client.shutdown();
            client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(AmazonDaxClient client) {
        Backend backend = this;
        synchronized (backend) {
            if (!this.mActive && !this.mClosed) {
                this.mActive = true;
                this.mClient = client;
            }
        }
        this.mCluster.addRoute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down() {
        if (!this.mActive) {
            return;
        }
        this.mCluster.removeRoute(this);
        Backend backend = this;
        synchronized (backend) {
            this.mActive = false;
            if (this.mClient != null) {
                this.mClient.shutdown();
                this.mClient = null;
            }
        }
    }

    boolean active() {
        return this.mActive;
    }

    SessionVersion session() {
        return this.mSession;
    }

    boolean healthy() {
        return this.mHealthy;
    }

    void setHealthy(boolean value) {
        if (this.mHealthy != value) {
            this.mHealthy = value;
        }
    }

    public synchronized boolean leader() {
        return this.mConfig.role() == ServiceEndpoint.Role.LEADER;
    }

    public synchronized AmazonDaxClient client() {
        return this.mClient;
    }

    int getErrorCount() {
        return this.mErrorCount.get();
    }

    void resetErrorCount() {
        this.mErrorCount.set(0);
    }

    public String toString() {
        return "Backend{addr=" + this.mAddr + ",healthy=" + this.mHealthy + ",active=" + this.mActive + ",config=" + this.mConfig + "}";
    }

    @Override
    public void onIoException() {
        if (this.active() && this.mErrorCount.incrementAndGet() > this.mErrorCountForUnhealthy) {
            this.setHealthy(false);
            this.down();
        }
    }
}

