/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.cluster;

import com.amazon.dax.bits.disco.ServiceEndpoint;
import com.amazon.dax.client.ClientTube;
import com.amazon.dax.client.Connector;
import com.amazon.dax.client.DaxConnector;
import com.amazon.dax.client.HostPort;
import com.amazon.dax.client.SessionVersion;
import com.amazon.dax.client.SocketTubePool;
import com.amazon.dax.client.cluster.Backend;
import com.amazon.dax.client.cluster.RandomRouter;
import com.amazon.dax.client.cluster.Router;
import com.amazon.dax.client.cluster.Source;
import com.amazon.dax.client.cluster.ThreadAffinityRouter;
import com.amazon.dax.client.dynamodbv2.AmazonDaxClient;
import com.amazon.dax.client.dynamodbv2.ClientConfig;
import com.amazon.dax.client.dynamodbv2.DaxClient;
import com.amazon.dax.client.dynamodbv2.DaxClientManufacturer;
import com.amazon.dax.client.dynamodbv2.ExceptionListener;
import com.amazon.dax.client.exceptions.DaxServiceException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cluster
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Cluster.class);
    private static final long REPLICATION_NOT_ENABLED = -1L;
    private static final long NO_LEADER = 0L;
    private static final long IDLE_CONNECTION_REAP_DELAY_MS = 30000L;
    private static final int MIN_CLUSTER_SIZE_USING_THREAD_AFFINITY = 8;
    private final HostPort[] mSeeds;
    private final Set<Backend> mAlive = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<InetSocketAddress, Backend> mBackends = new ConcurrentHashMap<InetSocketAddress, Backend>();
    private final Set<SocketTubePool> mPools = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private Set<ServiceEndpoint> mCfg;
    private Source mSource;
    private volatile Router<AmazonDaxClient> mRoutes;
    private volatile DaxClientManufacturer mManufacturer;
    private volatile boolean mClosed;
    private final ScheduledExecutorService mScheduler;
    private final long mUpdateRateNs;
    private final long mUpdateThresholdNs;
    private long mLastUpdate;
    private final long mHealthCheckInterval;
    private final int mReadTimeoutMs;
    private final int mMaxPendingConnectsPerHost;
    private ScheduledFuture<?> mRefreshJob;
    private ScheduledFuture<?> mReapJob;
    private final Connector mConnector;
    private final DaxConnector mHealthCheckConnector;
    private final AWSCredentialsProvider mProvider;
    private volatile String mRegion;
    private final ClusterHealthGate mHealth;

    public Cluster(ClientConfig config, DaxClientManufacturer manufacturer) {
        this(config, null, null, manufacturer);
    }

    Cluster(ClientConfig config, Source src, DaxClientManufacturer manufacturer) {
        this(config, src, null, manufacturer);
    }

    Cluster(ClientConfig config, Source src, Connector connector, DaxClientManufacturer manufacturer) {
        this.mSeeds = config.getHostPorts();
        this.mProvider = config.getCredentialsProvider();
        this.mUpdateRateNs = config.getClusterUpdateInterval();
        this.mUpdateThresholdNs = config.getClusterUpdateThreshold();
        this.mReadTimeoutMs = (int)TimeUnit.NANOSECONDS.toMillis(config.getRequestTimeout());
        this.mMaxPendingConnectsPerHost = config.getMaxPendingConnectsPerHost();
        this.mSource = src != null ? src : Source.autoconf(this, this.mSeeds);
        this.mRegion = config.getRegion();
        this.mConnector = connector != null ? connector : new Connector((int)TimeUnit.NANOSECONDS.toMillis(config.getConnectTimeout()), config.getThreadKeepAlive());
        this.mHealthCheckConnector = new DaxConnector(this.mConnector, (int)TimeUnit.NANOSECONDS.toMillis(config.getHealthCheckTimeout()), Integer.MAX_VALUE, DaxClient.getUserAgent());
        this.mHealthCheckInterval = config.getHealthCheckInterval();
        this.mHealth = new ClusterHealthGate(this);
        this.mManufacturer = manufacturer;
        this.mScheduler = Executors.newScheduledThreadPool(0, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("DaxClient-" + t.getId());
                return t;
            }
        });
        if (this.mScheduler instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)((Object)this.mScheduler);
            tpe.setKeepAliveTime(config.getThreadKeepAlive(), TimeUnit.NANOSECONDS);
            tpe.allowCoreThreadTimeOut(true);
        }
        if (this.mScheduler instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor stpe = (ScheduledThreadPoolExecutor)this.mScheduler;
            stpe.setRemoveOnCancelPolicy(true);
        }
    }

    public void startup() throws IOException {
        this.startup(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(int minimumHealthy) throws IOException {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this.mClosed) {
                throw new IllegalStateException("closed");
            }
            if (this.mSource == null) {
                this.mSource = Source.autoconf(this, this.mSeeds);
            }
            this.mReapJob = this.mScheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!Cluster.this.mClosed) {
                            Cluster.this.reapIdleConnections();
                        }
                    }
                    catch (Throwable t) {
                        LOG.warn((Object)("caught exception during idle connection reaping: " + t), t);
                    }
                }
            }, 30000L, 30000L, TimeUnit.MILLISECONDS);
            long refreshIntervalNs = Math.min(TimeUnit.SECONDS.toNanos(1L), Cluster.jitter(this.mUpdateRateNs));
            this.mRefreshJob = this.mScheduler.scheduleWithFixedDelay(new Runnable(){
                Throwable lastError;

                @Override
                public void run() {
                    try {
                        if (!Cluster.this.mClosed) {
                            Cluster.this.refresh(true);
                            this.lastError = null;
                        }
                    }
                    catch (Throwable t) {
                        if (this.lastError != null) {
                            if (this.lastError != t) {
                                t.addSuppressed(this.lastError);
                            }
                            LOG.warn((Object)("caught exception during cluster refresh: " + t), t);
                            this.lastError = null;
                        }
                        this.lastError = t;
                    }
                }
            }, refreshIntervalNs, refreshIntervalNs, TimeUnit.NANOSECONDS);
            try {
                this.refresh();
            }
            catch (DaxServiceException e) {
                int[] errCodes = e.getCodeSeq();
                if (errCodes != null && errCodes.length >= 3 && errCodes[1] == 23 && errCodes[2] == 31) {
                    LOG.warn((Object)("Auth exception while starting up cluster client:" + (Object)((Object)e)), (Throwable)((Object)e));
                    minimumHealthy = 0;
                }
                throw e;
            }
        }
        if (minimumHealthy <= 0) {
            return;
        }
        this.waitForRoutes(minimumHealthy, 1);
        LOG.info((Object)("connected to cluster endpoints: " + this.mAlive));
    }

    public boolean isAlive() {
        return this.mRoutes != null && this.mRoutes.size() > 0;
    }

    public void waitForRecovery(long leaderSessionId, long time, TimeUnit unit) {
        try {
            this.mHealth.waitForNewLeader(leaderSessionId, time, unit);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public long getLeaderSessionId() {
        return this.mHealth.currentLeader();
    }

    synchronized void waitForRoutes(int minimum, int leadersMin) throws IOException {
        long timeoutMs = this.mReadTimeoutMs;
        long deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMs);
        Router<AmazonDaxClient> routes;
        while ((routes = this.mRoutes) == null || routes.size() < minimum || routes.leadersCount() < leadersMin) {
            timeoutMs = TimeUnit.NANOSECONDS.toMillis(deadline - System.nanoTime());
            if (timeoutMs <= 0L) {
                throw new IOException("Not enough endpoints connected");
            }
            try {
                this.wait(timeoutMs);
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException();
            }
        }
        return;
    }

    public void refresh() throws IOException {
        this.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean forced) throws IOException {
        Source src;
        Cluster cluster = this;
        synchronized (cluster) {
            long now = System.nanoTime();
            if (this.mClosed || now - this.mLastUpdate < this.mUpdateThresholdNs && !forced || (src = this.mSource) == null) {
                return;
            }
            this.mLastUpdate = now;
        }
        src.refresh();
    }

    public void update(Set<ServiceEndpoint> cfg) throws IOException {
        if (cfg != null && cfg.size() > 0) {
            this.mCfg = cfg;
            this.updateEndpoints();
        }
    }

    private synchronized void rebuildRoutes() {
        ArrayList<Backend> bes = new ArrayList<Backend>(this.mAlive);
        int sz = bes.size();
        if (sz == 0) {
            this.mRoutes = null;
            this.notify();
            return;
        }
        int ldr = 0;
        AmazonDaxClient[] cs = new AmazonDaxClient[sz];
        for (int i = 0; i < cs.length; ++i) {
            Backend be = (Backend)bes.get(i);
            if (be.leader()) {
                cs[ldr++] = be.client();
                continue;
            }
            cs[--sz] = be.client();
        }
        this.mRoutes = cs.length >= 8 ? new ThreadAffinityRouter<AmazonDaxClient>(cs, ldr) : new RandomRouter<AmazonDaxClient>(cs, ldr);
        this.notify();
    }

    void addRoute(Backend be) {
        if (this.mAlive.add(be)) {
            this.rebuildRoutes();
        }
    }

    void removeRoute(Backend be) {
        if (this.mAlive.remove(be)) {
            this.rebuildRoutes();
        }
    }

    boolean isAlive(Backend be) {
        return be.active() || this.mAlive.contains(be);
    }

    private void updateEndpoints() throws IOException {
        Set<ServiceEndpoint> se = this.mCfg;
        Map<InetSocketAddress, Backend> backends = this.mBackends;
        boolean rebuild = false;
        Map<InetSocketAddress, Backend> newBackends = this.expand(se);
        for (Map.Entry<InetSocketAddress, Backend> en : newBackends.entrySet()) {
            Backend be = backends.get(en.getKey());
            if (be != null) {
                rebuild |= be.update(en.getValue());
                continue;
            }
            en.getValue().mSession = SessionVersion.create();
            backends.put(en.getKey(), en.getValue());
            this.connect(en.getValue(), 0L, TimeUnit.NANOSECONDS);
        }
        if (rebuild) {
            this.rebuildRoutes();
        }
        Iterator<Map.Entry<InetSocketAddress, Backend>> it = backends.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<InetSocketAddress, Backend> en;
            en = it.next();
            if (newBackends.containsKey(en.getKey())) continue;
            Backend old = en.getValue();
            it.remove();
            old.close();
        }
        for (ServiceEndpoint ep : se) {
            if (ep.role() != ServiceEndpoint.Role.LEADER) continue;
            this.mHealth.newLeader(ep.leaderSessionId());
            break;
        }
    }

    private Map<InetSocketAddress, Backend> expand(Set<ServiceEndpoint> se) throws IOException {
        HashMap<InetSocketAddress, Backend> backends = new HashMap<InetSocketAddress, Backend>();
        for (ServiceEndpoint ep : se) {
            Backend be = new Backend(this, ep, this.mMaxPendingConnectsPerHost);
            backends.put(be.addr(), be);
        }
        return backends;
    }

    Backend backendFor(InetSocketAddress addr) {
        return this.mBackends.get(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onHealthCheck(Backend be, SessionVersion session, ClientTube tube, Throwable e) {
        block13: {
            Backend current = this.mBackends.get(be.addr());
            if (this.mClosed || current != be) {
                be.close();
                if (tube != null) {
                    tube.close();
                }
                return;
            }
            boolean closeTube = true;
            try {
                if (session != be.session()) {
                    return;
                }
                if (e != null && be.healthy()) {
                    be.setHealthy(false);
                    be.down();
                    break block13;
                }
                if (e == null && !be.healthy() && !be.mClosed) {
                    try {
                        be.resetErrorCount();
                        be.setHealthy(true);
                        be.up(this.newClient(be.addr(), session, tube, be));
                        closeTube = false;
                        break block13;
                    }
                    catch (IOException ie) {
                        be.setHealthy(false);
                        be.down();
                        throw new RuntimeException("client creation failed for backend: " + be + " exception = " + ie, ie);
                    }
                }
                if (e == null) {
                    be.resetErrorCount();
                }
            }
            finally {
                if (closeTube && tube != null) {
                    tube.close();
                }
            }
        }
    }

    private void connect(final Backend be, long delay, TimeUnit unit) {
        assert (be.mConnect == null);
        be.mConnect = this.mScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                final long startNano = System.nanoTime();
                final SessionVersion session = be.mSession;
                Cluster.this.mHealthCheckConnector.connect(be.addr(), session, new Connector.Listener<ClientTube>(){

                    @Override
                    public void handle(ClientTube value, Throwable e) {
                        if (e == null) {
                            be.mPingLatency = System.nanoTime() - startNano;
                        }
                        Cluster.this.onHealthCheck(be, session, value, e);
                    }
                });
            }
        }, delay, unit.convert(this.mHealthCheckInterval, TimeUnit.NANOSECONDS), unit);
    }

    private void reapIdleConnections() {
        if (this.mPools.isEmpty()) {
            return;
        }
        RuntimeException ex = null;
        ArrayList<SocketTubePool> pools = new ArrayList<SocketTubePool>(this.mPools);
        for (SocketTubePool p : pools) {
            try {
                p.reapIdleTubes();
            }
            catch (RuntimeException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    AmazonDaxClient newClient(InetSocketAddress addr, SessionVersion session, ClientTube tube, ExceptionListener el) throws IOException {
        if (tube != null) {
            tube.setReadTimeout(this.mReadTimeoutMs);
        }
        SocketTubePool pool = new SocketTubePool(addr, session, new DaxConnector(this.mConnector, this.mReadTimeoutMs, this.mMaxPendingConnectsPerHost, DaxClient.getUserAgent()), tube);
        this.mPools.add(pool);
        return this.mManufacturer.createDaxClient(pool, this.mRegion, this.mProvider, el);
    }

    AmazonDaxClient newClient(InetAddress addr, int port) throws IOException {
        return this.newClient(new InetSocketAddress(addr.getHostAddress(), port), SessionVersion.create(), null, null);
    }

    public AmazonDaxClient leaderClient(AmazonDaxClient prev) throws IOException {
        Router<AmazonDaxClient> routes = this.mRoutes;
        if (routes == null) {
            throw new IOException("No endpoints available");
        }
        return routes.nextLeader(prev);
    }

    public AmazonDaxClient readClient(AmazonDaxClient prev) throws IOException {
        Router<AmazonDaxClient> routes = this.mRoutes;
        if (routes == null) {
            throw new IOException("No endpoints available");
        }
        return routes.nextAny(prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this.mClosed) {
                return;
            }
            this.mClosed = true;
            if (this.mRefreshJob != null) {
                this.mRefreshJob.cancel(false);
            }
            if (this.mReapJob != null) {
                this.mReapJob.cancel(false);
            }
        }
        for (Map.Entry entry : this.mBackends.entrySet()) {
            ((Backend)entry.getValue()).close();
        }
        this.mPools.clear();
        this.mBackends.clear();
        this.mAlive.clear();
        this.mHealthCheckConnector.close();
        this.mScheduler.shutdown();
        try {
            if (!this.mScheduler.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                this.mScheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.mScheduler.shutdownNow();
        }
        this.mConnector.close(true);
        this.mRoutes = null;
    }

    static InetSocketAddress toAddr(ServiceEndpoint ep) throws IOException {
        InetSocketAddress addr = ep.address() != null && ep.address().length > 0 ? new InetSocketAddress(InetAddress.getByAddress(ep.address()), ep.port()) : new InetSocketAddress(ep.hostname(), ep.port());
        return addr;
    }

    private static long jitter(long value) {
        long shift = 2L;
        return value < 4L ? value : ThreadLocalRandom.current().nextLong(value - (value >> 2), value + (value >> 2));
    }

    public void setRegion(Region region) throws IOException {
        if (region == null) {
            throw new AmazonClientException("Region must not be null");
        }
        this.setRegion(region.getName());
    }

    public void setRegion(String region) throws IOException {
        if (StringUtils.isNullOrEmpty((String)region)) {
            throw new AmazonClientException("Region must not be empty");
        }
        this.mRegion = region;
        this.refresh(true);
        this.waitForRoutes(1, 1);
        for (Backend be : this.mBackends.values()) {
            AmazonDaxClient client = be.client();
            if (client == null) continue;
            client.setRegion(region);
        }
    }

    private static final class ClusterHealthGate {
        private final Cluster mCluster;
        private final Lock mLock = new ReentrantLock();
        private final Condition mClusterHealthy = this.mLock.newCondition();
        private final Callable<Boolean> mAsCallable;
        private ScheduledFuture<?> mJob;
        private long mLastUpdate;
        private volatile long mLeaderSessionId;
        private int mGeneration;

        public ClusterHealthGate(Cluster mCluster) {
            this.mCluster = mCluster;
            this.mLastUpdate = System.nanoTime() - mCluster.mUpdateThresholdNs - 1L;
            this.mAsCallable = new Callable<Boolean>(){

                @Override
                public Boolean call() throws IOException {
                    return ClusterHealthGate.this.tryRefresh();
                }
            };
        }

        private Boolean tryRefresh() throws IOException {
            this.mCluster.refresh(true);
            return Boolean.TRUE;
        }

        public long currentLeader() {
            return this.mLeaderSessionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void newLeader(long newLeaderSessionId) {
            this.mLock.lock();
            try {
                long oldLeaderSessionId = this.mLeaderSessionId;
                if (oldLeaderSessionId == newLeaderSessionId) {
                    ++this.mGeneration;
                } else {
                    this.mLeaderSessionId = newLeaderSessionId;
                    this.mGeneration = 0;
                }
            }
            finally {
                this.mClusterHealthy.signalAll();
                this.mLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForNewLeader(long leaderSessionId, long time, TimeUnit unit) throws InterruptedException {
            if (time <= 0L) {
                return;
            }
            if (this.mLeaderSessionId != leaderSessionId) {
                return;
            }
            this.mLock.lock();
            try {
                int arrivalGeneration = this.mGeneration;
                long newLeaderSessionId = this.mLeaderSessionId;
                if (newLeaderSessionId != leaderSessionId || this.mCluster.mClosed) {
                    return;
                }
                long nanos = unit.toNanos(time);
                while (nanos > 0L && newLeaderSessionId != -1L && (newLeaderSessionId == 0L || newLeaderSessionId == leaderSessionId) && arrivalGeneration == this.mGeneration) {
                    if (this.mJob == null || this.mJob.isDone()) {
                        this.mJob = null;
                        long now = System.nanoTime();
                        if (now - this.mLastUpdate > this.mCluster.mUpdateThresholdNs) {
                            this.mJob = this.mCluster.mScheduler.schedule(this.mAsCallable, 0L, TimeUnit.NANOSECONDS);
                            this.mLastUpdate = now;
                        }
                    }
                    nanos = this.mClusterHealthy.awaitNanos(nanos);
                    newLeaderSessionId = this.mLeaderSessionId;
                }
            }
            finally {
                this.mLock.unlock();
            }
        }
    }
}

