/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.cluster;

import com.amazon.dax.bits.disco.ServiceEndpoint;
import com.amazon.dax.client.HostPort;
import com.amazon.dax.client.cluster.Cluster;
import com.amazon.dax.client.dynamodbv2.AmazonDaxClient;
import com.amazonaws.AmazonClientException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class Source
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Source.class);

    Source() {
    }

    public abstract void refresh() throws IOException;

    public static Source autoconf(Cluster c, HostPort ... seeds) {
        if (seeds == null || seeds.length == 0) {
            throw new IllegalArgumentException("no configuration seed hosts provided");
        }
        return new AutoconfSource(c, seeds);
    }

    private static class AutoconfSource
    extends Source {
        private final Cluster mCluster;
        private final HostPort[] mSeeds;
        private Set<ServiceEndpoint> mServices;

        AutoconfSource(Cluster c, HostPort ... seeds) {
            this.mCluster = c;
            this.mSeeds = (HostPort[])seeds.clone();
        }

        @Override
        public void refresh() throws IOException {
            this.update();
        }

        @Override
        public void close() {
        }

        private void update() throws IOException {
            List<ServiceEndpoint> newCfg = this.pull(this.mSeeds);
            this.checkConfig(newCfg);
        }

        private void checkConfig(List<ServiceEndpoint> newCfg) throws IOException {
            Set<ServiceEndpoint> existing = this.mServices;
            HashSet<ServiceEndpoint> latest = new HashSet<ServiceEndpoint>(newCfg);
            if (existing != null && existing.equals(latest)) {
                return;
            }
            this.mServices = latest;
            this.mCluster.update(latest);
        }

        private List<ServiceEndpoint> pull(HostPort[] dests) throws IOException {
            Throwable e = null;
            for (int i = 0; i < dests.length; ++i) {
                InetAddress[] addrs;
                HostPort dest = dests[i];
                try {
                    addrs = InetAddress.getAllByName(dest.host());
                }
                catch (UnknownHostException ue) {
                    if (e == null) {
                        e = ue;
                        continue;
                    }
                    e.addSuppressed(ue);
                    continue;
                }
                if (addrs.length > 1) {
                    for (int j = addrs.length - 1; j > 0; --j) {
                        int k = ThreadLocalRandom.current().nextInt(j + 1);
                        InetAddress tmp = addrs[k];
                        addrs[k] = addrs[j];
                        addrs[j] = tmp;
                    }
                }
                for (InetAddress ia : addrs) {
                    try {
                        List<ServiceEndpoint> newCfg = this.pullFrom(ia, dest.port());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("found endpoint configuration " + newCfg + " from " + ia + ":" + dest.port()));
                        }
                        if (newCfg == null || newCfg.isEmpty()) continue;
                        return newCfg;
                    }
                    catch (IOException ie) {
                        if (e == null) {
                            e = ie;
                            continue;
                        }
                        e.addSuppressed(ie);
                    }
                    catch (AmazonClientException t) {
                        if (e == null) {
                            e = t;
                            continue;
                        }
                        e.addSuppressed(t);
                    }
                }
            }
            IOException ie = new IOException("failed to configure cluster endpoints from hosts: " + Arrays.toString(dests));
            if (e != null) {
                ie.initCause(e);
            }
            throw ie;
        }

        private List<ServiceEndpoint> pullFrom(InetAddress addr, int port) throws IOException {
            AmazonDaxClient client = this.mCluster.newClient(addr, port);
            try {
                List<ServiceEndpoint> list = client.endpoints();
                return list;
            }
            catch (AmazonClientException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
            finally {
                try {
                    client.shutdown();
                }
                catch (Exception exception) {}
            }
        }
    }
}

