/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.cluster;

import com.amazon.dax.client.cluster.Router;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

final class ThreadAffinityRouter<T>
implements Router<T> {
    private final T[] mAllValues;
    private final T[] mLeaderValues;

    ThreadAffinityRouter(T[] values, int leaderCnt) {
        if (values == null) {
            throw new IllegalArgumentException("routes must not be null");
        }
        if (leaderCnt > values.length) {
            throw new IllegalArgumentException("leader count must be <= routes");
        }
        this.mAllValues = values;
        this.mLeaderValues = Arrays.copyOfRange(this.mAllValues, 0, leaderCnt);
        ThreadAffinityRouter.shuffleArray(this.mAllValues);
        ThreadAffinityRouter.shuffleArray(this.mLeaderValues);
    }

    private static <U> void shuffleArray(U[] arr) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int i = arr.length - 1; i > 0; --i) {
            int index = ((Random)rnd).nextInt(i + 1);
            U tmp = arr[index];
            arr[index] = arr[i];
            arr[i] = tmp;
        }
    }

    @Override
    public T nextLeader(T prev) {
        return this.next(this.mLeaderValues, this.mLeaderValues.length, prev);
    }

    @Override
    public T nextAny(T prev) {
        return this.next(this.mAllValues, this.mAllValues.length, prev);
    }

    private T next(T[] values, int len, T prev) {
        if (len == 0) {
            return null;
        }
        if (len == 1) {
            return values[0];
        }
        int idx = ThreadAffinityRouter.randByThreadId() % len;
        if (values[idx] == prev && ++idx >= len) {
            idx -= len;
        }
        return values[idx];
    }

    private static int randByThreadId() {
        long x = Thread.currentThread().getId();
        x ^= x << 13;
        x ^= x >>> 7;
        x ^= x << 17;
        return (int)x & Integer.MAX_VALUE;
    }

    @Override
    public int size() {
        return this.mAllValues.length;
    }

    @Override
    public int leadersCount() {
        return this.mLeaderValues.length;
    }
}

