/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.client.HostPort;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.util.StringUtils;
import java.util.concurrent.TimeUnit;

public final class ClientConfig {
    private int mMaxPendingConnectsPerHost;
    private long mClusterUpdateThreshold;
    private long mClusterUpdateInterval;
    private long mConnectTimeout;
    private long mRequestTimeout;
    private long mHealthCheckInterval;
    private long mHealthCheckTimeout;
    private int mWriteRetries;
    private int mReadRetries;
    private long mMaxRetryDelay;
    private long mThreadKeepAlive;
    private HostPort[] mHostPorts;
    @Deprecated
    public AWSCredentialsProvider mProvider;
    @Deprecated
    public String mRegion;

    ClientConfig(ClientConfig anotherConfig) {
        this();
        if (anotherConfig != null) {
            this.mMaxPendingConnectsPerHost = anotherConfig.mMaxPendingConnectsPerHost;
            this.mClusterUpdateThreshold = anotherConfig.mClusterUpdateThreshold;
            this.mClusterUpdateInterval = anotherConfig.mClusterUpdateInterval;
            this.mConnectTimeout = anotherConfig.mConnectTimeout;
            this.mRequestTimeout = anotherConfig.mRequestTimeout;
            this.mHealthCheckInterval = anotherConfig.mHealthCheckInterval;
            this.mHealthCheckTimeout = anotherConfig.mHealthCheckTimeout;
            this.mWriteRetries = anotherConfig.mWriteRetries;
            this.mReadRetries = anotherConfig.mReadRetries;
            this.mMaxRetryDelay = anotherConfig.mMaxRetryDelay;
            this.mThreadKeepAlive = anotherConfig.mThreadKeepAlive;
            this.mHostPorts = anotherConfig.mHostPorts;
            this.mProvider = anotherConfig.mProvider;
            this.mRegion = anotherConfig.mRegion;
        }
    }

    public ClientConfig() {
        this.withConnectTimeout(1000L, TimeUnit.MILLISECONDS);
        this.withRequestTimeout(60000L, TimeUnit.MILLISECONDS);
        this.withHealthCheckInterval(5000L, TimeUnit.MILLISECONDS);
        this.withHealthCheckTimeout(1000L, TimeUnit.MILLISECONDS);
        this.withClusterUpdateInterval(4000L, TimeUnit.MILLISECONDS);
        this.withClusterUpdateThreshold(125L, TimeUnit.MILLISECONDS);
        this.withThreadKeepAlive(10000L, TimeUnit.MILLISECONDS);
        this.withMaxPendingConnectsPerHost(10);
        this.withWriteRetries(2);
        this.withReadRetries(2);
        this.withMaxRetryDelay(7000L, TimeUnit.MILLISECONDS);
    }

    public HostPort[] getHostPorts() {
        return this.mHostPorts;
    }

    public void setEndpoints(String ... hosts) {
        HostPort[] hostPort = new HostPort[hosts.length];
        for (int i = 0; i < hostPort.length; ++i) {
            hostPort[i] = HostPort.parse(hosts[i]);
        }
        this.mHostPorts = hostPort;
    }

    public ClientConfig withEndpoints(String ... hosts) {
        this.setEndpoints(hosts);
        return this;
    }

    public long getConnectTimeout() {
        return this.mConnectTimeout;
    }

    public void setConnectTimeout(long connectTimeout, TimeUnit unit) {
        this.mConnectTimeout = ClientConfig.toNanos(connectTimeout, unit);
    }

    public ClientConfig withConnectTimeout(long connectTimeout, TimeUnit unit) {
        this.setConnectTimeout(connectTimeout, unit);
        return this;
    }

    public long getRequestTimeout() {
        return this.mRequestTimeout;
    }

    public void setRequestTimeout(long RequestTimeout, TimeUnit unit) {
        this.mRequestTimeout = ClientConfig.toNanos(RequestTimeout, unit);
    }

    public ClientConfig withRequestTimeout(long RequestTimeout, TimeUnit unit) {
        this.setRequestTimeout(RequestTimeout, unit);
        return this;
    }

    public long getHealthCheckTimeout() {
        return this.mHealthCheckTimeout;
    }

    public void setHealthCheckTimeout(long healthCheckTimeout, TimeUnit unit) {
        this.mHealthCheckTimeout = ClientConfig.toNanos(healthCheckTimeout, unit);
    }

    public ClientConfig withHealthCheckTimeout(long healthCheckTimeout, TimeUnit unit) {
        this.setHealthCheckTimeout(healthCheckTimeout, unit);
        return this;
    }

    public long getHealthCheckInterval() {
        return this.mHealthCheckInterval;
    }

    public void setHealthCheckInterval(long healthCheckInterval, TimeUnit unit) {
        this.mHealthCheckInterval = ClientConfig.toNanos(healthCheckInterval, unit);
    }

    public ClientConfig withHealthCheckInterval(long healthCheckInterval, TimeUnit unit) {
        this.setHealthCheckInterval(healthCheckInterval, unit);
        return this;
    }

    public int getWriteRetries() {
        return this.mWriteRetries;
    }

    public void setWriteRetries(int writeRetries) {
        this.mWriteRetries = writeRetries;
    }

    public ClientConfig withWriteRetries(int writeRetries) {
        this.setWriteRetries(writeRetries);
        return this;
    }

    public int getMaxPendingConnectsPerHost() {
        return this.mMaxPendingConnectsPerHost;
    }

    public void setMaxPendingConnectsPerHost(int maxPending) {
        this.mMaxPendingConnectsPerHost = maxPending;
    }

    public ClientConfig withMaxPendingConnectsPerHost(int maxPending) {
        this.setMaxPendingConnectsPerHost(maxPending);
        return this;
    }

    public int getReadRetries() {
        return this.mReadRetries;
    }

    public void setReadRetries(int readRetries) {
        this.mReadRetries = readRetries;
    }

    public ClientConfig withReadRetries(int readRetries) {
        this.setReadRetries(readRetries);
        return this;
    }

    public long getThreadKeepAlive() {
        return this.mThreadKeepAlive;
    }

    public void setThreadKeepAlive(long threadKeepAlive, TimeUnit unit) {
        this.mThreadKeepAlive = ClientConfig.toNanos(threadKeepAlive, unit);
    }

    public ClientConfig withThreadKeepAlive(long threadKeepAlive, TimeUnit unit) {
        this.setThreadKeepAlive(threadKeepAlive, unit);
        return this;
    }

    public long getClusterUpdateInterval() {
        return this.mClusterUpdateInterval;
    }

    public void setClusterUpdateInterval(long clusterUpdateInterval, TimeUnit unit) {
        this.mClusterUpdateInterval = ClientConfig.toNanos(clusterUpdateInterval, unit);
    }

    public ClientConfig withClusterUpdateInterval(long clusterUpdateInterval, TimeUnit unit) {
        this.setClusterUpdateInterval(clusterUpdateInterval, unit);
        return this;
    }

    public long getClusterUpdateThreshold() {
        return this.mClusterUpdateThreshold;
    }

    public void setClusterUpdateThreshold(long clusterUpdateThreshold, TimeUnit unit) {
        this.mClusterUpdateThreshold = ClientConfig.toNanos(clusterUpdateThreshold, unit);
    }

    public ClientConfig withClusterUpdateThreshold(long clusterUpdateThreshold, TimeUnit unit) {
        this.setClusterUpdateThreshold(clusterUpdateThreshold, unit);
        return this;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.mProvider;
    }

    public void setCredentialsProvider(AWSCredentialsProvider provider) {
        this.mProvider = provider;
    }

    public ClientConfig withCredentialsProvider(AWSCredentialsProvider provider) {
        this.setCredentialsProvider(provider);
        return this;
    }

    public long getMaxRetryDelay() {
        return this.mMaxRetryDelay;
    }

    public void setMaxRetryDelay(long retryDelayCap, TimeUnit unit) {
        this.mMaxRetryDelay = ClientConfig.toNanos(retryDelayCap, unit);
    }

    public ClientConfig withMaxRetryDelay(long retryDelayCap, TimeUnit unit) {
        this.setMaxRetryDelay(retryDelayCap, unit);
        return this;
    }

    public String getRegion() {
        return this.mRegion;
    }

    public void setRegion(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("Region must not be null");
        }
        this.setRegion(region.getName());
    }

    public void setRegion(String region) {
        if (StringUtils.isNullOrEmpty((String)region)) {
            throw new IllegalArgumentException("Region must not be null or empty");
        }
        this.mRegion = region;
    }

    public ClientConfig withRegion(Region region) {
        this.setRegion(region);
        return this;
    }

    public ClientConfig withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    private static long toNanos(long timeout, TimeUnit unit) {
        if (timeout > 0L) {
            timeout = unit.toNanos(timeout);
        }
        return timeout < 0L ? -1L : timeout;
    }
}

