/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.cbor.SegmentPool;
import com.amazon.dax.bits.SegmentPool;
import com.amazon.dax.client.generated.DaxClientStubs;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.EnumMap;
import java.util.Map;

public class DaxRequestEncoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encodeOptionalArgs(EnumMap<DaxClientStubs.Constants.DaxDataRequestParam, Object> args, SegmentPool pool) throws IOException {
        SegmentPool.Segment head;
        SegmentPool.Segment tail = head = pool.alloc();
        try {
            if (args == null || args.isEmpty()) {
                tail = pool.chainAppend(tail, (byte)-10);
                byte[] byArray = pool.chainCopyAndTrim(head, 0);
                return byArray;
            }
            tail = pool.chainAppendCborMapStreamPrefix(tail);
            block9: for (Map.Entry<DaxClientStubs.Constants.DaxDataRequestParam, Object> entry : args.entrySet()) {
                Object value = entry.getValue();
                if (null == value) continue;
                tail = pool.chainAppendCborInteger(tail, entry.getKey().ordinal());
                switch (entry.getKey()) {
                    case ReturnItemCollectionMetrics: 
                    case ReturnConsumedCapacity: 
                    case ReturnValues: 
                    case Select: 
                    case Limit: 
                    case Segment: 
                    case TotalSegments: {
                        tail = pool.chainAppendCborInteger(tail, ((Integer)value).intValue());
                        continue block9;
                    }
                    case ConsistentRead: 
                    case ScanIndexForward: {
                        tail = pool.chainAppendCborInteger(tail, (Boolean)value != false ? 1L : 0L);
                        continue block9;
                    }
                    case ConditionExpression: 
                    case ExclusiveStartKey: 
                    case ProjectionExpression: 
                    case FilterExpression: 
                    case IndexName: 
                    case UpdateExpression: {
                        tail = pool.chainAppendCborBytes(tail, (byte[])value);
                        continue block9;
                    }
                }
                throw new UnsupportedEncodingException("Unknown value type: " + (Object)((Object)entry.getKey()));
            }
            tail = pool.chainAppendCborStreamBreak(tail);
            Object object = pool.chainCopyAndTrim(head, 0);
            return object;
        }
        finally {
            pool.chainRecycle(head);
        }
    }
}

