/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.cbor.CborInputStream;
import com.amazon.cbor.NonInputStream;
import com.amazon.dax.bits.DaxCborInputStream;
import com.amazon.dax.bits.dynamodb.DynamoNumerals;
import com.amazon.dax.client.dynamodbv2.AttributeValueDecoder;
import com.amazon.dax.client.dynamodbv2.DocumentPath;
import com.amazon.dax.client.dynamodbv2.SimpleCache;
import com.amazon.dax.client.exceptions.DecoderException;
import com.amazon.dax.client.generated.DaxClientStubs;
import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Capacity;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaxResponseDecoder {
    private static final DaxClientStubs.Constants.DaxResponseParam[] RESPONSE_PARAMS = DaxClientStubs.Constants.DaxResponseParam.values();

    public static Map<DaxClientStubs.Constants.DaxResponseParam, Object> decodeResponse(DaxCborInputStream input, SimpleCache<Long, List<String>> attrListIdCache, List<AttributeDefinition> keys) throws IOException {
        HashMap<DaxClientStubs.Constants.DaxResponseParam, Object> response = new HashMap<DaxClientStubs.Constants.DaxResponseParam, Object>();
        if (input.tryReadNull()) {
            return response;
        }
        if (input.fieldType() == 191) {
            input.consumeField();
            CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
            block6: while (input.fieldType() != 255) {
                int key = input.readInt();
                switch (RESPONSE_PARAMS[key]) {
                    case Attributes: {
                        input.beginStream();
                        wrapper.init(input);
                        response.put(DaxClientStubs.Constants.DaxResponseParam.Attributes, AttributeValueDecoder.decodeStreamItem(wrapper, attrListIdCache, null));
                        input.endStream();
                        continue block6;
                    }
                    case Item: {
                        input.beginStream();
                        wrapper.init(input);
                        response.put(DaxClientStubs.Constants.DaxResponseParam.Item, AttributeValueDecoder.decodeStreamItem(wrapper, attrListIdCache, null));
                        input.endStream();
                        continue block6;
                    }
                    case ConsumedCapacity: {
                        response.put(DaxClientStubs.Constants.DaxResponseParam.ConsumedCapacity, DaxResponseDecoder.decodeConsumedCapacity(input));
                        continue block6;
                    }
                    case ItemCollectionMetrics: {
                        response.put(DaxClientStubs.Constants.DaxResponseParam.ItemCollectionMetrics, DaxResponseDecoder.decodeItemCollectionMetrics(input, keys));
                        continue block6;
                    }
                }
                throw new DecoderException("Unknown value type: " + key);
            }
            input.consumeField();
        }
        return response;
    }

    public static UpdateItemResult decodeUpdateItemResult(DaxCborInputStream input, SimpleCache<Long, List<String>> attrListIdCache, List<AttributeDefinition> keys, UpdateItemRequest request) throws IOException {
        UpdateItemResult result = new UpdateItemResult();
        if (input.tryReadNull()) {
            return result;
        }
        if (input.fieldType() == 191) {
            input.consumeField();
            CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
            block9: while (input.fieldType() != 255) {
                int mapKey = input.readInt();
                switch (RESPONSE_PARAMS[mapKey]) {
                    case Attributes: {
                        switch (DynamoNumerals.ReturnValue.fromName(request.getReturnValues())) {
                            case ALL_OLD: 
                            case ALL_NEW: {
                                input.beginStream();
                                wrapper.init(input);
                                Map<String, AttributeValue> item = AttributeValueDecoder.decodeStreamItem(wrapper, attrListIdCache, null);
                                input.endStream();
                                if (item == null) continue block9;
                                if (keys.size() == request.getKey().size()) {
                                    item.putAll(request.getKey());
                                } else {
                                    for (AttributeDefinition key : keys) {
                                        String keyName = key.getAttributeName();
                                        item.put(keyName, (AttributeValue)request.getKey().get(keyName));
                                    }
                                }
                                result.setAttributes(item);
                                continue block9;
                            }
                            case UPDATED_OLD: 
                            case UPDATED_NEW: {
                                Map<String, AttributeValue> attrs = AttributeValueDecoder.decodeItemAttributeProjection(input, attrListIdCache, null);
                                if (attrs.isEmpty()) continue block9;
                                result.setAttributes(attrs);
                                continue block9;
                            }
                        }
                        input.skipObject();
                        continue block9;
                    }
                    case ConsumedCapacity: {
                        result.setConsumedCapacity(DaxResponseDecoder.decodeConsumedCapacity(input));
                        continue block9;
                    }
                    case ItemCollectionMetrics: {
                        result.setItemCollectionMetrics(DaxResponseDecoder.decodeItemCollectionMetrics(input, keys));
                        continue block9;
                    }
                }
                throw new DecoderException("Unknown value type: " + mapKey);
            }
            input.consumeField();
        }
        return result;
    }

    public static ScanResult decodeScanResult(DaxCborInputStream input, SimpleCache<Long, List<String>> attrListIdCache, List<AttributeDefinition> keys, String indexName, Map<Integer, DocumentPath> projOrdinals, ScanRequest request) throws IOException {
        ScanResult result = new ScanResult();
        if (input.tryReadNull()) {
            return result;
        }
        if (input.fieldType() == 191) {
            input.consumeField();
            ArrayList<List<AttributeValue>> anonAttributeValues = new ArrayList<List<AttributeValue>>();
            ArrayList<Long> attributeListIds = new ArrayList<Long>();
            ArrayList<Map<String, AttributeValue>> items = new ArrayList<Map<String, AttributeValue>>();
            block9: while (input.fieldType() != 255) {
                int mapKey = input.readInt();
                switch (RESPONSE_PARAMS[mapKey]) {
                    case Items: {
                        AttributeValueDecoder.decodeAnonymousItems(input, keys, projOrdinals, items, anonAttributeValues, attributeListIds);
                        continue block9;
                    }
                    case ConsumedCapacity: {
                        result.setConsumedCapacity(DaxResponseDecoder.decodeConsumedCapacity(input));
                        continue block9;
                    }
                    case Count: {
                        result.setCount(Integer.valueOf(input.readInt()));
                        continue block9;
                    }
                    case ScannedCount: {
                        result.setScannedCount(Integer.valueOf(input.readInt()));
                        continue block9;
                    }
                    case LastEvaluatedKey: {
                        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
                        if (indexName == null) {
                            AttributeValueDecoder.decodeKey(input, keys, key);
                        } else {
                            AttributeValueDecoder.decodeCompoundKey(input, key);
                        }
                        result.setLastEvaluatedKey(key.size() > 0 ? key : null);
                        continue block9;
                    }
                }
                throw new DecoderException("Unknown value type: " + mapKey);
            }
            input.consumeField();
            for (int i = 0; i < attributeListIds.size(); ++i) {
                List<String> attrNames;
                try {
                    attrNames = attrListIdCache.get((Long)attributeListIds.get(i));
                }
                catch (AmazonClientException e) {
                    throw new DecoderException(e);
                }
                AttributeValueDecoder.deanonymizeAttributeValues((Map)items.get(i), attrNames, (List)anonAttributeValues.get(i));
            }
            result.setItems(items);
        }
        return result;
    }

    public static QueryResult decodeQueryResult(DaxCborInputStream input, SimpleCache<Long, List<String>> attrListIdCache, List<AttributeDefinition> keys, String indexName, Map<Integer, DocumentPath> projOrdinals, QueryRequest request) throws IOException {
        QueryResult result = new QueryResult();
        if (input.tryReadNull()) {
            return result;
        }
        if (input.fieldType() == 191) {
            input.consumeField();
            ArrayList<List<AttributeValue>> anonAttributeValues = new ArrayList<List<AttributeValue>>();
            ArrayList<Long> attributeListIds = new ArrayList<Long>();
            ArrayList<Map<String, AttributeValue>> items = new ArrayList<Map<String, AttributeValue>>();
            block9: while (input.fieldType() != 255) {
                int mapKey = input.readInt();
                switch (RESPONSE_PARAMS[mapKey]) {
                    case Items: {
                        AttributeValueDecoder.decodeAnonymousItems(input, keys, projOrdinals, items, anonAttributeValues, attributeListIds);
                        continue block9;
                    }
                    case ConsumedCapacity: {
                        result.setConsumedCapacity(DaxResponseDecoder.decodeConsumedCapacity(input));
                        continue block9;
                    }
                    case Count: {
                        result.setCount(Integer.valueOf(input.readInt()));
                        continue block9;
                    }
                    case ScannedCount: {
                        result.setScannedCount(Integer.valueOf(input.readInt()));
                        continue block9;
                    }
                    case LastEvaluatedKey: {
                        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
                        if (indexName == null) {
                            AttributeValueDecoder.decodeKey(input, keys, key);
                        } else {
                            AttributeValueDecoder.decodeCompoundKey(input, key);
                        }
                        result.setLastEvaluatedKey(key.size() > 0 ? key : null);
                        continue block9;
                    }
                }
                throw new DecoderException("Unknown value type: " + mapKey);
            }
            input.consumeField();
            for (int i = 0; i < attributeListIds.size(); ++i) {
                List<String> attrNames;
                try {
                    attrNames = attrListIdCache.get((Long)attributeListIds.get(i));
                }
                catch (AmazonClientException e) {
                    throw new DecoderException(e);
                }
                AttributeValueDecoder.deanonymizeAttributeValues((Map)items.get(i), attrNames, (List)anonAttributeValues.get(i));
            }
            result.setItems(items);
        }
        return result;
    }

    public static ConsumedCapacity decodeConsumedCapacity(DaxCborInputStream input) throws IOException {
        if (input.tryReadNull()) {
            return null;
        }
        input.readBytesLength();
        ConsumedCapacity consumedCapacity = new ConsumedCapacity();
        consumedCapacity.setTableName((String)input.readObject());
        consumedCapacity.setCapacityUnits(Double.valueOf(input.readDouble()));
        if (input.fieldType() == 246) {
            input.consumeField();
        } else {
            Capacity table = new Capacity();
            table.setCapacityUnits(Double.valueOf(input.readDouble()));
            consumedCapacity.setTable(table);
        }
        consumedCapacity.setGlobalSecondaryIndexes(DaxResponseDecoder.decodeIndexConsumedCapacity(input));
        consumedCapacity.setLocalSecondaryIndexes(DaxResponseDecoder.decodeIndexConsumedCapacity(input));
        return consumedCapacity;
    }

    public static ItemCollectionMetrics decodeItemCollectionMetrics(DaxCborInputStream input, List<AttributeDefinition> keys) throws IOException {
        if (input.tryReadNull()) {
            return null;
        }
        input.readBytesLength();
        ItemCollectionMetrics itemCollectionMetrics = new ItemCollectionMetrics();
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        AttributeValueDecoder.decodeNamedItem(input, keys, item);
        itemCollectionMetrics.setItemCollectionKey(item);
        ArrayList<Double> sizeRange = new ArrayList<Double>(2);
        sizeRange.add(input.readDouble());
        sizeRange.add(input.readDouble());
        itemCollectionMetrics.setSizeEstimateRangeGB(sizeRange);
        return itemCollectionMetrics;
    }

    public static ConsumedCapacity newZeroConsumedCapacity(String tableName) {
        return new ConsumedCapacity().withTableName(tableName).withCapacityUnits(Double.valueOf(0.0));
    }

    private static Map<String, Capacity> decodeIndexConsumedCapacity(DaxCborInputStream input) throws IOException {
        int fieldType = input.fieldType();
        if (input.tryReadNull()) {
            return null;
        }
        if ((fieldType & 0xE0) == 160) {
            HashMap<String, Capacity> index = new HashMap<String, Capacity>();
            int size = input.readMapLength();
            for (int i = 0; i < size; ++i) {
                String indexName = (String)input.readObject();
                Capacity capacity = new Capacity();
                capacity.setCapacityUnits(Double.valueOf(input.readDouble()));
                index.put(indexName, capacity);
            }
            return index;
        }
        throw new DecoderException("Unknown object type: " + fieldType);
    }
}

