/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import java.util.Map;

public class DynamoDBExpressionInfo {
    private String mProjectionExpression = null;
    private String mConditionExpression = null;
    private String mUpdateExpression = null;
    private String mKeyConditionExpression = null;
    private String mFilterExpression = null;
    private Map<String, AttributeValue> mExpressionAttributeValues = null;
    private Map<String, String> mExpressionAttributeNames = null;

    public DynamoDBExpressionInfo(GetItemRequest request) {
        this.mProjectionExpression = request.getProjectionExpression();
        this.mExpressionAttributeNames = request.getExpressionAttributeNames();
    }

    public DynamoDBExpressionInfo(DeleteItemRequest request) {
        this.mConditionExpression = request.getConditionExpression();
        this.mExpressionAttributeNames = request.getExpressionAttributeNames();
        this.mExpressionAttributeValues = request.getExpressionAttributeValues();
    }

    public DynamoDBExpressionInfo(UpdateItemRequest request) {
        this.mUpdateExpression = request.getUpdateExpression();
        this.mConditionExpression = request.getConditionExpression();
        this.mExpressionAttributeNames = request.getExpressionAttributeNames();
        this.mExpressionAttributeValues = request.getExpressionAttributeValues();
    }

    public DynamoDBExpressionInfo(QueryRequest request) {
        this.mKeyConditionExpression = request.getKeyConditionExpression();
        this.mFilterExpression = request.getFilterExpression();
        this.mProjectionExpression = request.getProjectionExpression();
        this.mExpressionAttributeNames = request.getExpressionAttributeNames();
        this.mExpressionAttributeValues = request.getExpressionAttributeValues();
    }

    public DynamoDBExpressionInfo(ScanRequest request) {
        this.mFilterExpression = request.getFilterExpression();
        this.mProjectionExpression = request.getProjectionExpression();
        this.mExpressionAttributeNames = request.getExpressionAttributeNames();
        this.mExpressionAttributeValues = request.getExpressionAttributeValues();
    }

    public DynamoDBExpressionInfo(PutItemRequest request) {
        this.mConditionExpression = request.getConditionExpression();
        this.mExpressionAttributeNames = request.getExpressionAttributeNames();
        this.mExpressionAttributeValues = request.getExpressionAttributeValues();
    }

    public DynamoDBExpressionInfo(KeysAndAttributes request) {
        this.mProjectionExpression = request.getProjectionExpression();
        this.mExpressionAttributeNames = request.getExpressionAttributeNames();
    }

    public DynamoDBExpressionInfo(String projectionExpression, String conditionExpression, String updateExpression, String keyConditionExpression, String filterExpression, Map<String, AttributeValue> expressionAttributeValues, Map<String, String> expressionAttributeNames) {
        this.mProjectionExpression = projectionExpression;
        this.mConditionExpression = conditionExpression;
        this.mUpdateExpression = updateExpression;
        this.mKeyConditionExpression = keyConditionExpression;
        this.mFilterExpression = filterExpression;
        this.mExpressionAttributeValues = expressionAttributeValues;
        this.mExpressionAttributeNames = expressionAttributeNames;
    }

    public String getProjectionExpression() {
        return this.mProjectionExpression;
    }

    public String getConditionExpression() {
        return this.mConditionExpression;
    }

    public String getUpdateExpression() {
        return this.mUpdateExpression;
    }

    public String getKeyConditionExpression() {
        return this.mKeyConditionExpression;
    }

    public String getFilterExpression() {
        return this.mFilterExpression;
    }

    public Map<String, AttributeValue> getExpressionAttributeValues() {
        return this.mExpressionAttributeValues;
    }

    public Map<String, String> getExpressionAttributeNames() {
        return this.mExpressionAttributeNames;
    }

    public static class DynamoDBExpressionInfoBuilder {
        private String mProjectionExpression;
        private String mConditionExpression;
        private String mUpdateExpression;
        private String mKeyConditionExpression;
        private String mFilterExpression;
        private Map<String, AttributeValue> mExpressionAttributeValues;
        private Map<String, String> mExpressionAttributeNames;

        public DynamoDBExpressionInfoBuilder setProjectionExpression(String projectionExpression) {
            this.mProjectionExpression = projectionExpression;
            return this;
        }

        public DynamoDBExpressionInfoBuilder setConditionExpression(String conditionExpression) {
            this.mConditionExpression = conditionExpression;
            return this;
        }

        public DynamoDBExpressionInfoBuilder setUpdateExpression(String updateExpression) {
            this.mUpdateExpression = updateExpression;
            return this;
        }

        public DynamoDBExpressionInfoBuilder setKeyConditionExpression(String keyConditionExpression) {
            this.mKeyConditionExpression = keyConditionExpression;
            return this;
        }

        public DynamoDBExpressionInfoBuilder setFilterExpression(String filterExpression) {
            this.mFilterExpression = filterExpression;
            return this;
        }

        public DynamoDBExpressionInfoBuilder setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            if (expressionAttributeValues != null) {
                this.mExpressionAttributeValues = expressionAttributeValues.isEmpty() ? null : expressionAttributeValues;
            }
            return this;
        }

        public DynamoDBExpressionInfoBuilder setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            if (expressionAttributeNames != null) {
                this.mExpressionAttributeNames = expressionAttributeNames.isEmpty() ? null : expressionAttributeNames;
            }
            return this;
        }

        public DynamoDBExpressionInfo createDynamoDBExpressionInfo() {
            return new DynamoDBExpressionInfo(this.mProjectionExpression, this.mConditionExpression, this.mUpdateExpression, this.mKeyConditionExpression, this.mFilterExpression, this.mExpressionAttributeValues, this.mExpressionAttributeNames);
        }
    }
}

