/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.cbor.CborInputStream;
import com.amazon.dax.client.exceptions.MalformedResultException;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DynamoDbObjectHelpers {
    static TableDescription readTableDescription(CborInputStream input) throws IOException {
        return DynamoDbObjectHelpers.readTableDescription((Map)input.readObject());
    }

    static TableDescription readTableDescription(Map<String, Object> result) {
        Object gsis;
        TableDescription table = new TableDescription().withTableName(DynamoDbObjectHelpers.asString(result.get("TableName"))).withTableArn(DynamoDbObjectHelpers.asString(result.get("TableArn"))).withTableStatus(DynamoDbObjectHelpers.asString(result.get("TableStatus"))).withTableSizeBytes(DynamoDbObjectHelpers.asLong(result.get("TableSizeBytes"))).withItemCount(DynamoDbObjectHelpers.asLong(result.get("ItemCount"))).withCreationDateTime(DynamoDbObjectHelpers.asDate(result.get("CreationDateTime"))).withLatestStreamArn(DynamoDbObjectHelpers.asString(result.get("LatestStreamArn"))).withLatestStreamLabel(DynamoDbObjectHelpers.asString(result.get("LatestStreamLabel")));
        table.setProvisionedThroughput(DynamoDbObjectHelpers.buildProvisionedThroughput(result.get("ProvisionedThroughput")));
        table.setKeySchema(DynamoDbObjectHelpers.buildKeySchema(result.get("KeySchema")));
        table.setAttributeDefinitions(DynamoDbObjectHelpers.buildAttributeDefinitions(result.get("AttributeDefinitions")));
        table.setStreamSpecification(DynamoDbObjectHelpers.buildStreamSpecification(result.get("StreamSpecification")));
        Object lsis = result.get("LocalSecondaryIndexes");
        if (lsis != null) {
            List lsiInfo = (List)lsis;
            ArrayList<LocalSecondaryIndexDescription> descriptions = new ArrayList<LocalSecondaryIndexDescription>(lsiInfo.size());
            for (Map lsi : lsiInfo) {
                descriptions.add(DynamoDbObjectHelpers.buildLocalSecondaryIndexDescription(lsi));
            }
            table.setLocalSecondaryIndexes(descriptions);
        }
        if ((gsis = result.get("GlobalSecondaryIndexes")) != null) {
            List gsiInfo = (List)gsis;
            ArrayList<GlobalSecondaryIndexDescription> descriptions = new ArrayList<GlobalSecondaryIndexDescription>(gsiInfo.size());
            for (Map gsi : gsiInfo) {
                descriptions.add(DynamoDbObjectHelpers.buildGlobalSecondaryIndexDescription(gsi));
            }
            table.setGlobalSecondaryIndexes(descriptions);
        }
        return table;
    }

    private static Collection<AttributeDefinition> buildAttributeDefinitions(Object attributeDefs) {
        if (attributeDefs == null) {
            return null;
        }
        List attributeDefsInfo = (List)attributeDefs;
        ArrayList<AttributeDefinition> definitions = new ArrayList<AttributeDefinition>(attributeDefsInfo.size());
        for (Map attrDef : attributeDefsInfo) {
            definitions.add(new AttributeDefinition((String)attrDef.get("AttributeName"), (String)attrDef.get("AttributeType")));
        }
        return definitions;
    }

    private static Collection<KeySchemaElement> buildKeySchema(Object elements) {
        if (elements == null) {
            return null;
        }
        List elementsInfo = (List)elements;
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>(elementsInfo.size());
        for (Map element : elementsInfo) {
            keySchema.add(new KeySchemaElement((String)element.get("AttributeName"), (String)element.get("KeyType")));
        }
        return keySchema;
    }

    private static Projection buildProjection(Object values) {
        if (values == null) {
            return null;
        }
        Map projection = (Map)values;
        return new Projection().withNonKeyAttributes((Collection)((List)projection.get("NonKeyAttributes"))).withProjectionType((String)projection.get("ProjectionType"));
    }

    private static StreamSpecification buildStreamSpecification(Object streamSpec) {
        if (streamSpec == null) {
            return null;
        }
        Map stream = (Map)streamSpec;
        return new StreamSpecification().withStreamEnabled(DynamoDbObjectHelpers.asBoolean(stream.get("StreamEnabled"))).withStreamViewType(DynamoDbObjectHelpers.asString(stream.get("StreamViewType")));
    }

    private static LocalSecondaryIndexDescription buildLocalSecondaryIndexDescription(Map<String, Object> values) {
        return new LocalSecondaryIndexDescription().withIndexName(DynamoDbObjectHelpers.asString(values.get("IndexName"))).withIndexArn(DynamoDbObjectHelpers.asString(values.get("IndexArn"))).withIndexSizeBytes(DynamoDbObjectHelpers.asLong(values.get("IndexSizeBytes"))).withItemCount(DynamoDbObjectHelpers.asLong(values.get("ItemCount"))).withKeySchema(DynamoDbObjectHelpers.buildKeySchema(values.get("KeySchema"))).withProjection(DynamoDbObjectHelpers.buildProjection(values.get("Projection")));
    }

    private static GlobalSecondaryIndexDescription buildGlobalSecondaryIndexDescription(Map<String, Object> values) {
        return new GlobalSecondaryIndexDescription().withIndexName(DynamoDbObjectHelpers.asString(values.get("IndexName"))).withIndexArn(DynamoDbObjectHelpers.asString(values.get("IndexArn"))).withIndexStatus(DynamoDbObjectHelpers.asString(values.get("IndexStatus"))).withIndexSizeBytes(DynamoDbObjectHelpers.asLong(values.get("IndexSizeBytes"))).withItemCount(DynamoDbObjectHelpers.asLong(values.get("ItemCount"))).withProvisionedThroughput(DynamoDbObjectHelpers.buildProvisionedThroughput(values.get("ProvisionedThroughput"))).withKeySchema(DynamoDbObjectHelpers.buildKeySchema(values.get("KeySchema"))).withProjection(DynamoDbObjectHelpers.buildProjection(values.get("Projection"))).withBackfilling(DynamoDbObjectHelpers.asBoolean(values.get("Backfilling")));
    }

    private static ProvisionedThroughputDescription buildProvisionedThroughput(Object values) {
        if (values == null) {
            return null;
        }
        Map pt = (Map)values;
        return new ProvisionedThroughputDescription().withLastDecreaseDateTime(DynamoDbObjectHelpers.asDate(pt.get("LastDecreaseDateTime"))).withLastIncreaseDateTime(DynamoDbObjectHelpers.asDate(pt.get("LastIncreaseDateTime"))).withNumberOfDecreasesToday(DynamoDbObjectHelpers.asLong(pt.get("NumberOfDecreasesToday"))).withReadCapacityUnits(DynamoDbObjectHelpers.asLong(pt.get("ReadCapacityUnits"))).withWriteCapacityUnits(DynamoDbObjectHelpers.asLong(pt.get("WriteCapacityUnits")));
    }

    private static Long asLong(Object l) {
        if (l == null) {
            return null;
        }
        if (l instanceof BigInteger) {
            return ((BigInteger)l).longValue();
        }
        if (l instanceof Long) {
            return (Long)l;
        }
        if (l instanceof Integer) {
            return ((Integer)l).longValue();
        }
        throw new MalformedResultException(String.format("Expected number, got '%s'", l.getClass().getName()));
    }

    private static Date asDate(Object d) {
        if (d == null) {
            return null;
        }
        if (d instanceof Double) {
            Double dub = (Double)d;
            return new Date(dub.longValue() * 1000L);
        }
        return new Date(DynamoDbObjectHelpers.asLong(d));
    }

    private static String asString(Object s) {
        if (s == null) {
            return null;
        }
        return (String)s;
    }

    private static Boolean asBoolean(Object b) {
        if (b == null) {
            return null;
        }
        return (Boolean)b;
    }
}

