/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.bits.dynamodb.DynamoNumerals;
import com.amazon.dax.client.dynamodbv2.RetryHandler;
import com.amazon.dax.client.exceptions.DaxServiceException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.model.InternalServerErrorException;
import com.amazonaws.services.dynamodbv2.model.LimitExceededException;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;

public class ReadRetryHandler
implements RetryHandler {
    @Override
    public boolean isRetryable(Exception e) {
        if (e instanceof DaxServiceException || e instanceof AmazonClientException && e.getCause() != null && e.getCause() instanceof DaxServiceException) {
            DaxServiceException dse = e instanceof DaxServiceException ? (DaxServiceException)((Object)e) : (DaxServiceException)((Object)e.getCause());
            return dse.getErrorCode() != null && (dse.getErrorCode().equals(DynamoNumerals.ErrorCodes.THROTTLING_ERROR.mErrorCode) || dse.getStatusCode() == 503) || dse.isRetryable();
        }
        if (e instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)e;
            return e instanceof InternalServerErrorException || e instanceof LimitExceededException || e instanceof ProvisionedThroughputExceededException;
        }
        if (e instanceof AmazonClientException) {
            AmazonClientException ace = (AmazonClientException)((Object)e);
            return ace.isRetryable();
        }
        return true;
    }
}

