/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.exceptions;

import com.amazon.cbor.CborInputStream;
import com.amazon.dax.bits.dynamodb.DynamoNumerals;
import com.amazon.dax.client.ClientTube;
import com.amazon.dax.client.exceptions.MalformedResultException;
import com.amazon.dax.client.utils.Utils;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import java.io.IOException;
import java.util.List;

public class DaxServiceException
extends AmazonServiceException {
    public static final String NOT_IMPLEMENTED = "NotImplementedException";
    private static final int[] NO_ERROR_CODES = new int[0];
    private final String mErrorMessage;
    private final int[] mCodeSeq;
    private final boolean mWaitForRecoveryBeforeRetrying;
    private boolean mIsRetryable;

    public int[] getCodeSeq() {
        return this.mCodeSeq == null ? NO_ERROR_CODES : this.mCodeSeq;
    }

    public String getServiceErrorMessage() {
        return this.mErrorMessage;
    }

    public static DaxServiceException pickException(CborInputStream input, ClientTube tube) throws AmazonClientException, IOException {
        Object errCodesObj = input.readObject();
        if (errCodesObj == null) {
            throw new MalformedResultException("Response cannot be null", errCodesObj);
        }
        if (!(errCodesObj instanceof List)) {
            throw new MalformedResultException("Response header must be an array", errCodesObj);
        }
        List codeSeqList = (List)errCodesObj;
        if (codeSeqList.size() == 0) {
            return null;
        }
        int[] errCodes = new int[codeSeqList.size()];
        for (int i = 0; i < codeSeqList.size(); ++i) {
            Object errCodeObj = codeSeqList.get(i);
            if (errCodeObj == null || !(errCodeObj instanceof Number)) {
                throw new MalformedResultException("Error codes must be non-null integers", errCodeObj);
            }
            int errCode = ((Number)errCodeObj).intValue();
            if (!errCodeObj.equals(errCode)) {
                throw new MalformedResultException("Error codes must be in integer range", errCodeObj);
            }
            errCodes[i] = errCode;
        }
        Object messageObj = input.readObject();
        if (messageObj == null || !(messageObj instanceof String)) {
            throw new MalformedResultException("Expected non-null string", messageObj);
        }
        String message = (String)messageObj;
        String requestId = null;
        String errorCode = null;
        int statusCode = -1;
        if (input.fieldType() != 246) {
            int length = input.readArrayLength();
            if (length != 3) {
                throw new MalformedResultException("Expected 3 elements in the exception info", length);
            }
            requestId = (String)input.readObject();
            errorCode = (String)input.readObject();
            statusCode = input.readInt();
        } else {
            input.skipObject();
        }
        if (errCodes.length >= 4 && errCodes[1] == 23 && errCodes[2] == 31 && (errCodes[3] == 32 || errCodes[3] == 33 || errCodes[3] == 34)) {
            tube.invalidateAuth();
        }
        boolean isRetryable = false;
        if (errCodes.length >= 1 && (errCodes[0] == 1 || errCodes[0] == 2)) {
            isRetryable = true;
        }
        boolean waitForRecoveryBeforeRetrying = false;
        if (errCodes.length >= 1 && errCodes[0] == 2) {
            waitForRecoveryBeforeRetrying = true;
        }
        return new DaxServiceException(message, requestId, errorCode, statusCode, errCodes, isRetryable, waitForRecoveryBeforeRetrying);
    }

    public DaxServiceException(String errorMessage, String requestId, String errorCode, int statusCode, int[] codeSeq, boolean isRetryable, boolean waitForClusterRecoveryBeforeRetrying) {
        super(DaxServiceException.formatMessage(errorMessage, codeSeq));
        this.setRequestId(requestId);
        this.setStatusCode(statusCode);
        this.setErrorCode(errorCode);
        this.mErrorMessage = errorMessage;
        this.mCodeSeq = codeSeq;
        this.mIsRetryable = isRetryable;
        this.mWaitForRecoveryBeforeRetrying = waitForClusterRecoveryBeforeRetrying;
    }

    public DaxServiceException(Exception t, boolean isRetryable) {
        super(t.getMessage(), t);
        this.setStatusCode(-1);
        this.mErrorMessage = t.getMessage();
        this.mCodeSeq = null;
        this.mIsRetryable = isRetryable;
        this.mWaitForRecoveryBeforeRetrying = false;
    }

    public DaxServiceException(String errMessage, String errorCode) {
        super(errMessage);
        this.setErrorCode(errorCode);
        this.setStatusCode(-1);
        this.mErrorMessage = errMessage;
        this.mCodeSeq = null;
        this.mIsRetryable = false;
        this.mWaitForRecoveryBeforeRetrying = false;
    }

    public String getMessage() {
        if (DynamoNumerals.ErrorCodes.VALIDATION_ERROR.mErrorCode.equals(this.getErrorCode())) {
            return this.getErrorMessage();
        }
        return super.getMessage();
    }

    public boolean isRetryable() {
        return this.mIsRetryable;
    }

    public boolean waitForClusterRecoveryBeforeRetry() {
        return this.mWaitForRecoveryBeforeRetrying;
    }

    public void setRetryable(boolean retryable) {
        this.mIsRetryable = retryable;
    }

    private static String formatMessage(String errorMessage, int[] codeSeq) {
        CharSequence[] codeSeqStrs = new String[codeSeq.length];
        for (int i = 0; i < codeSeq.length; ++i) {
            codeSeqStrs[i] = Integer.toString(codeSeq[i]);
        }
        return String.format("[%s] %s", Utils.stringJoin(".", codeSeqStrs), errorMessage);
    }
}

