/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.generated;

import com.amazon.cbor.Encoder;
import com.amazon.dax.bits.DaxCborInputStream;
import com.amazon.dax.bits.DaxCborOutputStream;
import com.amazon.dax.bits.LazyClock;
import com.amazon.dax.client.ClientTube;
import com.amazon.dax.client.TubePool;
import com.amazon.dax.client.dynamodbv2.SigV4Gen;
import com.amazon.dax.client.exceptions.DaxServiceException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.io.IOException;
import java.util.Collection;

public class DaxClientStubs {
    private static final int SUCCESS = 128;
    protected static final double WINDOW_SCALAR = 0.1;
    private final TubePool mPool;
    private final LazyClock mClock;
    private final String mUserAgent;
    private volatile String mRegion;
    private final String mDaxAddr = "https://dax.amazonaws.com";
    private volatile long mLastPoolAuth;
    protected long mAuthTTLMillis = 300000L;
    protected volatile long mPoolWindow;
    protected volatile long mTubeWindow;
    private AWSCredentialsProvider mCreds;

    public DaxClientStubs(TubePool pool, String region, String userAgent, AWSCredentialsProvider creds) {
        this.mPool = pool;
        this.mClock = LazyClock.instance();
        this.mUserAgent = userAgent;
        this.mRegion = region;
        this.mPoolWindow = this.mAuthTTLMillis / 2L;
        this.mTubeWindow = (long)((double)this.mAuthTTLMillis * 0.1);
        this.mCreds = creds;
    }

    public void authorizeConnection_1489122155_1(String accessKeyId, String signature, byte[] stringToSign, String sessionToken, String userAgent, ClientTube tube) throws IOException, AmazonClientException {
        if (accessKeyId == null) {
            throw this.nullParameterException("accessKeyId");
        }
        if (signature == null) {
            throw this.nullParameterException("signature");
        }
        if (stringToSign == null) {
            throw this.nullParameterException("stringToSign");
        }
        DaxCborOutputStream output = tube.getOutputStream();
        output.writeInt(1);
        output.writeInt(1489122155);
        output.writeString(accessKeyId);
        output.writeString(signature);
        output.writeBytes(stringToSign);
        if (sessionToken == null) {
            output.writeNull();
        } else {
            output.writeString(sessionToken);
        }
        if (userAgent == null) {
            output.writeNull();
        } else {
            output.writeString(userAgent);
        }
    }

    public ClientTube batchGetItem_N697851100_1(byte[] getItemKeys, byte[] kwargs) throws IOException, AmazonClientException {
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(-697851100);
            if (getItemKeys == null) {
                output.writeNull();
            } else {
                output.write(getItemKeys);
            }
            if (kwargs == null) {
                output.writeNull();
            } else {
                output.write(kwargs);
            }
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube batchWriteItem_116217951_1(byte[] keyValuesByTable, byte[] kwargs) throws IOException, AmazonClientException {
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(116217951);
            if (keyValuesByTable == null) {
                output.writeNull();
            } else {
                output.write(keyValuesByTable);
            }
            if (kwargs == null) {
                output.writeNull();
            } else {
                output.write(kwargs);
            }
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube createTable_N313431286_1(byte[] createTableRequest) throws IOException, AmazonClientException {
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(-313431286);
            if (createTableRequest == null) {
                output.writeNull();
            } else {
                output.write(createTableRequest);
            }
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube defineAttributeList_670678385_1(long attributeListId) throws IOException, AmazonClientException {
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(670678385);
            output.writeLong(attributeListId);
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube defineAttributeListId_N1230579644_1(Collection attributeNames) throws IOException, AmazonClientException {
        if (attributeNames == null) {
            throw this.nullParameterException("attributeNames");
        }
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(-1230579644);
            output.writeCollection(attributeNames);
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube defineKeySchema_N742646399_1(byte[] tableName) throws IOException, AmazonClientException {
        if (tableName == null) {
            throw this.nullParameterException("tableName");
        }
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(-742646399);
            output.writeBytes(tableName);
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube deleteItem_1013539361_1(byte[] tableName, byte[] cborKey, byte[] kwargs) throws IOException, AmazonClientException {
        if (tableName == null) {
            throw this.nullParameterException("tableName");
        }
        if (cborKey == null) {
            throw this.nullParameterException("cborKey");
        }
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(1013539361);
            output.writeBytes(tableName);
            output.writeBytes(cborKey);
            if (kwargs == null) {
                output.writeNull();
            } else {
                output.write(kwargs);
            }
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube deleteTable_2120496185_1(byte[] tableName) throws IOException, AmazonClientException {
        if (tableName == null) {
            throw this.nullParameterException("tableName");
        }
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(2120496185);
            output.writeBytes(tableName);
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube describeLimits_N475661135_1() throws IOException, AmazonClientException {
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(-475661135);
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube describeTable_N819330193_1(byte[] tableName) throws IOException, AmazonClientException {
        if (tableName == null) {
            throw this.nullParameterException("tableName");
        }
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(-819330193);
            output.writeBytes(tableName);
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube endpoints_455855874_1() throws IOException, AmazonClientException {
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(455855874);
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube getItem_263244906_1(byte[] tableName, byte[] key, byte[] kwargs) throws IOException, AmazonClientException {
        if (tableName == null) {
            throw this.nullParameterException("tableName");
        }
        if (key == null) {
            throw this.nullParameterException("key");
        }
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(263244906);
            output.writeBytes(tableName);
            output.writeBytes(key);
            if (kwargs == null) {
                output.writeNull();
            } else {
                output.write(kwargs);
            }
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube listTables_1874119219_1(String exclusiveStartTableName, int limit) throws IOException, AmazonClientException {
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(1874119219);
            if (exclusiveStartTableName == null) {
                output.writeNull();
            } else {
                output.writeString(exclusiveStartTableName);
            }
            output.writeInt(limit);
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube methods_785068263_1(int serviceId) throws IOException, AmazonClientException {
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(785068263);
            output.writeInt(serviceId);
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube putItem_N2106490455_1(byte[] tableName, byte[] cborKey, byte[] cborValue, byte[] kwargs) throws IOException, AmazonClientException {
        if (tableName == null) {
            throw this.nullParameterException("tableName");
        }
        if (cborKey == null) {
            throw this.nullParameterException("cborKey");
        }
        if (cborValue == null) {
            throw this.nullParameterException("cborValue");
        }
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(-2106490455);
            output.writeBytes(tableName);
            output.writeBytes(cborKey);
            output.writeBytes(cborValue);
            if (kwargs == null) {
                output.writeNull();
            } else {
                output.write(kwargs);
            }
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube query_N931250863_1(byte[] tableName, byte[] keyConditionExpression, byte[] kwargs) throws IOException, AmazonClientException {
        if (tableName == null) {
            throw this.nullParameterException("tableName");
        }
        if (keyConditionExpression == null) {
            throw this.nullParameterException("keyConditionExpression");
        }
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(-931250863);
            output.writeBytes(tableName);
            output.writeBytes(keyConditionExpression);
            if (kwargs == null) {
                output.writeNull();
            } else {
                output.write(kwargs);
            }
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube scan_N1875390620_1(byte[] tableName, byte[] kwargs) throws IOException, AmazonClientException {
        if (tableName == null) {
            throw this.nullParameterException("tableName");
        }
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(-1875390620);
            output.writeBytes(tableName);
            if (kwargs == null) {
                output.writeNull();
            } else {
                output.write(kwargs);
            }
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube services_N1016793520_1() throws IOException, AmazonClientException {
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(-1016793520);
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube updateItem_1425579023_1(byte[] tableName, byte[] cborKey, byte[] kwargs) throws IOException, AmazonClientException {
        if (tableName == null) {
            throw this.nullParameterException("tableName");
        }
        if (cborKey == null) {
            throw this.nullParameterException("cborKey");
        }
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(1425579023);
            output.writeBytes(tableName);
            output.writeBytes(cborKey);
            if (kwargs == null) {
                output.writeNull();
            } else {
                output.write(kwargs);
            }
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    public ClientTube updateTable_383747477_1(byte[] updateTableRequest) throws IOException, AmazonClientException {
        ClientTube tube = this.mPool.alloc();
        try {
            this.checkTubeAuth(tube);
            DaxCborOutputStream output = tube.getOutputStream();
            output.writeInt(1);
            output.writeInt(383747477);
            if (updateTableRequest == null) {
                output.writeNull();
            } else {
                output.write(updateTableRequest);
            }
            output.flush();
        }
        catch (Throwable e) {
            this.silentReset(tube);
            throw e;
        }
        this.handleResponse(tube);
        return tube;
    }

    private void silentReset(ClientTube tube) {
        try {
            this.mPool.reset(tube);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkTubeAuth(ClientTube tube) throws IOException {
        long currTime = this.mClock.getCurrentTime();
        AWSCredentials creds = this.mCreds.getCredentials();
        if (!tube.checkAndUpdateAccessKeyId(creds.getAWSAccessKeyId()) || tube.getAuthExp() - currTime <= this.mTubeWindow || currTime - this.mLastPoolAuth >= this.mPoolWindow) {
            this.mLastPoolAuth = currTime;
            SigV4Gen.SigAndStringToSign sigHead = SigV4Gen.generateSigAndStringToSign(creds, "https://dax.amazonaws.com", this.mRegion, "");
            this.authorizeConnection_1489122155_1(creds.getAWSAccessKeyId(), sigHead.mSignature, Encoder.encodeUtf8(sigHead.mStringToSign), sigHead.mSessionToken, this.mUserAgent, tube);
            tube.setAuthExp(currTime + this.mAuthTTLMillis);
        }
    }

    public void handleResponse(ClientTube tube) throws AmazonClientException, IOException {
        DaxServiceException callException = null;
        try {
            DaxCborInputStream input = tube.getInputStream();
            int statusCode = input.fieldType();
            if (statusCode == 128) {
                input.consumeField();
                return;
            }
            callException = DaxServiceException.pickException(input, tube);
        }
        catch (Exception e) {
            this.silentReset(tube);
            throw e;
        }
        if (callException != null) {
            this.mPool.recycle(tube);
            throw callException;
        }
    }

    private IllegalArgumentException nullParameterException(String valueName) {
        return new IllegalArgumentException(String.format("'%s' cannot be null", valueName));
    }

    public synchronized void setAuthTTLMillis(long authTTLMillis) {
        this.mAuthTTLMillis = authTTLMillis;
        this.mTubeWindow = (long)((double)authTTLMillis * 0.1);
        this.mPoolWindow = authTTLMillis / 2L;
    }

    public void setRegion(String region) {
        this.mRegion = region;
    }

    public static class Constants {

        public static enum DaxDataRequestParam {
            ProjectionExpression,
            ExpressionAttributeNames,
            ConsistentRead,
            ReturnConsumedCapacity,
            ConditionExpression,
            ExpressionAttributeValues,
            ReturnItemCollectionMetrics,
            ReturnValues,
            UpdateExpression,
            ExclusiveStartKey,
            FilterExpression,
            IndexName,
            KeyConditionExpression,
            Limit,
            ScanIndexForward,
            Select,
            Segment,
            TotalSegments,
            RequestItems;

        }

        public static enum DaxTableRequestParam {
            AttributeDefinitions,
            KeySchema,
            ProvisionedThroughput,
            GlobalSecondaryIndexes,
            LocalSecondaryIndexes,
            StreamSpecification,
            GlobalSecondaryIndexUpdates,
            ExclusiveStartTableName,
            Limit;

        }

        public static enum DaxResponseParam {
            Item,
            ConsumedCapacity,
            Attributes,
            ItemCollectionMetrics,
            Responses,
            UnprocessedKeys,
            UnprocessedItems,
            Items,
            Count,
            LastEvaluatedKey,
            ScannedCount,
            TableDescription;

        }
    }

    public static final class DaxMethodIds {
        public static final int authorizeConnection_1489122155_1_Id = 1489122155;
        public static final int batchGetItem_N697851100_1_Id = -697851100;
        public static final int batchWriteItem_116217951_1_Id = 116217951;
        public static final int createTable_N313431286_1_Id = -313431286;
        public static final int defineAttributeList_670678385_1_Id = 670678385;
        public static final int defineAttributeListId_N1230579644_1_Id = -1230579644;
        public static final int defineKeySchema_N742646399_1_Id = -742646399;
        public static final int deleteItem_1013539361_1_Id = 1013539361;
        public static final int deleteTable_2120496185_1_Id = 2120496185;
        public static final int describeLimits_N475661135_1_Id = -475661135;
        public static final int describeTable_N819330193_1_Id = -819330193;
        public static final int endpoints_455855874_1_Id = 455855874;
        public static final int getItem_263244906_1_Id = 263244906;
        public static final int listTables_1874119219_1_Id = 1874119219;
        public static final int methods_785068263_1_Id = 785068263;
        public static final int putItem_N2106490455_1_Id = -2106490455;
        public static final int query_N931250863_1_Id = -931250863;
        public static final int scan_N1875390620_1_Id = -1875390620;
        public static final int services_N1016793520_1_Id = -1016793520;
        public static final int updateItem_1425579023_1_Id = 1425579023;
        public static final int updateTable_383747477_1_Id = 383747477;
    }
}

