/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.cbor;

import com.amazon.cbor.CborEncodingException;
import com.amazon.cbor.Decoder;
import com.amazon.cbor.EndOfStreamException;
import com.amazon.cbor.NonInputStream;
import com.amazon.cbor.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class CborInputStream
extends InputStream {
    private static final MethodHandle cToZonedDateTime;
    private static final MethodHandle cToLocalDateTime;
    private static final MethodHandle cToInstantFromLong;
    private static final MethodHandle cToInstantFromSecondsNanos;
    private static final MethodHandle cToInstantFromDouble;
    private static final MethodHandle cToInstantFromBigInteger;
    private static final MethodHandle cToInstantFromBigDecimal;
    private static final int MIN_BUFFER_SIZE = 9;
    private static final byte[] EMPTY_BYTES;
    private InputStream mIn;
    private int mLimit = Integer.MAX_VALUE;
    private final byte[] mBuffer;
    private int mPos;
    private int mEnd;
    private int mFieldType;
    private long mFieldValue;
    private int mStreamDepth = -1;
    private int mStreamChunk;

    public CborInputStream(InputStream in) {
        this(in, 8192);
    }

    public CborInputStream(InputStream in, int bufferSize) {
        this.mIn = in;
        this.mBuffer = new byte[Math.max(9, bufferSize)];
        this.mFieldType = -1;
    }

    public CborInputStream(InputStream in, byte[] buffer, int offset, int length) {
        if (buffer.length < 9 || (offset | offset + length | buffer.length - (offset + length)) < 0) {
            throw new IllegalArgumentException();
        }
        this.mIn = in;
        this.mBuffer = buffer;
        this.mPos = offset;
        this.mEnd = offset + length;
        this.mFieldType = -1;
    }

    public CborInputStream(byte[] src) {
        this(src, 0, src.length);
    }

    public CborInputStream(byte[] src, int offset) {
        this(src, offset, src.length - offset);
    }

    public CborInputStream(byte[] src, int offset, int length) {
        this.mIn = NonInputStream.THE;
        this.mBuffer = src;
        this.mPos = offset;
        this.mEnd = offset + length;
        this.mFieldType = -1;
    }

    public void init(InputStream toWrap) throws IOException {
        this.mPos = 0;
        this.mEnd = 0;
        this.mStreamDepth = -1;
        this.mFieldType = -1;
        this.mStreamChunk = 0;
        this.mFieldValue = 0;
        this.mIn = toWrap;
    }

    public int limit(int limit) {
        int oldLimit = -1;
        if (this.mIn instanceof Limiter) {
            Limiter lin = (Limiter)this.mIn;
            int end = lin.mBufEndPos;
            if (end < 0) {
                oldLimit = this.mLimit;
            } else {
                oldLimit = this.mEnd - this.mPos;
                this.mEnd = end;
            }
            this.mIn = lin.mSource;
            this.mLimit = Integer.MAX_VALUE;
        }
        if (limit > 0) {
            if ((limit -= this.mEnd - this.mPos) < 0) {
                this.mIn = new Limiter(this.mIn, this.mEnd, 0);
                this.mEnd += limit;
            } else {
                this.mIn = new Limiter(this.mIn, -1, limit);
            }
        }
        return oldLimit;
    }

    public boolean hasMore() {
        return this.mEnd - this.mPos > 0;
    }

    @Override
    public int available() throws IOException {
        return this.mIn.available();
    }

    @Override
    public int read() throws IOException {
        int chunk = this.streamChunk();
        if (chunk <= 0) {
            return -1;
        }
        int b = this.rawRead();
        if (b < 0) {
            throw new EndOfStreamException(this);
        }
        this.mStreamChunk = this.mStreamChunk & Integer.MIN_VALUE | chunk - 1;
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int chunk = this.streamChunk();
        if (chunk <= 0) {
            if (len < 0) {
                throw new IndexOutOfBoundsException();
            }
            return -1;
        }
        int amt = this.rawRead(b, off, Math.min(chunk, len));
        if (amt < 0) {
            throw new EndOfStreamException(this);
        }
        this.mStreamChunk = this.mStreamChunk & Integer.MIN_VALUE | chunk - amt;
        return amt;
    }

    @Override
    public long skip(long n) throws IOException {
        int chunk = this.streamChunk();
        if (chunk <= 0) {
            return 0L;
        }
        int amt = (int)this.rawSkip(Math.min((long)chunk, n));
        if (amt <= 0) {
            if (n > 0L) {
                throw new EndOfStreamException(this);
            }
            return 0L;
        }
        this.mStreamChunk = this.mStreamChunk & Integer.MIN_VALUE | chunk - amt;
        return amt;
    }

    public void beginStream() throws IOException {
        this.streamChunk();
    }

    public void endStream() throws IOException {
        if (this.mStreamDepth != 0 || (this.mStreamChunk & Integer.MAX_VALUE) != 0) {
            if (this.mStreamDepth < 0) {
                throw new IllegalStateException("Not in streaming mode");
            }
            throw new IllegalStateException("Not finished reading from stream");
        }
        this.mStreamDepth = -1;
    }

    private int streamChunk() throws IOException {
        block20: {
            int chunk;
            int depth = this.mStreamDepth;
            if (depth >= 0) {
                chunk = this.mStreamChunk;
            } else {
                block11: while (true) {
                    int type = this.fieldType();
                    int mode = 0;
                    switch (type >> 5) {
                        case 3: {
                            mode = Integer.MIN_VALUE;
                        }
                        case 2: {
                            depth = 0;
                            if ((type & 0x1F) == 31) {
                                depth = 1;
                            }
                            chunk = this.intFieldLength() | mode;
                            this.consumeField();
                            this.mStreamDepth = depth;
                            this.mStreamChunk = chunk;
                            break block11;
                        }
                        case 6: {
                            this.consumeField();
                            continue block11;
                        }
                        default: {
                            throw new IllegalStateException("Not a streamable string type");
                        }
                    }
                    break;
                }
            }
            int size = chunk & Integer.MAX_VALUE;
            if (size != 0 || depth == 0) {
                return size;
            }
            this.mStreamDepth = -1;
            block12: while (true) {
                int type = this.fieldType();
                switch (type >> 5) {
                    case 3: {
                        if (chunk < 0) break;
                        break block20;
                    }
                    case 2: {
                        if (chunk >= 0) break;
                        break block20;
                    }
                    case 6: {
                        this.consumeField();
                        continue block12;
                    }
                    case 7: {
                        if (type == 255) {
                            this.consumeField();
                            if (--depth != 0) continue block12;
                            this.mStreamDepth = 0;
                            return 0;
                        }
                    }
                    default: {
                        if (type == -1) {
                            throw new EndOfStreamException(this);
                        }
                        break block20;
                    }
                }
                if ((size = this.intFieldLength()) != 0) break;
                if ((type & 0x1F) == 31 && ++depth < 0) {
                    throw new CborEncodingException("Stream depth");
                }
                this.consumeField();
            }
            this.consumeField();
            this.mStreamDepth = depth;
            this.mStreamChunk = chunk & Integer.MIN_VALUE | size;
            return size;
        }
        throw new CborEncodingException("Switched stream type");
    }

    public int fieldType() throws IOException {
        return this.readRawFieldType(null);
    }

    public int readRawFieldType(OutputStream out) throws IOException {
        long field;
        int rawStartPos;
        byte[] buf;
        int pos;
        int type;
        block16: {
            block19: {
                block18: {
                    block17: {
                        type = this.mFieldType;
                        if (type >= 0) {
                            return type;
                        }
                        if (this.mStreamDepth >= 0) {
                            throw new IllegalStateException("Streaming mode");
                        }
                        pos = this.mPos;
                        int avail = this.mEnd - pos;
                        buf = this.mBuffer;
                        if (avail <= 0) {
                            avail = this.mIn.read(buf, 0, buf.length);
                            if (avail <= 0) {
                                type = -1;
                                this.mFieldType = -1;
                                return -1;
                            }
                            this.mPos = pos = 0;
                            this.mEnd = avail;
                        }
                        rawStartPos = pos;
                        type = buf[pos++] & 0xFF;
                        field = 0L;
                        switch (type & 0x1F) {
                            default: {
                                field = type & 0x1F;
                                break block16;
                            }
                            case 27: {
                                if (avail > 8) break;
                                this.mPos = pos - 1;
                                this.growBuffer(8 - avail + 1, avail);
                                rawStartPos = this.mPos;
                                pos = this.mPos + 1;
                                break;
                            }
                            case 26: {
                                if (avail <= 4) {
                                    this.mPos = pos - 1;
                                    this.growBuffer(4 - avail + 1, avail);
                                    rawStartPos = this.mPos;
                                    pos = this.mPos + 1;
                                }
                                break block17;
                            }
                            case 25: {
                                if (avail <= 2) {
                                    this.mPos = pos - 1;
                                    this.growBuffer(2 - avail + 1, avail);
                                    rawStartPos = this.mPos;
                                    pos = this.mPos + 1;
                                }
                                break block18;
                            }
                            case 24: {
                                if (avail <= 1) {
                                    this.mPos = pos - 1;
                                    this.growBuffer(1 - avail + 1, avail);
                                    rawStartPos = this.mPos;
                                    pos = this.mPos + 1;
                                }
                                break block19;
                            }
                            case 31: {
                                break block16;
                            }
                            case 28: 
                            case 29: 
                            case 30: {
                                throw new CborEncodingException("Illegal field size");
                            }
                        }
                        field = ((long)buf[pos++] & 0xFFL) << 56 | ((long)buf[pos++] & 0xFFL) << 48 | ((long)buf[pos++] & 0xFFL) << 40 | ((long)buf[pos++] & 0xFFL) << 32;
                    }
                    field = field | ((long)buf[pos++] & 0xFFL) << 24 | ((long)buf[pos++] & 0xFFL) << 16;
                }
                field |= ((long)buf[pos++] & 0xFFL) << 8;
            }
            field |= (long)buf[pos++] & 0xFFL;
        }
        if (out != null) {
            out.write(buf, rawStartPos, pos - rawStartPos);
        }
        this.mPos = pos;
        this.mFieldType = type;
        this.mFieldValue = field;
        return type;
    }

    public long getFieldValue() {
        return this.mFieldValue;
    }

    public void consumeField() {
        this.mFieldType = -1;
    }

    public int readInt() throws IOException {
        int ivalue;
        long value = this.readLong();
        if (value != (long)(ivalue = (int)value)) {
            throw new ArithmeticException(String.valueOf(value));
        }
        return ivalue;
    }

    public long readLong() throws IOException {
        int type = this.fieldType();
        block1 : switch (type >> 5) {
            case 0: {
                long value = this.mFieldValue;
                if (value < 0L) break;
                this.consumeField();
                return value;
            }
            case 1: {
                long value = this.mFieldValue ^ 0xFFFFFFFFFFFFFFFFL;
                if (value >= 0L) break;
                this.consumeField();
                return value;
            }
            case 7: {
                double doubleValue;
                switch (type & 0x1F) {
                    case 25: {
                        doubleValue = Decoder.float16to32((int)this.mFieldValue);
                        break;
                    }
                    case 26: {
                        doubleValue = Float.intBitsToFloat((int)this.mFieldValue);
                        break;
                    }
                    case 27: {
                        doubleValue = Double.longBitsToDouble(this.mFieldValue);
                        break;
                    }
                    default: {
                        break block1;
                    }
                }
                this.consumeField();
                long longValue = (long)doubleValue;
                if ((double)longValue != doubleValue) {
                    throw new ArithmeticException(String.valueOf(doubleValue));
                }
                return longValue;
            }
        }
        Object obj = this.readObject();
        try {
            if (obj instanceof BigInteger) {
                return Utils.longValueExact((BigInteger)obj);
            }
            if (obj instanceof BigDecimal) {
                return ((BigDecimal)obj).longValueExact();
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        if (obj instanceof Number) {
            throw new ArithmeticException(obj.toString());
        }
        throw new IllegalStateException("Not a number");
    }

    public double readDouble() throws IOException {
        int type = this.fieldType();
        block0 : switch (type >> 5) {
            case 0: {
                long value = this.mFieldValue;
                if (value < 0L) break;
                this.consumeField();
                return value;
            }
            case 1: {
                long value = this.mFieldValue ^ 0xFFFFFFFFFFFFFFFFL;
                if (value >= 0L) break;
                this.consumeField();
                return value;
            }
            case 7: {
                double value;
                switch (type & 0x1F) {
                    case 25: {
                        value = Decoder.float16to32((int)this.mFieldValue);
                        break;
                    }
                    case 26: {
                        value = Float.intBitsToFloat((int)this.mFieldValue);
                        break;
                    }
                    case 27: {
                        value = Double.longBitsToDouble(this.mFieldValue);
                        break;
                    }
                    default: {
                        break block0;
                    }
                }
                this.consumeField();
                return value;
            }
        }
        Object obj = this.readObject();
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        throw new IllegalStateException("Not a number");
    }

    public BigInteger readBigInteger() throws IOException {
        int type = this.fieldType();
        block2 : switch (type >> 5) {
            case 0: {
                long value = this.mFieldValue;
                if (value < 0L) break;
                this.consumeField();
                return BigInteger.valueOf(value);
            }
            case 1: {
                long value = this.mFieldValue ^ 0xFFFFFFFFFFFFFFFFL;
                if (value >= 0L) break;
                this.consumeField();
                return BigInteger.valueOf(value);
            }
            case 7: {
                double doubleValue;
                switch (type & 0x1F) {
                    case 25: {
                        doubleValue = Decoder.float16to32((int)this.mFieldValue);
                        break;
                    }
                    case 26: {
                        doubleValue = Float.intBitsToFloat((int)this.mFieldValue);
                        break;
                    }
                    case 27: {
                        doubleValue = Double.longBitsToDouble(this.mFieldValue);
                        break;
                    }
                    default: {
                        break block2;
                    }
                }
                this.consumeField();
                long longValue = (long)doubleValue;
                if ((double)longValue != doubleValue) {
                    try {
                        return BigDecimal.valueOf(doubleValue).toBigIntegerExact();
                    }
                    catch (ArithmeticException arithmeticException) {
                        throw new ArithmeticException(String.valueOf(doubleValue));
                    }
                }
                return BigInteger.valueOf(longValue);
            }
        }
        Object obj = this.readObject();
        try {
            if (obj instanceof BigInteger) {
                return (BigInteger)obj;
            }
            if (obj instanceof BigDecimal) {
                return ((BigDecimal)obj).toBigIntegerExact();
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        if (obj instanceof Number) {
            throw new ArithmeticException(obj.toString());
        }
        throw new IllegalStateException("Not a number");
    }

    public BigDecimal readBigDecimal() throws IOException {
        int type = this.fieldType();
        block0 : switch (type >> 5) {
            case 0: {
                long value = this.mFieldValue;
                if (value < 0L) break;
                this.consumeField();
                return BigDecimal.valueOf(value);
            }
            case 1: {
                long value = this.mFieldValue ^ 0xFFFFFFFFFFFFFFFFL;
                if (value >= 0L) break;
                this.consumeField();
                return BigDecimal.valueOf(value);
            }
            case 7: {
                double value;
                switch (type & 0x1F) {
                    case 25: {
                        value = Decoder.float16to32((int)this.mFieldValue);
                        break;
                    }
                    case 26: {
                        value = Float.intBitsToFloat((int)this.mFieldValue);
                        break;
                    }
                    case 27: {
                        value = Double.longBitsToDouble(this.mFieldValue);
                        break;
                    }
                    default: {
                        break block0;
                    }
                }
                this.consumeField();
                return BigDecimal.valueOf(value);
            }
        }
        Object obj = this.readObject();
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof BigInteger) {
            return new BigDecimal((BigInteger)obj, 0);
        }
        throw new IllegalStateException("Not a number");
    }

    public byte[] readStringAsBytes() throws IOException {
        block4: while (true) {
            int type = this.fieldType();
            switch (type >> 5) {
                case 2: 
                case 3: {
                    this.consumeField();
                    return this.readByteString(type);
                }
                case 6: {
                    this.consumeField();
                    continue block4;
                }
            }
            break;
        }
        throw new IllegalStateException("Not a string");
    }

    public int readBytesLength() throws IOException {
        block4: while (true) {
            int type = this.fieldType();
            switch (type >> 5) {
                case 2: {
                    int len = this.intFieldLength();
                    this.consumeField();
                    return len;
                }
                case 6: {
                    continue block4;
                }
            }
            break;
        }
        throw new IllegalStateException("Not a byte string");
    }

    public int readStringLength() throws IOException {
        block4: while (true) {
            int type = this.fieldType();
            switch (type >> 5) {
                case 3: {
                    int len = this.intFieldLength();
                    this.consumeField();
                    return len;
                }
                case 6: {
                    continue block4;
                }
            }
            break;
        }
        throw new IllegalStateException("Not a UTF-8 string");
    }

    public int readArrayLength() throws IOException {
        block4: while (true) {
            int type = this.fieldType();
            switch (type >> 5) {
                case 4: {
                    int len = this.intFieldLength();
                    this.consumeField();
                    return len;
                }
                case 6: {
                    continue block4;
                }
            }
            break;
        }
        throw new IllegalStateException("Not an array");
    }

    public int readMapLength() throws IOException {
        block4: while (true) {
            int type = this.fieldType();
            switch (type >> 5) {
                case 5: {
                    int len = this.intFieldLength();
                    this.consumeField();
                    return len;
                }
                case 6: {
                    continue block4;
                }
            }
            break;
        }
        throw new IllegalStateException("Not a map");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object readObject() throws IOException {
        int type;
        block36: while (true) {
            type = this.fieldType();
            this.consumeField();
            switch (type >> 5) {
                case 0: {
                    long value = this.mFieldValue;
                    if ((value & Integer.MIN_VALUE) == 0L) {
                        return (int)value;
                    }
                    if (value >= 0L) {
                        return value;
                    }
                    byte[] temp = new byte[9];
                    Utils.encodeLongBE(temp, 1, value);
                    return new BigInteger(temp);
                }
                case 1: {
                    long value = this.mFieldValue ^ 0xFFFFFFFFFFFFFFFFL;
                    if ((value & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                        return (int)value;
                    }
                    if (value < 0L) {
                        return value;
                    }
                    byte[] temp = new byte[9];
                    temp[0] = -1;
                    Utils.encodeLongBE(temp, 1, value);
                    return new BigInteger(temp);
                }
                case 2: {
                    return this.readByteString(type);
                }
                case 3: {
                    byte[] buf;
                    if ((type & 0x1F) == 31) {
                        this.mStreamDepth = 1;
                        this.mStreamChunk = Integer.MIN_VALUE;
                        int chunk = this.streamChunk();
                        if (chunk <= 0) {
                            this.mStreamDepth = -1;
                            return "";
                        }
                        this.checkArrayLimit(chunk);
                        byte[] buf2 = new byte[chunk];
                        int len = chunk;
                        char[] dst = new char[chunk];
                        int dstOffset = 0;
                        while (true) {
                            int n = 0;
                            int n2 = 0;
                            while (len > 0) {
                                int amt = this.rawRead(buf2, n2, len);
                                if (amt <= 0) {
                                    throw new EndOfStreamException(this);
                                }
                                n += amt;
                                len -= amt;
                                n2 += amt;
                            }
                            this.mStreamChunk = this.mStreamChunk & Integer.MIN_VALUE | chunk - n;
                            int requireLen = dstOffset + n;
                            if (requireLen >= dst.length) {
                                int newDstLen = Math.max(requireLen, dst.length << 1);
                                dst = Arrays.copyOf(dst, newDstLen);
                            }
                            dstOffset = Decoder.decodeUtf8(buf2, 0, n, dst, dstOffset);
                            chunk = this.streamChunk();
                            if (chunk <= 0) break;
                            this.checkArrayLimit(chunk);
                            len = chunk;
                            if (len <= buf2.length) continue;
                            buf2 = new byte[len];
                        }
                        this.mStreamDepth = -1;
                        return new String(dst, 0, dstOffset);
                    }
                    int len = this.intFieldLength();
                    if (len > (buf = this.mBuffer).length) return Decoder.decodeUtf8(this.readByteArray(len));
                    this.ensureBufferHas(len);
                    String str = Decoder.decodeUtf8(buf, this.mPos, len);
                    this.mPos += len;
                    return str;
                }
                case 4: {
                    if ((type & 0x1F) == 31) {
                        type = this.fieldType();
                        if (type == 255) {
                            this.consumeField();
                            return Collections.emptyList();
                        }
                        ArrayList<Object> list = new ArrayList<Object>();
                        do {
                            list.add(this.readObject());
                        } while (this.fieldType() != 255);
                        this.consumeField();
                        return list;
                    }
                    int len = this.intFieldLength();
                    this.checkArrayLimit(len);
                    Object[] array = new Object[len];
                    int i = 0;
                    while (i < len) {
                        array[i] = this.readObject();
                        ++i;
                    }
                    return Arrays.asList(array);
                }
                case 5: {
                    if ((type & 0x1F) == 31) {
                        type = this.fieldType();
                        if (type == 255) {
                            this.consumeField();
                            return Collections.emptyMap();
                        }
                        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                        do {
                            map.put(this.readObject(), this.readObject());
                        } while (this.fieldType() != 255);
                        this.consumeField();
                        return map;
                    }
                    int len = this.intFieldLength();
                    LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                    int i = 0;
                    while (i < len) {
                        map.put(this.readObject(), this.readObject());
                        ++i;
                    }
                    return map;
                }
                case 6: {
                    long tag = this.mFieldValue;
                    int itag = (int)tag;
                    if ((long)itag != tag) continue block36;
                    switch (itag) {
                        case 0: {
                            Object datetime = this.readObject();
                            if (!(datetime instanceof CharSequence)) return datetime;
                            CharSequence str = (CharSequence)datetime;
                            try {
                                return CborInputStream.toZonedDateTime(str);
                            }
                            catch (Exception exception) {
                                try {
                                    return CborInputStream.toLocalDateTime(str);
                                }
                                catch (Exception exception2) {
                                    // empty catch block
                                }
                            }
                            return datetime;
                        }
                        case 1: {
                            type = this.fieldType();
                            if (type >= 249 && type <= 251) {
                                double timestamp = this.readDouble();
                                try {
                                    return CborInputStream.toInstant(timestamp);
                                }
                                catch (Exception exception) {
                                    return timestamp;
                                }
                            }
                            long value = this.mFieldValue;
                            if ((type >>= 5) == 0 && value >= 0L || type == 32 && (value ^= 0xFFFFFFFFFFFFFFFFL) < 0L) {
                                this.consumeField();
                                try {
                                    return CborInputStream.toInstant(value);
                                }
                                catch (Exception exception) {
                                    return value;
                                }
                            }
                            Object object = this.readObject();
                            try {
                                if (object instanceof BigDecimal) {
                                    return CborInputStream.toInstant((BigDecimal)object);
                                }
                                if (!(object instanceof BigInteger)) return object;
                                return CborInputStream.toInstant((BigInteger)object);
                            }
                            catch (Exception requireLen) {
                                // empty catch block
                            }
                            return object;
                        }
                        case 2: {
                            return new BigInteger(this.readBytesForBigInteger());
                        }
                        case 3: {
                            void var9_25;
                            byte[] bytes = this.readBytesForBigInteger();
                            boolean bl = false;
                            while (var9_25 < bytes.length) {
                                void v0 = var9_25++;
                                bytes[v0] = ~bytes[v0];
                            }
                            return new BigInteger(bytes);
                        }
                        case 4: {
                            void var9_28;
                            Object pair = this.readObject();
                            if (pair instanceof List) {
                                List list = (List)pair;
                                if (list.size() != 2) throw new CborEncodingException("Malformed decimal");
                                Object e = list.get(0);
                                Object e2 = list.get(1);
                            } else {
                                if (!(pair instanceof Object[])) throw new CborEncodingException("Malformed decimal");
                                Object[] array = (Object[])pair;
                                if (array.length != 2) throw new CborEncodingException("Malformed decimal");
                                Object object = array[0];
                                Object object2 = array[1];
                            }
                            int intExp = CborInputStream.integerExponent(var9_28);
                            if (intExp != Integer.MIN_VALUE) void var10_39;
                            return new BigDecimal(CborInputStream.bigIntegerSignificand(var10_39), -intExp);
                            throw new CborEncodingException("Exponent too large");
                        }
                        case 5: {
                            void var10_42;
                            void var9_31;
                            Object pair = this.readObject();
                            if (pair instanceof List) {
                                List list = (List)pair;
                                if (list.size() != 2) throw new CborEncodingException("Malformed decimal");
                                Object e = list.get(0);
                                Object e3 = list.get(1);
                            } else {
                                if (!(pair instanceof Object[])) throw new CborEncodingException("Malformed decimal");
                                Object[] array = (Object[])pair;
                                if (array.length != 2) throw new CborEncodingException("Malformed decimal");
                                Object object = array[0];
                                Object object3 = array[1];
                            }
                            int intExp = CborInputStream.integerExponent(var9_31);
                            BigDecimal bd = new BigDecimal(CborInputStream.bigIntegerSignificand(var10_42));
                            if (intExp == 0) return bd;
                            return bd.multiply(Decoder.DECIMAL_TWO.pow(intExp));
                        }
                    }
                    continue block36;
                }
            }
            break;
        }
        switch (type & 0x1F) {
            case 20: {
                return Boolean.FALSE;
            }
            case 21: {
                return Boolean.TRUE;
            }
            case 22: {
                return null;
            }
            case 25: {
                return Float.valueOf(Decoder.float16to32((int)this.mFieldValue));
            }
            case 26: {
                return Float.valueOf(Float.intBitsToFloat((int)this.mFieldValue));
            }
            case 27: {
                return Double.longBitsToDouble(this.mFieldValue);
            }
            case 31: {
                throw new EndOfStreamException(this);
            }
        }
        throw new CborEncodingException("Unsupported simple type: " + Utils.intToUnsignedString(type));
    }

    private byte[] readByteString(int type) throws IOException {
        if ((type & 0x1F) == 31) {
            type = this.fieldType();
            if (type == 255) {
                this.consumeField();
                return EMPTY_BYTES;
            }
            ArrayList<byte[]> chunks = new ArrayList<byte[]>();
            int totalSize = 0;
            do {
                Object obj;
                if (!((obj = this.readObject()) instanceof byte[])) {
                    throw new CborEncodingException("Expected byte array chunk");
                }
                byte[] chunk = (byte[])obj;
                if ((totalSize += chunk.length) < 0) {
                    throw new CborEncodingException("Byte array length is too long");
                }
                chunks.add(chunk);
            } while (this.fieldType() != 255);
            this.consumeField();
            byte[] full = new byte[totalSize];
            int offset = 0;
            for (int i = 0; i < chunks.size(); ++i) {
                byte[] chunk = (byte[])chunks.get(i);
                System.arraycopy(chunk, 0, full, offset, chunk.length);
                offset += chunk.length;
            }
            return full;
        }
        return this.readByteArray(this.intFieldLength());
    }

    private byte[] readByteArray(int len) throws IOException {
        this.checkArrayLimit(len);
        if (len == 0) {
            return EMPTY_BYTES;
        }
        byte[] bytes = new byte[len];
        int off = 0;
        while (len > 0) {
            int amt = this.rawRead(bytes, off, len);
            if (amt <= 0) {
                throw new EndOfStreamException(this);
            }
            off += amt;
            len -= amt;
        }
        return bytes;
    }

    private void checkArrayLimit(int len) throws EndOfStreamException {
        if (len > this.mLimit && len > this.mLimit + this.mEnd - this.mPos) {
            throw new EndOfStreamException(this);
        }
    }

    public void skipObject() throws IOException {
        int type;
        block7: while (true) {
            type = this.fieldType();
            this.consumeField();
            switch (type >> 5) {
                case 0: 
                case 1: {
                    return;
                }
                case 2: 
                case 3: {
                    if ((type & 0x1F) == 31) {
                        while (this.fieldType() != 255) {
                            this.skipObject();
                        }
                        this.consumeField();
                    } else {
                        this.rawSkipFully(this.longFieldLength());
                    }
                    return;
                }
                case 4: {
                    if ((type & 0x1F) == 31) {
                        while (this.fieldType() != 255) {
                            this.skipObject();
                        }
                        this.consumeField();
                    } else {
                        long len = this.longFieldLength();
                        while (--len >= 0L) {
                            this.skipObject();
                        }
                    }
                    return;
                }
                case 5: {
                    if ((type & 0x1F) == 31) {
                        while (this.fieldType() != 255) {
                            this.skipObject();
                            this.skipObject();
                        }
                        this.consumeField();
                    } else {
                        long len = this.longFieldLength();
                        while (--len >= 0L) {
                            this.skipObject();
                            this.skipObject();
                        }
                    }
                    return;
                }
                case 6: {
                    continue block7;
                }
            }
            break;
        }
        if ((type & 0x1F) == 31) {
            throw new EndOfStreamException(this);
        }
    }

    public void readRawObject(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("OutputStream, out, can't be null");
        }
        int type = this.readRawFieldType(out);
        this.consumeField();
        switch (type >> 5) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                int amt;
                int len;
                if ((type & 0x1F) == 31) {
                    while (this.readRawFieldType(out) != 255) {
                        this.readRawObject(out);
                    }
                    this.consumeField();
                    break;
                }
                this.checkArrayLimit(len);
                int avail = this.mEnd - this.mPos;
                if (len <= avail) {
                    out.write(this.mBuffer, this.mPos, len);
                    this.mPos += len;
                    break;
                }
                byte[] buf = new byte[len];
                int off = 0;
                for (len = this.intFieldLength(); len > 0; len -= amt) {
                    amt = this.rawRead(buf, off, len);
                    if (amt <= 0) {
                        throw new EndOfStreamException(this);
                    }
                    off += amt;
                }
                out.write(buf);
                break;
            }
            case 4: {
                if ((type & 0x1F) == 31) {
                    while (this.readRawFieldType(out) != 255) {
                        this.readRawObject(out);
                    }
                    this.consumeField();
                    break;
                }
                long len = this.longFieldLength();
                while (--len >= 0L) {
                    this.readRawObject(out);
                }
                break;
            }
            case 5: {
                if ((type & 0x1F) == 31) {
                    while (this.readRawFieldType(out) != 255) {
                        this.readRawObject(out);
                        this.readRawObject(out);
                    }
                    this.consumeField();
                    break;
                }
                long len = this.longFieldLength();
                while (--len >= 0L) {
                    this.readRawObject(out);
                    this.readRawObject(out);
                }
                break;
            }
            case 6: {
                this.readRawObject(out);
                break;
            }
            default: {
                if ((type & 0x1F) != 31) break;
                throw new EndOfStreamException(this);
            }
        }
    }

    protected int intFieldLength() throws CborEncodingException {
        long len = this.mFieldValue;
        if ((len & Integer.MIN_VALUE) != 0L) {
            throw new CborEncodingException("Length is too long: " + Utils.longToUnsignedString(len));
        }
        return (int)len;
    }

    private long longFieldLength() throws CborEncodingException {
        long len = this.mFieldValue;
        if (len < 0L) {
            throw new CborEncodingException("Length is too long: " + Utils.longToUnsignedString(len));
        }
        return len;
    }

    private byte[] readBytesForBigInteger() throws IOException, CborEncodingException {
        Object obj = this.readObject();
        if (!(obj instanceof byte[])) {
            throw new CborEncodingException("Malformed numeric encoding");
        }
        byte[] bytes = (byte[])obj;
        if (bytes[0] < 0) {
            byte[] copy = new byte[1 + bytes.length];
            System.arraycopy(bytes, 0, copy, 1, bytes.length);
            bytes = copy;
        }
        return bytes;
    }

    private static int integerExponent(Object exponent) throws CborEncodingException {
        int intExp;
        BigInteger exp;
        if (exponent instanceof Integer) {
            return (Integer)exponent;
        }
        if (exponent instanceof Long) {
            long exp2 = (Long)exponent;
            int intExp2 = (int)exp2;
            if ((long)intExp2 != exp2) {
                throw new CborEncodingException("Exponent too large");
            }
            return intExp2;
        }
        if (exponent instanceof BigInteger && !(exp = (BigInteger)exponent).equals(intExp = exp.intValue())) {
            throw new CborEncodingException("Exponent too large");
        }
        throw new CborEncodingException("Malformed exponent");
    }

    private static BigInteger bigIntegerSignificand(Object significand) throws CborEncodingException {
        if (significand instanceof Integer) {
            return BigInteger.valueOf(((Integer)significand).intValue());
        }
        if (significand instanceof Long) {
            return BigInteger.valueOf((Long)significand);
        }
        if (significand instanceof BigInteger) {
            return (BigInteger)significand;
        }
        throw new CborEncodingException("Malformed significand");
    }

    private static Object toZonedDateTime(CharSequence str) {
        try {
            return cToZonedDateTime.invoke(str);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static Object toLocalDateTime(CharSequence str) {
        try {
            return cToLocalDateTime.invoke(str);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static Object toInstant(long timestamp) {
        try {
            return cToInstantFromLong.invoke(timestamp);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static Object toInstant(long seconds, long nanos) {
        try {
            return cToInstantFromSecondsNanos.invoke(seconds, nanos);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static Object toInstant(double timestamp) {
        try {
            return cToInstantFromDouble.invoke(timestamp);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static Object do_toInstant(double timestamp) {
        return CborInputStream.toInstant(BigDecimal.valueOf(timestamp));
    }

    private static Object toInstant(BigInteger timestamp) {
        try {
            return cToInstantFromBigInteger.invoke(timestamp);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static Object do_toInstant(BigInteger timestamp) {
        return CborInputStream.toInstant(Utils.longValueExact(timestamp));
    }

    private static Object toInstant(BigDecimal timestamp) {
        try {
            return cToInstantFromBigDecimal.invoke(timestamp);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static Object do_toInstant(BigDecimal timestamp) {
        BigInteger tsSeconds = timestamp.toBigInteger();
        long seconds = Utils.longValueExact(tsSeconds);
        BigDecimal tsRem = timestamp.subtract(new BigDecimal(tsSeconds));
        BigDecimal tsNanos = tsRem.movePointRight(9);
        long nanos = tsNanos.longValueExact();
        return CborInputStream.toInstant(seconds, nanos);
    }

    @Override
    public void close() throws IOException {
        this.mEnd = this.mPos;
        this.mIn.close();
    }

    private int rawRead() throws IOException {
        int pos = this.mPos;
        int avail = this.mEnd - pos;
        byte[] buf = this.mBuffer;
        if (avail <= 0) {
            avail = this.mIn.read(buf, 0, buf.length);
            if (avail <= 0) {
                return -1;
            }
            pos = 0;
            this.mEnd = avail;
        }
        int b = buf[pos++] & 0xFF;
        this.mPos = pos;
        return b;
    }

    private int rawRead(byte[] b, int off, int len) throws IOException {
        int avail = this.mEnd - this.mPos;
        byte[] buf = this.mBuffer;
        if (avail <= 0) {
            if (len >= buf.length) {
                return this.mIn.read(b, off, len);
            }
            avail = this.mIn.read(buf, 0, buf.length);
            if (avail <= 0) {
                return -1;
            }
            this.mPos = 0;
            this.mEnd = avail;
        }
        len = Math.min(avail, len);
        System.arraycopy(buf, this.mPos, b, off, len);
        this.mPos += len;
        return len;
    }

    public long rawSkip(long n) throws IOException {
        int avail = this.mEnd - this.mPos;
        if (avail > 0) {
            if (n >= (long)avail) {
                this.mPos = 0;
                this.mEnd = 0;
                return avail;
            }
            this.mPos = (int)((long)this.mPos + n);
            return n;
        }
        return this.mIn.skip(n);
    }

    public void rawSkipFully(long n) throws IOException {
        while (n > 0L) {
            long amt = this.rawSkip(n);
            if (amt <= 0L) {
                throw new EndOfStreamException(this);
            }
            n -= amt;
        }
    }

    private void ensureBufferHas(int required) throws IOException, EndOfStreamException {
        int avail = this.mEnd - this.mPos;
        if ((required -= avail) > 0) {
            this.growBuffer(required, avail);
        }
    }

    private void growBuffer(int required, int avail) throws IOException, EndOfStreamException {
        byte[] buf = this.mBuffer;
        int end = this.mEnd;
        int tail = buf.length - end;
        if (tail < required) {
            System.arraycopy(buf, this.mPos, buf, 0, avail);
            this.mPos = 0;
            this.mEnd = end = avail;
            tail = buf.length - end;
        }
        while (true) {
            if ((avail = this.mIn.read(buf, end, tail)) <= 0) {
                throw new EndOfStreamException(this);
            }
            this.mEnd = end += avail;
            if ((required -= avail) <= 0) break;
            tail -= avail;
        }
    }

    static {
        MethodHandle toInstantFromBigDecimal;
        MethodHandle toInstantFromBigInteger;
        MethodHandle toInstantFromDouble;
        MethodHandle toInstantFromSecondsNanos;
        MethodHandle toInstantFromLong;
        MethodHandle toLocalDateTime;
        MethodHandle toZonedDateTime;
        try {
            Class<?> c = Class.forName("java.time.ZonedDateTime");
            Method m = c.getMethod("parse", CharSequence.class);
            toZonedDateTime = MethodHandles.lookup().unreflect(m);
            c = Class.forName("java.time.LocalDateTime");
            m = c.getMethod("parse", CharSequence.class);
            toLocalDateTime = MethodHandles.lookup().unreflect(m);
            c = Class.forName("java.time.Instant");
            m = c.getMethod("ofEpochSecond", Long.TYPE);
            toInstantFromLong = MethodHandles.lookup().unreflect(m);
            c = Class.forName("java.time.Instant");
            m = c.getMethod("ofEpochSecond", Long.TYPE);
            toInstantFromLong = MethodHandles.lookup().unreflect(m);
            m = c.getMethod("ofEpochSecond", Long.TYPE, Long.TYPE);
            toInstantFromSecondsNanos = MethodHandles.lookup().unreflect(m);
            MethodType type = MethodType.methodType(Object.class, Double.TYPE);
            toInstantFromDouble = MethodHandles.lookup().findStatic(CborInputStream.class, "do_toInstant", type);
            type = MethodType.methodType(Object.class, BigInteger.class);
            toInstantFromBigInteger = MethodHandles.lookup().findStatic(CborInputStream.class, "do_toInstant", type);
            type = MethodType.methodType(Object.class, BigDecimal.class);
            toInstantFromBigDecimal = MethodHandles.lookup().findStatic(CborInputStream.class, "do_toInstant", type);
        }
        catch (Exception e) {
            toZonedDateTime = MethodHandles.identity(Object.class);
            toLocalDateTime = MethodHandles.identity(Object.class);
            toInstantFromLong = MethodHandles.identity(Object.class);
            toInstantFromSecondsNanos = MethodHandles.throwException(Object.class, UnsupportedOperationException.class);
            toInstantFromDouble = MethodHandles.identity(Object.class);
            toInstantFromBigInteger = MethodHandles.identity(Object.class);
            toInstantFromBigDecimal = MethodHandles.identity(Object.class);
        }
        cToZonedDateTime = toZonedDateTime;
        cToLocalDateTime = toLocalDateTime;
        cToInstantFromLong = toInstantFromLong;
        cToInstantFromSecondsNanos = toInstantFromSecondsNanos;
        cToInstantFromDouble = toInstantFromDouble;
        cToInstantFromBigInteger = toInstantFromBigInteger;
        cToInstantFromBigDecimal = toInstantFromBigDecimal;
        EMPTY_BYTES = new byte[0];
    }

    private class Limiter
    extends InputStream {
        final InputStream mSource;
        final int mBufEndPos;

        Limiter(InputStream source, int bufEndPos, int limit) {
            if (limit < 0) {
                throw new IllegalArgumentException();
            }
            this.mSource = source;
            this.mBufEndPos = bufEndPos;
            CborInputStream.this.mLimit = limit;
        }

        @Override
        public int read() throws IOException {
            if (CborInputStream.this.mLimit <= 0) {
                return -1;
            }
            int b = this.mSource.read();
            CborInputStream.this.mLimit--;
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int avail = Math.min(len, CborInputStream.this.mLimit);
            if (avail <= 0) {
                return len == 0 ? 0 : -1;
            }
            int amt = this.mSource.read(b, off, avail);
            if (amt > 0) {
                CborInputStream.this.mLimit -= amt;
            }
            return amt;
        }

        @Override
        public long skip(long n) throws IOException {
            long avail = Math.min(n, (long)CborInputStream.this.mLimit);
            if (avail <= 0L) {
                return 0L;
            }
            long amt = this.mSource.skip(avail);
            if (amt > 0L) {
                CborInputStream.this.mLimit = (int)((long)CborInputStream.this.mLimit - amt);
            }
            return amt;
        }

        @Override
        public int available() throws IOException {
            return Math.min(CborInputStream.this.mLimit, this.mSource.available());
        }

        @Override
        public void close() throws IOException {
            CborInputStream.this.mLimit = 0;
            this.mSource.close();
        }
    }
}

