/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.cbor;

import com.amazon.cbor.Encoder;
import com.amazon.cbor.Utils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SegmentPool {
    private static final ConcurrentMap<Integer, SegmentPool> cPools = new ConcurrentHashMap<Integer, SegmentPool>();
    private final ThreadLocal<Segment> mHeadSegment = new ThreadLocal();
    private final int mCapacity;

    public static SegmentPool withCapacity(int capacity) {
        SegmentPool pool = (SegmentPool)cPools.get(capacity);
        if (pool == null) {
            pool = new SegmentPool(capacity);
            SegmentPool existing = cPools.putIfAbsent(capacity, pool);
            if (existing != null) {
                pool = existing;
            }
        }
        return pool;
    }

    public SegmentPool(int capacity) {
        this.mCapacity = capacity;
    }

    public int segmentCapacity() {
        return this.mCapacity;
    }

    public Segment alloc() {
        Segment segment = this.mHeadSegment.get();
        if (segment == null) {
            segment = new Segment(this.mCapacity);
        } else {
            this.mHeadSegment.set(segment.mNext);
            segment.mNext = null;
            segment.mEnd = 0;
        }
        return segment;
    }

    public Segment chainAlloc(Segment tailSegment) {
        Segment nextSegment;
        if (tailSegment.mNext != null) {
            throw new IllegalStateException("Cannot append to non-tail segment.");
        }
        tailSegment.mNext = nextSegment = this.alloc();
        return nextSegment;
    }

    public void recycle(Segment segment) {
        if (segment != null) {
            segment.mNext = this.mHeadSegment.get();
            this.mHeadSegment.set(segment);
        }
    }

    public void chainRecycle(Segment segment) {
        if (segment != null) {
            Segment head = this.mHeadSegment.get();
            while (true) {
                Segment next = segment.mNext;
                segment.mNext = head;
                if (next == null) {
                    this.mHeadSegment.set(segment);
                    break;
                }
                head = segment;
                segment = next;
            }
        }
    }

    public void chainTrim(Segment segment) {
        this.chainRecycle(segment.mNext);
        segment.mEnd = 0;
        segment.mNext = null;
    }

    public static int chainSize(Segment segment) {
        int totalBytesUsed = 0;
        while (segment != null) {
            totalBytesUsed += segment.mEnd;
            segment = segment.mNext;
        }
        return totalBytesUsed;
    }

    public static int chainSize(Segment start, int startOffset, Segment end, int endOffset) {
        int totalBytesUsed = 0;
        while (start != end) {
            totalBytesUsed += start.mEnd - startOffset;
            startOffset = 0;
            start = start.mNext;
        }
        return totalBytesUsed += endOffset - startOffset;
    }

    public static void chainCopy(Segment segment, int offset, byte[] dst, int dstOffset) {
        int len = segment.mEnd - offset;
        System.arraycopy(segment.mBytes, offset, dst, dstOffset, len);
        dstOffset += len;
        while ((segment = segment.mNext) != null) {
            len = segment.mEnd;
            System.arraycopy(segment.mBytes, 0, dst, dstOffset, len);
            dstOffset += len;
        }
    }

    public static int chainCopy(Segment start, int startOffset, Segment end, int endOffset, byte[] dst, int dstOffset) {
        int len;
        Segment pos = start;
        int offset = startOffset;
        int currentDstOffset = dstOffset;
        while (pos != end) {
            len = pos.mEnd - offset;
            System.arraycopy(pos.mBytes, offset, dst, currentDstOffset, len);
            currentDstOffset += len;
            offset = 0;
            pos = pos.mNext;
        }
        len = endOffset - offset;
        System.arraycopy(pos.mBytes, offset, dst, currentDstOffset, len);
        return (currentDstOffset += len) - dstOffset;
    }

    public static byte[] chainCopy(Segment segment, int offset) {
        byte[] array = new byte[SegmentPool.chainSize(segment) - offset];
        SegmentPool.chainCopy(segment, offset, array, 0);
        return array;
    }

    public byte[] chainCopyAndTrim(Segment segment, int offset) {
        byte[] array = SegmentPool.chainCopy(segment, offset);
        this.chainTrim(segment);
        return array;
    }

    public byte[] chainCopyAndRecycle(Segment segment, int offset) {
        byte[] array = SegmentPool.chainCopy(segment, offset);
        this.chainRecycle(segment);
        return array;
    }

    public Segment chainAppend(Segment segment, byte data) {
        byte[] dst = segment.mBytes;
        int dstOffset = segment.mEnd;
        int avail = dst.length - dstOffset;
        if (avail <= 0) {
            segment = this.chainAlloc(segment);
            dst = segment.mBytes;
            dstOffset = 0;
        }
        dst[dstOffset] = data;
        segment.mEnd = dstOffset + 1;
        return segment;
    }

    public Segment chainAppend(Segment segment, byte[] data) {
        return this.chainAppend(segment, data, 0, data.length);
    }

    public Segment chainAppend(Segment segment, byte[] data, int offset, int length) {
        if (length > 0) {
            byte[] dst = segment.mBytes;
            int dstOffset = segment.mEnd;
            int avail = dst.length - dstOffset;
            if (avail <= 0) {
                segment = this.chainAlloc(segment);
                dst = segment.mBytes;
                dstOffset = 0;
                avail = dst.length;
            }
            while (true) {
                if (avail >= length) {
                    System.arraycopy(data, offset, dst, dstOffset, length);
                    segment.mEnd = dstOffset + length;
                    return segment;
                }
                System.arraycopy(data, offset, dst, dstOffset, avail);
                segment.mEnd = dstOffset + avail;
                offset += avail;
                length -= avail;
                segment = this.chainAlloc(segment);
                dst = segment.mBytes;
                dstOffset = 0;
                avail = dst.length;
            }
        }
        return segment;
    }

    public Segment chainAppend(Segment segment, ByteBuffer data) {
        if (data.hasArray()) {
            return this.chainAppend(segment, data.array(), data.arrayOffset() + data.position(), data.remaining());
        }
        int pos = data.position();
        data.position(0);
        data.get(segment.mBytes, segment.mEnd, this.mCapacity - segment.mEnd);
        while (data.hasRemaining()) {
            segment = this.chainAlloc(segment);
            int toCopy = data.remaining() > this.mCapacity ? this.mCapacity : data.remaining();
            data.get(segment.mBytes, segment.mEnd, toCopy);
            segment.mEnd += toCopy;
        }
        data.position(pos);
        return segment;
    }

    public Segment chainAppendFlip(Segment segment, byte[] data, int offset, int length) {
        if (length > 0) {
            byte[] dst = segment.mBytes;
            int dstOffset = segment.mEnd;
            int avail = dst.length - dstOffset;
            if (avail <= 0) {
                segment = this.chainAlloc(segment);
                dst = segment.mBytes;
                dstOffset = 0;
                avail = dst.length;
            }
            while (true) {
                if (avail >= length) {
                    SegmentPool.flipcopy(data, offset, dst, dstOffset, length);
                    segment.mEnd = dstOffset + length;
                    return segment;
                }
                SegmentPool.flipcopy(data, offset, dst, dstOffset, avail);
                segment.mEnd = dstOffset + avail;
                offset += avail;
                length -= avail;
                segment = this.chainAlloc(segment);
                dst = segment.mBytes;
                dstOffset = 0;
                avail = dst.length;
            }
        }
        return segment;
    }

    private static void flipcopy(byte[] src, int srcOffset, byte[] dst, int dstOffset, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOffset + i] = ~src[srcOffset + i];
        }
    }

    public Segment chainAppendTransform(Segment segment, byte[] data, int offset, int length, int add, int xor) {
        if (length > 0) {
            byte[] dst = segment.mBytes;
            int dstOffset = segment.mEnd;
            int avail = dst.length - dstOffset;
            if (avail <= 0) {
                segment = this.chainAlloc(segment);
                dst = segment.mBytes;
                dstOffset = 0;
                avail = dst.length;
            }
            while (true) {
                if (avail >= length) {
                    SegmentPool.txcopy(data, offset, dst, dstOffset, length, add, xor);
                    segment.mEnd = dstOffset + length;
                    return segment;
                }
                SegmentPool.txcopy(data, offset, dst, dstOffset, avail, add, xor);
                segment.mEnd = dstOffset + avail;
                offset += avail;
                length -= avail;
                segment = this.chainAlloc(segment);
                dst = segment.mBytes;
                dstOffset = 0;
                avail = dst.length;
            }
        }
        return segment;
    }

    private static void txcopy(byte[] src, int srcOffset, byte[] dst, int dstOffset, int len, int add, int xor) {
        for (int i = 0; i < len; ++i) {
            dst[dstOffset + i] = (byte)(src[srcOffset + i] + add ^ xor);
        }
    }

    public Segment chainAppendUtf8(Segment segment, String str) {
        return this.chainAppend(segment, Encoder.encodeUtf8(str));
    }

    public Segment chainRequire(Segment segment, int length) {
        if (segment.mBytes.length - segment.mEnd < length) {
            segment = this.chainAlloc(segment);
        }
        return segment;
    }

    public Segment chainAppendCborTypePrefix(Segment segment, int type, long value) {
        if (value < 24L) {
            segment = this.chainAppend(segment, (byte)((long)type + value));
        } else {
            int end;
            byte[] bytes;
            if (value < 256L) {
                segment = this.chainRequire(segment, 2);
                bytes = segment.mBytes;
                end = segment.mEnd;
                bytes[end++] = (byte)(type + 24);
            } else {
                if (value < 65536L) {
                    segment = this.chainRequire(segment, 3);
                    bytes = segment.mBytes;
                    end = segment.mEnd;
                    bytes[end++] = (byte)(type + 25);
                } else {
                    if (value < 0x100000000L) {
                        segment = this.chainRequire(segment, 5);
                        bytes = segment.mBytes;
                        end = segment.mEnd;
                        bytes[end++] = (byte)(type + 26);
                    } else {
                        segment = this.chainRequire(segment, 9);
                        bytes = segment.mBytes;
                        end = segment.mEnd;
                        bytes[end++] = (byte)(type + 27);
                        bytes[end++] = (byte)(value >> 56);
                        bytes[end++] = (byte)(value >> 48);
                        bytes[end++] = (byte)(value >> 40);
                        bytes[end++] = (byte)(value >> 32);
                    }
                    bytes[end++] = (byte)(value >> 24);
                    bytes[end++] = (byte)(value >> 16);
                }
                bytes[end++] = (byte)(value >> 8);
            }
            bytes[end++] = (byte)value;
            segment.mEnd = end;
        }
        return segment;
    }

    public Segment chainAppendCborBytesPrefix(Segment segment, int length) {
        return this.chainAppendCborTypePrefix(segment, 64, length);
    }

    public Segment chainAppendCborBytesStreamPrefix(Segment segment) {
        return this.chainAppend(segment, (byte)95);
    }

    public Segment chainAppendCborStringPrefix(Segment segment, int length) {
        return this.chainAppendCborTypePrefix(segment, 96, length);
    }

    public Segment chainAppendCborStringStreamPrefix(Segment segment) {
        return this.chainAppend(segment, (byte)127);
    }

    public Segment chainAppendCborArrayPrefix(Segment segment, int length) {
        return this.chainAppendCborTypePrefix(segment, 128, length);
    }

    public Segment chainAppendCborArrayStreamPrefix(Segment segment) {
        return this.chainAppend(segment, (byte)-97);
    }

    public Segment chainAppendCborMapPrefix(Segment segment, int size) {
        return this.chainAppendCborTypePrefix(segment, 160, size);
    }

    public Segment chainAppendCborMapStreamPrefix(Segment segment) {
        return this.chainAppend(segment, (byte)-65);
    }

    public Segment chainAppendCborNull(Segment segment) {
        return this.chainAppend(segment, (byte)-10);
    }

    public Segment chainAppendCborBytes(Segment segment, byte[] data) {
        return this.chainAppendCborBytes(segment, data, 0, data.length);
    }

    public Segment chainAppendCborBytes(Segment segment, byte[] data, int offset, int length) {
        segment = this.chainAppendCborTypePrefix(segment, 64, length);
        return this.chainAppend(segment, data, offset, length);
    }

    public Segment chainAppendCborBinary(Segment segment, ByteBuffer data) {
        segment = this.chainAppendCborBytesPrefix(segment, data.limit());
        return this.chainAppend(segment, data);
    }

    public Segment chainAppendCborString(Segment segment, String str) {
        if (str == null) {
            return this.chainAppend(segment, (byte)-10);
        }
        byte[] data = Encoder.encodeUtf8(str);
        segment = this.chainAppendCborTypePrefix(segment, 96, data.length);
        return this.chainAppend(segment, data, 0, data.length);
    }

    public Segment chainAppendCborNumberString(Segment segment, String number) {
        if (Encoder.isDecimal(number)) {
            return this.chainAppendCborDecimal(segment, new BigDecimal(number));
        }
        if (number.length() > 18) {
            return this.chainAppendCborInteger(segment, new BigInteger(number));
        }
        return this.chainAppendCborInteger(segment, Long.parseLong(number));
    }

    public Segment chainAppendCborPosInt8(Segment segment, int value) {
        segment = this.chainRequire(segment, 2);
        byte[] bytes = segment.mBytes;
        int end = segment.mEnd;
        bytes[end] = 24;
        bytes[++end] = (byte)value;
        segment.mEnd = end + 1;
        return segment;
    }

    public Segment chainAppendCborPosInt16(Segment segment, int value) {
        segment = this.chainRequire(segment, 3);
        byte[] bytes = segment.mBytes;
        int end = segment.mEnd;
        bytes[end] = 25;
        Utils.encodeShortBE(bytes, ++end, value);
        segment.mEnd = end + 2;
        return segment;
    }

    public Segment chainAppendCborPosInt32(Segment segment, int value) {
        segment = this.chainRequire(segment, 5);
        byte[] bytes = segment.mBytes;
        int end = segment.mEnd;
        bytes[end] = 26;
        Utils.encodeIntBE(bytes, ++end, value);
        segment.mEnd = end + 4;
        return segment;
    }

    public Segment chainAppendCborPosInt64(Segment segment, long value) {
        segment = this.chainRequire(segment, 9);
        byte[] bytes = segment.mBytes;
        int end = segment.mEnd;
        bytes[end] = 27;
        Utils.encodeLongBE(bytes, ++end, value);
        segment.mEnd = end + 8;
        return segment;
    }

    public Segment chainAppendCborInteger(Segment segment, long value) {
        long signum = value >> 63;
        return this.chainAppendCborTypePrefix(segment, 0 | (int)signum & 0x20, value ^ signum);
    }

    public Segment chainAppendCborInteger(Segment segment, BigInteger value) {
        if (value == null) {
            return this.chainAppend(segment, (byte)-10);
        }
        int bits = value.bitLength();
        int signum = value.signum() >> 1;
        if (bits <= 8) {
            int val = value.intValue() ^ signum;
            if (val < 24) {
                segment = this.chainAppend(segment, (byte)(val | signum & 0x20));
            } else {
                segment = this.chainRequire(segment, 2);
                byte[] bytes = segment.mBytes;
                int end = segment.mEnd;
                bytes[end++] = (byte)(0x18 | signum & 0x20);
                bytes[end++] = (byte)val;
                segment.mEnd = end;
            }
        } else if (bits <= 16) {
            segment = this.chainRequire(segment, 3);
            byte[] bytes = segment.mBytes;
            int end = segment.mEnd;
            bytes[end++] = (byte)(0x19 | signum & 0x20);
            Utils.encodeShortBE(bytes, end, value.intValue() ^ signum);
            segment.mEnd = end + 2;
        } else if (bits <= 32) {
            segment = this.chainRequire(segment, 5);
            byte[] bytes = segment.mBytes;
            int end = segment.mEnd;
            bytes[end++] = (byte)(0x1A | signum & 0x20);
            Utils.encodeIntBE(bytes, end, value.intValue() ^ signum);
            segment.mEnd = end + 4;
        } else if (bits <= 64) {
            segment = this.chainRequire(segment, 9);
            byte[] bytes = segment.mBytes;
            int end = segment.mEnd;
            bytes[end++] = (byte)(0x1B | signum & 0x20);
            Utils.encodeLongBE(bytes, end, value.longValue() ^ (long)signum);
            segment.mEnd = end + 8;
        } else {
            int end;
            byte[] valueBytes = value.toByteArray();
            int valueLen = valueBytes.length;
            byte header = (byte)(194 + (signum & 1));
            if (valueLen < 24) {
                segment = this.chainRequire(segment, 2);
                byte[] bytes = segment.mBytes;
                end = segment.mEnd;
                bytes[end++] = header;
                bytes[end++] = (byte)(64 + valueLen);
            } else if (valueLen < 256) {
                segment = this.chainRequire(segment, 3);
                byte[] bytes = segment.mBytes;
                end = segment.mEnd;
                bytes[end++] = header;
                bytes[end++] = 88;
                bytes[end++] = (byte)valueLen;
            } else if (valueLen < 65536) {
                segment = this.chainRequire(segment, 4);
                byte[] bytes = segment.mBytes;
                end = segment.mEnd;
                bytes[end++] = header;
                bytes[end++] = 89;
                Utils.encodeShortBE(bytes, end, valueLen);
                end += 2;
            } else {
                segment = this.chainRequire(segment, 6);
                byte[] bytes = segment.mBytes;
                end = segment.mEnd;
                bytes[end++] = header;
                bytes[end++] = 90;
                Utils.encodeIntBE(bytes, end, valueLen);
                end += 4;
            }
            segment.mEnd = end;
            segment = signum >= 0 ? this.chainAppend(segment, valueBytes, 0, valueLen) : this.chainAppendFlip(segment, valueBytes, 0, valueLen);
        }
        return segment;
    }

    public Segment chainAppendCborDecimal(Segment segment, BigDecimal value) {
        if (value == null) {
            return this.chainAppend(segment, (byte)-10);
        }
        int scale = value.scale();
        BigInteger bi = value.unscaledValue();
        if (scale == 0) {
            return this.chainAppendCborInteger(segment, bi);
        }
        segment = this.chainRequire(segment, 2);
        byte[] bytes = segment.mBytes;
        int end = segment.mEnd;
        bytes[end++] = -60;
        bytes[end++] = -126;
        segment.mEnd = end;
        segment = this.chainAppendCborInteger(segment, -scale);
        return this.chainAppendCborInteger(segment, bi);
    }

    public Segment chainAppendCborFloat16(Segment segment, float value) {
        segment = this.chainRequire(segment, 3);
        byte[] bytes = segment.mBytes;
        int end = segment.mEnd;
        bytes[end++] = -7;
        Utils.encodeShortBE(bytes, end, Encoder.float32to16(value));
        segment.mEnd = end + 2;
        return segment;
    }

    public Segment chainAppendCborFloat(Segment segment, float value) {
        segment = this.chainRequire(segment, 5);
        byte[] bytes = segment.mBytes;
        int end = segment.mEnd;
        bytes[end++] = -6;
        Utils.encodeIntBE(bytes, end, Float.floatToRawIntBits(value));
        segment.mEnd = end + 4;
        return segment;
    }

    public Segment chainAppendCborDouble(Segment segment, double value) {
        segment = this.chainRequire(segment, 9);
        byte[] bytes = segment.mBytes;
        int end = segment.mEnd;
        bytes[end++] = -5;
        Utils.encodeLongBE(bytes, end, Double.doubleToRawLongBits(value));
        segment.mEnd = end + 8;
        return segment;
    }

    public Segment chainAppendCborSimple(Segment segment, byte value) {
        if (value >= 0 && value < 24) {
            segment = this.chainAppend(segment, (byte)(224 + value));
        } else {
            segment = this.chainRequire(segment, 2);
            byte[] bytes = segment.mBytes;
            int end = segment.mEnd;
            bytes[end++] = -8;
            bytes[end++] = value;
            segment.mEnd = end;
        }
        return segment;
    }

    public Segment chainAppendCborStreamBreak(Segment segment) {
        return this.chainAppend(segment, (byte)-1);
    }

    public static final class Segment {
        public final byte[] mBytes;
        public int mEnd;
        public Segment mNext;

        Segment(int capacity) {
            this.mBytes = new byte[capacity];
        }
    }
}

