/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits;

import com.amazon.cbor.SegmentPool;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class SegmentPool
extends com.amazon.cbor.SegmentPool {
    private static final ConcurrentMap<Integer, SegmentPool> cPools = new ConcurrentHashMap<Integer, SegmentPool>();

    public static SegmentPool withCapacity(int capacity) {
        SegmentPool pool = (SegmentPool)cPools.get(capacity);
        if (pool == null) {
            pool = new SegmentPool(capacity);
            SegmentPool existing = cPools.putIfAbsent(capacity, pool);
            if (existing != null) {
                pool = existing;
            }
        }
        return pool;
    }

    public SegmentPool(int capacity) {
        super(capacity);
    }

    public SegmentPool.Segment chainAppendCborBinarySet(SegmentPool.Segment segment, Collection<ByteBuffer> bSet) {
        segment = this.chainAppendCborTypePrefix(segment, 192, 3323L);
        segment = this.chainAppendCborTypePrefix(segment, 128, bSet.size());
        for (ByteBuffer data : bSet) {
            segment = this.chainAppendCborBinary(segment, data);
        }
        return segment;
    }

    public SegmentPool.Segment chainAppendCborStringSet(SegmentPool.Segment segment, Collection<String> sSet) {
        segment = this.chainAppendCborTypePrefix(segment, 192, 3321L);
        segment = this.chainAppendCborTypePrefix(segment, 128, sSet.size());
        for (String s : sSet) {
            segment = this.chainAppendCborString(segment, s);
        }
        return segment;
    }

    public SegmentPool.Segment chainAppendCborNumberSet(SegmentPool.Segment segment, Collection<String> nSet) {
        segment = this.chainAppendCborTypePrefix(segment, 192, 3322L);
        segment = this.chainAppendCborTypePrefix(segment, 128, nSet.size());
        for (String s : nSet) {
            segment = this.chainAppendCborNumberString(segment, s);
        }
        return segment;
    }
}

