/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits.dynamodb;

import com.amazon.cbor.SegmentPool;
import com.amazon.dax.bits.SegmentPool;
import com.amazon.dax.bits.dynamodb.AttributeValue;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

public class CborPackerCore {
    public static SegmentPool.Segment appendRaw(SegmentPool pool, SegmentPool.Segment tail, AttributeValue av) {
        if (av.type == 1) {
            tail = pool.chainAppendUtf8(tail, (String)av.value);
        } else {
            byte[] bytes = (byte[])av.value;
            tail = pool.chainAppend(tail, bytes, 0, bytes.length);
        }
        return tail;
    }

    public static SegmentPool.Segment appendValue(SegmentPool pool, SegmentPool.Segment tail, AttributeValue av) {
        switch (av.type) {
            default: {
                throw new IllegalArgumentException("Unknown type: " + av);
            }
            case 1: {
                tail = pool.chainAppendCborString(tail, (String)av.value);
                break;
            }
            case 2: {
                tail = CborPackerCore.appendDecimal(pool, tail, (String)av.value);
                break;
            }
            case 3: {
                tail = pool.chainAppendCborBytes(tail, (byte[])av.value);
                break;
            }
            case 4: {
                tail = pool.chainAppendCborTypePrefix(tail, 192, 3321L);
                Collection set = (Collection)av.value;
                tail = pool.chainAppendCborArrayPrefix(tail, set.size());
                for (String str : set) {
                    tail = pool.chainAppendCborString(tail, str);
                }
                break;
            }
            case 5: {
                tail = pool.chainAppendCborTypePrefix(tail, 192, 3322L);
                Collection set = (Collection)av.value;
                tail = pool.chainAppendCborArrayPrefix(tail, set.size());
                for (String str : set) {
                    tail = CborPackerCore.appendDecimal(pool, tail, str);
                }
                break;
            }
            case 6: {
                tail = pool.chainAppendCborTypePrefix(tail, 192, 3323L);
                Collection set = (Collection)av.value;
                tail = pool.chainAppendCborArrayPrefix(tail, set.size());
                for (byte[] entry : set) {
                    tail = pool.chainAppendCborBytes(tail, entry);
                }
                break;
            }
            case 7: {
                Map map = (Map)av.value;
                tail = pool.chainAppendCborMapPrefix(tail, map.size());
                for (Map.Entry entry : map.entrySet()) {
                    tail = pool.chainAppendCborString(tail, (String)entry.getKey());
                    tail = CborPackerCore.appendValue(pool, tail, (AttributeValue)entry.getValue());
                }
                break;
            }
            case 8: {
                Collection list = (Collection)av.value;
                tail = pool.chainAppendCborArrayPrefix(tail, list.size());
                for (AttributeValue entry : list) {
                    tail = CborPackerCore.appendValue(pool, tail, entry);
                }
                break;
            }
            case 9: {
                tail = pool.chainAppend(tail, (byte)-10);
                break;
            }
            case 10: {
                int cborType = (Boolean)av.value != false ? 245 : 244;
                tail = pool.chainAppend(tail, (byte)cborType);
            }
        }
        return tail;
    }

    public static SegmentPool.Segment appendDecimal(SegmentPool pool, SegmentPool.Segment tail, String str) {
        if (str.indexOf(46) < 0) {
            try {
                return pool.chainAppendCborInteger(tail, Long.parseLong(str));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pool.chainAppendCborDecimal(tail, new BigDecimal(str));
    }
}

