/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits.dynamodb;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DynamoNumerals {

    public static enum ErrorCodes {
        VALIDATION_ERROR("ValidationException"),
        CONDITIONAL_CHECK_ERROR("ConditionalCheckFailedException"),
        PROVISIONED_THROUGHPUT_ERROR("ProvisionedThroughputExceededException"),
        LIMIT_EXCEEDED_ERROR("LimitExceededException"),
        RESOURCE_NOT_FOUND_ERROR("ResourceNotFoundException"),
        RESOURCE_IN_USE_ERROR("ResourceInUseException"),
        THROTTLING_ERROR("ThrottlingException"),
        ITEM_COLLECTION_SIZE_ERROR("ItemCollectionSizeLimitExceededException"),
        INTERNAL_SERVER_ERROR("InternalServerError"),
        INTERNAL_FAILURE("InternalFailure"),
        EXPIRED_TOKEN_ERROR("ExpiredToken"),
        TRANSACTION_CANCELED_ERROR("TransactionCanceledException"),
        TRANSACTION_CONFLICT_ERROR("TransactionConflictException"),
        TRANSACTION_IN_PROGRESS_ERROR("TransactionInProgressException"),
        IDEMPOTENT_PARAMETER_MISMATCH_ERROR("IdempotentParameterMismatchException"),
        REQUEST_LIMIT_EXCEEDED_ERROR("RequestLimitExceededException"),
        ACCESS_DENIED_EXCEPTION("AccessDeniedException");

        public final String mErrorCode;
        private static final Map<String, ErrorCodes> ERROR_CODES_LOOKUP;

        private ErrorCodes(String errorCode) {
            this.mErrorCode = errorCode;
        }

        public static ErrorCodes from(String otherErrorCode) {
            return ERROR_CODES_LOOKUP.containsKey(otherErrorCode) ? ERROR_CODES_LOOKUP.get(otherErrorCode) : null;
        }

        static {
            ErrorCodes[] values = ErrorCodes.values();
            HashMap<String, ErrorCodes> lookup = new HashMap<String, ErrorCodes>(values.length);
            for (ErrorCodes value : values) {
                lookup.put(value.mErrorCode, value);
            }
            ERROR_CODES_LOOKUP = Collections.unmodifiableMap(lookup);
        }
    }

    public static enum ReturnItemCollectionMetrics {
        NONE(0),
        SIZE(1);

        public final int mCode;

        private ReturnItemCollectionMetrics(int code) {
            this.mCode = code;
        }

        public static ReturnItemCollectionMetrics fromName(String retVal) {
            if (retVal == null) {
                return NONE;
            }
            switch (retVal) {
                default: {
                    return NONE;
                }
                case "SIZE": 
            }
            return SIZE;
        }

        public static ReturnItemCollectionMetrics fromInt(int code) {
            switch (code) {
                default: {
                    return NONE;
                }
                case 1: 
            }
            return SIZE;
        }
    }

    public static enum ReturnConsumedCapacity {
        NONE(0),
        TOTAL(1),
        INDEXES(2);

        public final int mCode;

        private ReturnConsumedCapacity(int code) {
            this.mCode = code;
        }

        public static ReturnConsumedCapacity fromName(String retVal) {
            if (retVal == null) {
                return NONE;
            }
            switch (retVal) {
                default: {
                    return NONE;
                }
                case "TOTAL": {
                    return TOTAL;
                }
                case "INDEXES": 
            }
            return INDEXES;
        }

        public static ReturnConsumedCapacity fromInt(int code) {
            switch (code) {
                default: {
                    return NONE;
                }
                case 1: {
                    return TOTAL;
                }
                case 2: 
            }
            return INDEXES;
        }
    }

    public static enum GSIUpdate {
        CREATE(1),
        DELETE(2),
        UPDATE(3);

        public final int mCode;

        private GSIUpdate(int code) {
            this.mCode = code;
        }

        public static GSIUpdate fromName(String action) {
            switch (action) {
                default: {
                    throw new IllegalArgumentException("Invalid GSI Update action name: " + action);
                }
                case "Create": {
                    return CREATE;
                }
                case "Delete": {
                    return DELETE;
                }
                case "Update": 
            }
            return UPDATE;
        }

        public static GSIUpdate fromInt(int code) {
            switch (code) {
                case 1: {
                    return CREATE;
                }
                case 2: {
                    return DELETE;
                }
                case 3: {
                    return UPDATE;
                }
            }
            throw new IllegalArgumentException("Invalid GSI Update action numeral: " + code);
        }
    }

    public static enum SelectValue {
        ALL_ATTRIBUTES(1),
        ALL_PROJECTED_ATTRIBUTES(2),
        COUNT(3),
        SPECIFIC_ATTRIBUTES(4);

        public final int mCode;

        private SelectValue(int code) {
            this.mCode = code;
        }

        public static SelectValue fromName(String select) {
            if (select == null) {
                return ALL_ATTRIBUTES;
            }
            switch (select) {
                default: {
                    return ALL_ATTRIBUTES;
                }
                case "ALL_PROJECTED_ATTRIBUTES": {
                    return ALL_PROJECTED_ATTRIBUTES;
                }
                case "COUNT": {
                    return COUNT;
                }
                case "SPECIFIC_ATTRIBUTES": 
            }
            return SPECIFIC_ATTRIBUTES;
        }

        public static SelectValue fromInt(int code) {
            switch (code) {
                default: {
                    return ALL_ATTRIBUTES;
                }
                case 2: {
                    return ALL_PROJECTED_ATTRIBUTES;
                }
                case 3: {
                    return COUNT;
                }
                case 4: 
            }
            return SPECIFIC_ATTRIBUTES;
        }
    }

    public static enum ConsumedCapacity {
        CapacityUnits(1),
        ReadCapacityUnits(2),
        WriteCapacityUnits(3),
        TableName(4),
        Table(5),
        GlobalSecondaryIndexes(6),
        LocalSecondaryIndexes(7);

        public final int mCode;
        public static final ConsumedCapacity[] ALL_VALUES;

        private ConsumedCapacity(int code) {
            this.mCode = code;
        }

        public static ConsumedCapacity fromName(String consumedCapacity) {
            if (consumedCapacity == null) {
                return null;
            }
            try {
                return ConsumedCapacity.valueOf(consumedCapacity);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static ConsumedCapacity fromInt(int code) {
            switch (code) {
                default: {
                    return null;
                }
                case 1: {
                    return CapacityUnits;
                }
                case 2: {
                    return ReadCapacityUnits;
                }
                case 3: {
                    return WriteCapacityUnits;
                }
                case 4: {
                    return TableName;
                }
                case 5: {
                    return Table;
                }
                case 6: {
                    return GlobalSecondaryIndexes;
                }
                case 7: 
            }
            return LocalSecondaryIndexes;
        }

        static {
            ALL_VALUES = ConsumedCapacity.values();
        }
    }

    public static enum Operation {
        GET(1),
        PUT(2),
        EXCHANGE(3),
        INSERT(4),
        REPLACE(5),
        UPDATE(6),
        DELETE(7),
        REMOVE(8),
        PARTIAL_UPDATE(9),
        BATCH_GET(10),
        BATCH_WRITE(11),
        CHECK(12),
        TRANSACT_WRITE(13),
        TRANSACT_GET(14),
        SCAN(15),
        QUERY(16),
        CREATE_TABLE(17),
        DELETE_TABLE(18),
        DESCRIBE_TABLE(19),
        LIST_TABLES(20),
        UPDATE_TABLE(21);

        public final int mCode;

        private Operation(int code) {
            this.mCode = code;
        }

        public static Operation fromInt(int code) {
            switch (code) {
                default: {
                    throw new IllegalArgumentException("Operation " + code + " doesn't exist");
                }
                case 1: {
                    return GET;
                }
                case 2: {
                    return PUT;
                }
                case 3: {
                    return EXCHANGE;
                }
                case 4: {
                    return INSERT;
                }
                case 5: {
                    return REPLACE;
                }
                case 6: {
                    return UPDATE;
                }
                case 7: {
                    return DELETE;
                }
                case 8: {
                    return REMOVE;
                }
                case 9: {
                    return PARTIAL_UPDATE;
                }
                case 10: {
                    return BATCH_GET;
                }
                case 11: {
                    return BATCH_WRITE;
                }
                case 12: {
                    return CHECK;
                }
                case 13: {
                    return TRANSACT_WRITE;
                }
                case 14: {
                    return TRANSACT_GET;
                }
                case 15: {
                    return SCAN;
                }
                case 16: {
                    return QUERY;
                }
                case 17: {
                    return CREATE_TABLE;
                }
                case 18: {
                    return DELETE_TABLE;
                }
                case 19: {
                    return DESCRIBE_TABLE;
                }
                case 20: {
                    return LIST_TABLES;
                }
                case 21: 
            }
            return UPDATE_TABLE;
        }
    }

    public static enum ReturnValueOnConditionCheckFailure {
        NONE(1),
        ALL_OLD(2);

        public final int mCode;

        private ReturnValueOnConditionCheckFailure(int code) {
            this.mCode = code;
        }

        public static ReturnValueOnConditionCheckFailure fromName(String retVal) {
            if (retVal == null) {
                return NONE;
            }
            switch (retVal) {
                default: {
                    return NONE;
                }
                case "ALL_OLD": 
            }
            return ALL_OLD;
        }

        public static ReturnValueOnConditionCheckFailure fromInt(int code) {
            switch (code) {
                default: {
                    return NONE;
                }
                case 2: 
            }
            return ALL_OLD;
        }
    }

    public static enum ReturnValue {
        NONE(1),
        ALL_OLD(2),
        UPDATED_OLD(3),
        ALL_NEW(4),
        UPDATED_NEW(5);

        public final int mCode;

        private ReturnValue(int code) {
            this.mCode = code;
        }

        public static ReturnValue fromName(String retVal) {
            if (retVal == null) {
                return NONE;
            }
            switch (retVal) {
                default: {
                    return NONE;
                }
                case "ALL_OLD": {
                    return ALL_OLD;
                }
                case "UPDATED_OLD": {
                    return UPDATED_OLD;
                }
                case "ALL_NEW": {
                    return ALL_NEW;
                }
                case "UPDATED_NEW": 
            }
            return UPDATED_NEW;
        }

        public static ReturnValue fromInt(int code) {
            switch (code) {
                default: {
                    return NONE;
                }
                case 2: {
                    return ALL_OLD;
                }
                case 3: {
                    return UPDATED_OLD;
                }
                case 4: {
                    return ALL_NEW;
                }
                case 5: 
            }
            return UPDATED_NEW;
        }
    }
}

