/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client;

public final class HostPort {
    private final String mHost;
    private final int mPort;

    public HostPort(String host, int port) {
        this.mHost = host;
        this.mPort = port;
    }

    public String host() {
        return this.mHost;
    }

    public int port() {
        return this.mPort;
    }

    public String toString() {
        return this.mHost + ':' + this.mPort;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.mHost.hashCode();
        return 31 * result + this.mPort;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof HostPort)) {
            return false;
        }
        HostPort other = (HostPort)obj;
        return this.mHost.equals(other.mHost) && this.mPort == other.mPort;
    }

    public static HostPort parse(String hostport) throws IllegalArgumentException {
        int port;
        int colon = hostport.indexOf(58);
        if (colon <= 0) {
            throw new IllegalArgumentException("Invalid hostport: " + hostport);
        }
        String host = hostport.substring(0, colon);
        try {
            port = Integer.parseInt(hostport.substring(colon + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid hostport: " + hostport);
        }
        return new HostPort(host, port);
    }
}

