/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.cbor.Encoder;
import com.amazon.cbor.SegmentPool;
import com.amazon.dax.bits.DaxCborOutputStream;
import com.amazon.dax.bits.LexDecimal;
import com.amazon.dax.bits.SegmentPool;
import com.amazon.dax.bits.expr.CborSExprGenerator;
import com.amazon.dax.bits.expr.ExpressionType;
import com.amazon.dax.client.dynamodbv2.DocumentPath;
import com.amazon.dax.client.dynamodbv2.DynamoDBExpressionInfo;
import com.amazon.dax.client.dynamodbv2.ExceptionTranslator;
import com.amazon.dax.client.dynamodbv2.RequestValidator;
import com.amazon.dax.client.dynamodbv2.SimpleCache;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class AttributeValueEncoder {
    public static Map<ExpressionType, byte[]> encodeExpressions(String condExpr, String keyCondExpr, String filterExpr, String updateExpr, String projExpr, Map<String, String> eAttrStrs, Map<String, AttributeValue> eAttrVals) {
        Map<String, AttributeValue> eAttrNames = eAttrStrs == null ? Collections.emptyMap() : CborSExprGenerator.convertExpressionAttributeNames(eAttrStrs);
        eAttrVals = eAttrVals == null ? Collections.emptyMap() : eAttrVals;
        AttributeValueEncoder.checkValidExprParamNames(eAttrStrs, eAttrVals);
        return CborSExprGenerator.encodeExpressions(condExpr, keyCondExpr, filterExpr, updateExpr, projExpr, eAttrNames, eAttrVals);
    }

    public static byte[] encodeConditionalExp(String condExp, Map<String, String> eAttrStrs, Map<String, AttributeValue> eAttrVals) {
        if (condExp == null || condExp.isEmpty()) {
            return null;
        }
        eAttrStrs = eAttrStrs == null ? Collections.emptyMap() : eAttrStrs;
        eAttrVals = eAttrVals == null ? Collections.emptyMap() : eAttrVals;
        AttributeValueEncoder.checkValidExprParamNames(eAttrStrs, eAttrVals);
        return CborSExprGenerator.encodeConditionalExprWithStringAttrNames(condExp, eAttrStrs, eAttrVals);
    }

    public static byte[] encodeConditionalExp(DynamoDBExpressionInfo info) {
        return AttributeValueEncoder.encodeConditionalExp(info.getConditionExpression(), info.getExpressionAttributeNames(), info.getExpressionAttributeValues());
    }

    public static byte[] encodeProjection(String projExp, Map<String, String> eAttrStrs) {
        if (projExp == null || projExp.isEmpty()) {
            return null;
        }
        eAttrStrs = eAttrStrs == null ? Collections.emptyMap() : eAttrStrs;
        AttributeValueEncoder.checkValidExprParamNames(eAttrStrs, null);
        return CborSExprGenerator.encodeProjectionExpression(projExp, eAttrStrs);
    }

    public static byte[] encodeUpdateExpression(String updateExp, Map<String, String> eAttrStrs, Map<String, AttributeValue> eAttrVals) {
        if (updateExp == null || updateExp.isEmpty()) {
            return null;
        }
        eAttrStrs = eAttrStrs == null ? Collections.emptyMap() : eAttrStrs;
        eAttrVals = eAttrVals == null ? Collections.emptyMap() : eAttrVals;
        AttributeValueEncoder.checkValidExprParamNames(eAttrStrs, eAttrVals);
        return CborSExprGenerator.encodeUpdateExpression(updateExp, eAttrStrs, eAttrVals);
    }

    protected static SegmentPool.Segment encodeCompoundKey(SegmentPool pool, SegmentPool.Segment segment, Map<String, AttributeValue> attrs) throws IOException {
        segment = pool.chainAppendCborMapStreamPrefix(segment);
        if (attrs != null) {
            for (Map.Entry<String, AttributeValue> key : attrs.entrySet()) {
                segment = pool.chainAppendCborString(segment, key.getKey());
                if (key.getValue() == null) {
                    throw new IllegalArgumentException("Not enough fields to construct compound key");
                }
                segment = AttributeValueEncoder.encodeAttributeValue(pool, segment, key.getValue());
            }
        }
        segment = pool.chainAppendCborStreamBreak(segment);
        return segment;
    }

    protected static SegmentPool.Segment validateAndEncodeKey(SegmentPool pool, SegmentPool.Segment segment, Map<String, AttributeValue> item, List<AttributeDefinition> keys) throws IOException {
        RequestValidator.validateKey(item, keys);
        return AttributeValueEncoder.encodeKey(pool, segment, item, keys);
    }

    protected static SegmentPool.Segment encodeKey(SegmentPool pool, SegmentPool.Segment segment, Map<String, AttributeValue> item, List<AttributeDefinition> keys) throws IOException {
        if (item == null) {
            throw ExceptionTranslator.createValidationException("Cannot have null item");
        }
        AttributeDefinition ad = keys.get(0);
        AttributeValue av = item.get(ad.getAttributeName());
        if (av == null) {
            throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
        }
        if (keys.size() == 2) {
            String n;
            ByteBuffer b;
            String s;
            switch (ad.getAttributeType()) {
                case "S": {
                    s = av.getS();
                    if (s == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppendCborString(segment, s);
                    break;
                }
                case "B": {
                    b = av.getB();
                    if (b == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppendCborBinary(segment, b);
                    break;
                }
                case "N": {
                    n = av.getN();
                    if (n == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    try {
                        segment = pool.chainAppendCborNumberString(segment, n);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw ExceptionTranslator.createValidationException("A value provided cannot be converted into a number");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unsupported KeyType encountered in Hash Attribute: " + ad);
                }
            }
            ad = keys.get(1);
            av = item.get(ad.getAttributeName());
            if (av == null) {
                throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
            }
            switch (ad.getAttributeType()) {
                case "S": {
                    s = av.getS();
                    if (s == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppend(segment, Encoder.encodeUtf8(s));
                    break;
                }
                case "B": {
                    b = av.getB();
                    if (b == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppend(segment, b);
                    break;
                }
                case "N": {
                    n = av.getN();
                    if (n == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    try {
                        segment = pool.chainAppend(segment, LexDecimal.encode(new BigDecimal(n), 0));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw ExceptionTranslator.createValidationException("A value provided cannot be converted into a number");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unsupported KeyType encountered in Range Attribute: " + ad);
                }
            }
        } else {
            switch (ad.getAttributeType()) {
                case "S": {
                    String s = av.getS();
                    if (s == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppend(segment, Encoder.encodeUtf8(s));
                    break;
                }
                case "B": {
                    ByteBuffer b = av.getB();
                    if (b == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppend(segment, b);
                    break;
                }
                case "N": {
                    String n = av.getN();
                    if (n == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    try {
                        segment = pool.chainAppendCborNumberString(segment, n);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw ExceptionTranslator.createValidationException("A value provided cannot be converted into a number");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unsupported KeyType encountered in Hash Attribute: " + ad);
                }
            }
        }
        return segment;
    }

    public static List<String> encodeAttributes(Map<String, AttributeValue> attrs, List<String> keys, DaxCborOutputStream out) throws IOException {
        ArrayList<String> attrNames = new ArrayList<String>(attrs.size());
        for (Map.Entry<String, AttributeValue> e : attrs.entrySet()) {
            if (keys.contains(e.getKey())) continue;
            attrNames.add(e.getKey());
            AttributeValueEncoder.encodeAttributeValue(out, e.getValue());
        }
        return attrNames;
    }

    static void encodeAttributeValue(DaxCborOutputStream output, AttributeValue value) throws IOException {
        if (value.getS() != null) {
            output.writeString(value.getS());
        } else if (value.getN() != null) {
            output.writeNumber(value.getN());
        } else if (value.getB() != null) {
            output.writeBinary(value.getB());
        } else if (value.getSS() != null) {
            output.writeStringSet(value.getSS());
        } else if (value.getNS() != null) {
            output.writeNumberSet(value.getNS());
        } else if (value.getBS() != null) {
            output.writeBinarySet(value.getBS());
        } else if (value.getM() != null) {
            output.writeMapHeader(value.getM().size());
            for (Map.Entry e : value.getM().entrySet()) {
                output.writeString((String)e.getKey());
                AttributeValueEncoder.encodeAttributeValue(output, (AttributeValue)e.getValue());
            }
        } else if (value.getL() != null) {
            output.writeArrayHeader(value.getL().size());
            for (AttributeValue av : value.getL()) {
                AttributeValueEncoder.encodeAttributeValue(output, av);
            }
        } else if (value.isNULL() != null) {
            output.writeNull();
        } else if (value.isBOOL() != null) {
            output.writeBoolean(value.isBOOL());
        }
    }

    public static int encodeAttributes(Map<String, AttributeValue> attrs, List<AttributeDefinition> keys, SimpleCache<List<String>, Long> cache, SegmentPool pool, SegmentPool.Segment segment) throws IOException {
        HashSet<String> keySet = new HashSet<String>();
        for (AttributeDefinition ad : keys) {
            keySet.add(ad.getAttributeName());
        }
        TreeMap<String, AttributeValue> sortedAttrs = new TreeMap<String, AttributeValue>(attrs);
        ArrayList<String> attrNames = new ArrayList<String>(attrs.size());
        SegmentPool.Segment headSegment = pool.chainRequire(segment, 9);
        headSegment.mEnd += 9;
        int offset = headSegment.mEnd;
        for (Map.Entry<String, AttributeValue> e : sortedAttrs.entrySet()) {
            String attrName = e.getKey();
            if (keySet.contains(attrName)) continue;
            attrNames.add(attrName);
            AttributeValue val = e.getValue();
            if (e.getValue() == null) {
                throw ExceptionTranslator.createValidationException("The supplied Item contains a null AttributeValue: " + attrName + " is null");
            }
            segment = AttributeValueEncoder.encodeAttributeValue(pool, segment, val);
        }
        Long attrListId = cache.get(attrNames);
        return Encoder.prependCborInteger(headSegment.mBytes, offset, attrListId);
    }

    static SegmentPool.Segment encodeAttributeValue(SegmentPool pool, SegmentPool.Segment segment, AttributeValue value) throws IOException {
        if (value.getS() != null) {
            return pool.chainAppendCborString(segment, value.getS());
        }
        if (value.getN() != null) {
            try {
                return pool.chainAppendCborNumberString(segment, value.getN());
            }
            catch (NumberFormatException e) {
                throw ExceptionTranslator.createValidationException("A value provided cannot be converted into a number");
            }
        }
        if (value.getB() != null) {
            return pool.chainAppendCborBinary(segment, value.getB());
        }
        if (value.getSS() != null) {
            if (value.getSS().isEmpty()) {
                throw ExceptionTranslator.createValidationException("Supplied AttributeValue is empty, must contain exactly one of the supported datatypes");
            }
            return pool.chainAppendCborStringSet(segment, value.getSS());
        }
        if (value.getNS() != null) {
            if (value.getNS().isEmpty()) {
                throw ExceptionTranslator.createValidationException("Supplied AttributeValue is empty, must contain exactly one of the supported datatypes");
            }
            return pool.chainAppendCborNumberSet(segment, value.getNS());
        }
        if (value.getBS() != null) {
            if (value.getBS().isEmpty()) {
                throw ExceptionTranslator.createValidationException("Supplied AttributeValue is empty, must contain exactly one of the supported datatypes");
            }
            return pool.chainAppendCborBinarySet(segment, value.getBS());
        }
        if (value.getM() != null) {
            segment = pool.chainAppendCborMapPrefix(segment, value.getM().size());
            for (Map.Entry e : value.getM().entrySet()) {
                segment = pool.chainAppendCborString(segment, (String)e.getKey());
                segment = AttributeValueEncoder.encodeAttributeValue(pool, segment, (AttributeValue)e.getValue());
            }
            return segment;
        }
        if (value.getL() != null) {
            segment = pool.chainAppendCborArrayPrefix(segment, value.getL().size());
            for (AttributeValue av : value.getL()) {
                segment = AttributeValueEncoder.encodeAttributeValue(pool, segment, av);
            }
            return segment;
        }
        if (value.isNULL() != null) {
            return pool.chainAppend(segment, (byte)-10);
        }
        if (value.isBOOL() != null) {
            if (value.isBOOL().booleanValue()) {
                return pool.chainAppend(segment, (byte)-11);
            }
            return pool.chainAppend(segment, (byte)-12);
        }
        throw ExceptionTranslator.createValidationException("Supplied AttributeValue is empty, must contain exactly one of the supported datatypes" + value.toString());
    }

    private static void checkValidExprParamNames(Map<String, String> eAttrNames, Map<String, AttributeValue> eAttrVals) {
        if (eAttrVals != null) {
            AttributeValueEncoder.checkExprParams(eAttrVals.keySet(), true);
        }
        if (eAttrNames != null) {
            AttributeValueEncoder.checkExprParams(eAttrNames.keySet(), false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static void checkExprParams(Set<String> keyNames, boolean isExprAttrVals) {
        String s;
        char prefix = isExprAttrVals ? (char)':' : '#';
        if (keyNames == null) return;
        Iterator<String> iterator = keyNames.iterator();
        block0: while (true) {
            if (!iterator.hasNext()) return;
            s = iterator.next();
            int i = 0;
            if (s.length() <= 1 || s.charAt(i++) != prefix) break;
            while (true) {
                if (i >= s.length()) continue block0;
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_')) break block0;
                ++i;
            }
            break;
        }
        if (!isExprAttrVals) throw ExceptionTranslator.createValidationException("ExpressionAttributeNames contains invalid key: \"" + s + "\"");
        throw ExceptionTranslator.createValidationException("ExpressionAttributeValues contains invalid key: \"" + s + "\"");
    }

    public static Map<Integer, DocumentPath> prepareProjection(String expression, Map<String, String> attributeNames) {
        if (expression == null) {
            return null;
        }
        HashMap<Integer, DocumentPath> ords = new HashMap<Integer, DocumentPath>();
        AttributeValueEncoder.prepareProjection(expression, attributeNames, ords);
        return ords;
    }

    public static Map<Integer, DocumentPath> prepareProjection(DynamoDBExpressionInfo info) {
        return AttributeValueEncoder.prepareProjection(info.getProjectionExpression(), info.getExpressionAttributeNames());
    }

    public static void prepareProjection(String expression, Map<String, String> attributeNames, Map<Integer, DocumentPath> ords) {
        if (expression == null) {
            return;
        }
        String[] projectionTerms = expression.split(",");
        for (int i = 0; i < projectionTerms.length; ++i) {
            ords.put(i, DocumentPath.from(projectionTerms[i].trim(), attributeNames));
        }
    }
}

