/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.bits.disco.ServiceEndpoint;
import com.amazon.dax.client.cluster.Cluster;
import com.amazon.dax.client.dynamodbv2.AmazonDaxAsyncClient;
import com.amazon.dax.client.dynamodbv2.ClientConfig;
import com.amazon.dax.client.dynamodbv2.ClusterDaxClient;
import com.amazon.dax.client.dynamodbv2.Function;
import com.amazon.dax.client.retry.DaxBackoffStrategy;
import com.amazon.dax.client.utils.Utils;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.regions.Region;
import com.amazonaws.services.dynamodbv2.AbstractAmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.TransactGetItemsRequest;
import com.amazonaws.services.dynamodbv2.model.TransactGetItemsResult;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsRequest;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.dynamodbv2.waiters.AmazonDynamoDBWaiters;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterDaxAsyncClient
extends AbstractAmazonDynamoDBAsync
implements AmazonDaxAsyncClient {
    private static final Log LOG = LogFactory.getLog(ClusterDaxAsyncClient.class);
    private static ThreadFactory THREAD_FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("ClusterDaxAsyncClient-" + t.getId());
            t.setDaemon(true);
            return t;
        }
    };
    private final ClusterDaxClient mDaxClient;
    private final ExecutorService mExecutorService;

    public ClusterDaxAsyncClient(ClientConfig cfg) {
        this(cfg, Executors.newCachedThreadPool(THREAD_FACTORY));
    }

    public ClusterDaxAsyncClient(ClientConfig cfg, ExecutorService executorService) {
        this.mDaxClient = new ClusterDaxClient(cfg);
        this.mExecutorService = executorService;
    }

    ClusterDaxAsyncClient(ClientConfig cfg, Cluster cluster) {
        this(cfg, cluster, Executors.newCachedThreadPool(THREAD_FACTORY));
    }

    ClusterDaxAsyncClient(ClientConfig cfg, Cluster cluster, ExecutorService executorService) {
        this.mDaxClient = new ClusterDaxClient(cfg, cluster, new DaxBackoffStrategy());
        this.mExecutorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.mExecutorService;
    }

    public Future<BatchGetItemResult> batchGetItemAsync(BatchGetItemRequest request) {
        return this.batchGetItemAsync(request, null);
    }

    public Future<BatchGetItemResult> batchGetItemAsync(BatchGetItemRequest request, AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<BatchGetItemRequest, BatchGetItemResult>(){

            @Override
            public BatchGetItemResult apply(BatchGetItemRequest request) {
                return ClusterDaxAsyncClient.this.batchGetItem(request);
            }
        }, request, asyncHandler);
    }

    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems).withReturnConsumedCapacity(returnConsumedCapacity));
    }

    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity, AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems).withReturnConsumedCapacity(returnConsumedCapacity), asyncHandler);
    }

    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems));
    }

    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems), asyncHandler);
    }

    public Future<BatchWriteItemResult> batchWriteItemAsync(BatchWriteItemRequest request) {
        return this.batchWriteItemAsync(request, null);
    }

    public Future<BatchWriteItemResult> batchWriteItemAsync(BatchWriteItemRequest request, AsyncHandler<BatchWriteItemRequest, BatchWriteItemResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<BatchWriteItemRequest, BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult apply(BatchWriteItemRequest request) {
                return ClusterDaxAsyncClient.this.batchWriteItem(request);
            }
        }, request, asyncHandler);
    }

    public Future<BatchWriteItemResult> batchWriteItemAsync(Map<String, List<WriteRequest>> requestItems) {
        return this.batchWriteItemAsync(new BatchWriteItemRequest().withRequestItems(requestItems));
    }

    public Future<BatchWriteItemResult> batchWriteItemAsync(Map<String, List<WriteRequest>> requestItems, AsyncHandler<BatchWriteItemRequest, BatchWriteItemResult> asyncHandler) {
        return this.batchWriteItemAsync(new BatchWriteItemRequest().withRequestItems(requestItems), asyncHandler);
    }

    public Future<TransactGetItemsResult> transactGetItemsAsync(TransactGetItemsRequest request, AsyncHandler<TransactGetItemsRequest, TransactGetItemsResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<TransactGetItemsRequest, TransactGetItemsResult>(){

            @Override
            public TransactGetItemsResult apply(TransactGetItemsRequest request) {
                return ClusterDaxAsyncClient.this.transactGetItems(request);
            }
        }, request, asyncHandler);
    }

    public TransactGetItemsResult transactGetItems(TransactGetItemsRequest request) {
        return this.mDaxClient.transactGetItems(request);
    }

    public Future<TransactWriteItemsResult> transactWriteItemsAsync(TransactWriteItemsRequest request, AsyncHandler<TransactWriteItemsRequest, TransactWriteItemsResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<TransactWriteItemsRequest, TransactWriteItemsResult>(){

            @Override
            public TransactWriteItemsResult apply(TransactWriteItemsRequest request) {
                return ClusterDaxAsyncClient.this.transactWriteItems(request);
            }
        }, request, asyncHandler);
    }

    public TransactWriteItemsResult transactWriteItems(TransactWriteItemsRequest request) {
        return this.mDaxClient.transactWriteItems(request);
    }

    public Future<CreateTableResult> createTableAsync(CreateTableRequest request) {
        return this.createTableAsync(request, null);
    }

    public Future<CreateTableResult> createTableAsync(CreateTableRequest request, AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<CreateTableRequest, CreateTableResult>(){

            @Override
            public CreateTableResult apply(CreateTableRequest request) {
                return ClusterDaxAsyncClient.this.createTable(request);
            }
        }, request, asyncHandler);
    }

    public Future<CreateTableResult> createTableAsync(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput) {
        return this.createTableAsync(new CreateTableRequest().withAttributeDefinitions(attributeDefinitions).withTableName(tableName).withKeySchema(keySchema).withProvisionedThroughput(provisionedThroughput));
    }

    public Future<CreateTableResult> createTableAsync(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput, AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) {
        return this.createTableAsync(new CreateTableRequest().withAttributeDefinitions(attributeDefinitions).withTableName(tableName).withKeySchema(keySchema).withProvisionedThroughput(provisionedThroughput), asyncHandler);
    }

    public Future<DeleteItemResult> deleteItemAsync(DeleteItemRequest request) {
        return this.deleteItemAsync(request, null);
    }

    public Future<DeleteItemResult> deleteItemAsync(DeleteItemRequest request, AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<DeleteItemRequest, DeleteItemResult>(){

            @Override
            public DeleteItemResult apply(DeleteItemRequest request) {
                return ClusterDaxAsyncClient.this.deleteItem(request);
            }
        }, request, asyncHandler);
    }

    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key));
    }

    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key), asyncHandler);
    }

    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, String returnValues) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key).withReturnValues(returnValues));
    }

    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, String returnValues, AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key).withReturnValues(returnValues), asyncHandler);
    }

    public Future<DeleteTableResult> deleteTableAsync(DeleteTableRequest request) {
        return this.deleteTableAsync(request, null);
    }

    public Future<DeleteTableResult> deleteTableAsync(DeleteTableRequest request, AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<DeleteTableRequest, DeleteTableResult>(){

            @Override
            public DeleteTableResult apply(DeleteTableRequest request) {
                return ClusterDaxAsyncClient.this.deleteTable(request);
            }
        }, request, asyncHandler);
    }

    public Future<DeleteTableResult> deleteTableAsync(String tableName) {
        return this.deleteTableAsync(new DeleteTableRequest().withTableName(tableName));
    }

    public Future<DeleteTableResult> deleteTableAsync(String tableName, AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) {
        return this.deleteTableAsync(new DeleteTableRequest().withTableName(tableName), asyncHandler);
    }

    public Future<DescribeLimitsResult> describeLimitsAsync(DescribeLimitsRequest request) {
        return this.describeLimitsAsync(request, null);
    }

    public Future<DescribeLimitsResult> describeLimitsAsync(DescribeLimitsRequest request, AsyncHandler<DescribeLimitsRequest, DescribeLimitsResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<DescribeLimitsRequest, DescribeLimitsResult>(){

            @Override
            public DescribeLimitsResult apply(DescribeLimitsRequest request) {
                return ClusterDaxAsyncClient.this.describeLimits(request);
            }
        }, request, asyncHandler);
    }

    public Future<DescribeTableResult> describeTableAsync(DescribeTableRequest request) {
        return this.describeTableAsync(request, null);
    }

    public Future<DescribeTableResult> describeTableAsync(DescribeTableRequest request, AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<DescribeTableRequest, DescribeTableResult>(){

            @Override
            public DescribeTableResult apply(DescribeTableRequest request) {
                return ClusterDaxAsyncClient.this.describeTable(request);
            }
        }, request, asyncHandler);
    }

    public Future<DescribeTableResult> describeTableAsync(String tableName) {
        return this.describeTableAsync(new DescribeTableRequest().withTableName(tableName));
    }

    public Future<DescribeTableResult> describeTableAsync(String tableName, AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) {
        return this.describeTableAsync(new DescribeTableRequest().withTableName(tableName), asyncHandler);
    }

    public Future<GetItemResult> getItemAsync(GetItemRequest request) {
        return this.getItemAsync(request, null);
    }

    public Future<GetItemResult> getItemAsync(GetItemRequest request, AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<GetItemRequest, GetItemResult>(){

            @Override
            public GetItemResult apply(GetItemRequest request) {
                return ClusterDaxAsyncClient.this.getItem(request);
            }
        }, request, asyncHandler);
    }

    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key));
    }

    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key), asyncHandler);
    }

    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, Boolean consistentRead) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key).withConsistentRead(consistentRead));
    }

    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, Boolean consistentRead, AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key).withConsistentRead(consistentRead), asyncHandler);
    }

    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request) {
        return this.listTablesAsync(request, null);
    }

    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<ListTablesRequest, ListTablesResult>(){

            @Override
            public ListTablesResult apply(ListTablesRequest request) {
                return ClusterDaxAsyncClient.this.listTables(request);
            }
        }, request, asyncHandler);
    }

    public Future<ListTablesResult> listTablesAsync() {
        return this.listTablesAsync(new ListTablesRequest());
    }

    public Future<ListTablesResult> listTablesAsync(AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest(), asyncHandler);
    }

    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName));
    }

    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName), asyncHandler);
    }

    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, Integer limit) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName).withLimit(limit));
    }

    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, Integer limit, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName).withLimit(limit), asyncHandler);
    }

    public Future<ListTablesResult> listTablesAsync(Integer limit) {
        return this.listTablesAsync(new ListTablesRequest().withLimit(limit));
    }

    public Future<ListTablesResult> listTablesAsync(Integer limit, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withLimit(limit), asyncHandler);
    }

    public Future<PutItemResult> putItemAsync(PutItemRequest request) {
        return this.putItemAsync(request, null);
    }

    public Future<PutItemResult> putItemAsync(PutItemRequest request, AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<PutItemRequest, PutItemResult>(){

            @Override
            public PutItemResult apply(PutItemRequest request) {
                return ClusterDaxAsyncClient.this.putItem(request);
            }
        }, request, asyncHandler);
    }

    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item));
    }

    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item), asyncHandler);
    }

    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, String returnValues) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item).withReturnValues(returnValues));
    }

    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, String returnValues, AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item).withReturnValues(returnValues), asyncHandler);
    }

    public Future<QueryResult> queryAsync(QueryRequest request) {
        return this.queryAsync(request, null);
    }

    public Future<QueryResult> queryAsync(QueryRequest request, AsyncHandler<QueryRequest, QueryResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<QueryRequest, QueryResult>(){

            @Override
            public QueryResult apply(QueryRequest request) {
                return ClusterDaxAsyncClient.this.query(request);
            }
        }, request, asyncHandler);
    }

    public Future<ScanResult> scanAsync(ScanRequest request) {
        return this.scanAsync(request, null);
    }

    public Future<ScanResult> scanAsync(ScanRequest request, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<ScanRequest, ScanResult>(){

            @Override
            public ScanResult apply(ScanRequest request) {
                return ClusterDaxAsyncClient.this.scan(request);
            }
        }, request, asyncHandler);
    }

    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet));
    }

    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet), asyncHandler);
    }

    public Future<ScanResult> scanAsync(String tableName, Map<String, Condition> scanFilter) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withScanFilter(scanFilter));
    }

    public Future<ScanResult> scanAsync(String tableName, Map<String, Condition> scanFilter, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withScanFilter(scanFilter), asyncHandler);
    }

    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet).withScanFilter(scanFilter));
    }

    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet).withScanFilter(scanFilter), asyncHandler);
    }

    public Future<UpdateItemResult> updateItemAsync(UpdateItemRequest request) {
        return this.updateItemAsync(request, null);
    }

    public Future<UpdateItemResult> updateItemAsync(UpdateItemRequest request, AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<UpdateItemRequest, UpdateItemResult>(){

            @Override
            public UpdateItemResult apply(UpdateItemRequest request) {
                return ClusterDaxAsyncClient.this.updateItem(request);
            }
        }, request, asyncHandler);
    }

    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates));
    }

    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates), asyncHandler);
    }

    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates).withReturnValues(returnValues));
    }

    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues, AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates).withReturnValues(returnValues), asyncHandler);
    }

    public Future<UpdateTableResult> updateTableAsync(UpdateTableRequest request) {
        return this.updateTableAsync(request, null);
    }

    public Future<UpdateTableResult> updateTableAsync(UpdateTableRequest request, AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) {
        return Utils.doSubmit(this.mExecutorService, new Function<UpdateTableRequest, UpdateTableResult>(){

            @Override
            public UpdateTableResult apply(UpdateTableRequest request) {
                return ClusterDaxAsyncClient.this.updateTable(request);
            }
        }, request, asyncHandler);
    }

    public Future<UpdateTableResult> updateTableAsync(String tableName, ProvisionedThroughput provisionedThroughput) {
        return this.updateTableAsync(new UpdateTableRequest().withTableName(tableName).withProvisionedThroughput(provisionedThroughput));
    }

    public Future<UpdateTableResult> updateTableAsync(String tableName, ProvisionedThroughput provisionedThroughput, AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) {
        return this.updateTableAsync(new UpdateTableRequest().withTableName(tableName).withProvisionedThroughput(provisionedThroughput), asyncHandler);
    }

    public void shutdown() {
        this.shutdown(10000L);
    }

    void shutdown(long timeoutMillis) {
        this.mDaxClient.shutdown();
        if (!Utils.shutdownAndAwaitTermination(this.mExecutorService, timeoutMillis)) {
            LOG.warn((Object)("ExecutorService didn't terminate within" + timeoutMillis + " seconds"));
        }
    }

    public void setEndpoint(String endpoint) {
        this.mDaxClient.setEndpoint(endpoint);
    }

    public void setRegion(Region region) {
        this.mDaxClient.setRegion(region);
    }

    @Override
    public void setRegion(String region) {
        this.mDaxClient.setRegion(region);
    }

    public BatchGetItemResult batchGetItem(BatchGetItemRequest request) {
        return this.mDaxClient.batchGetItem(request);
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity) {
        return this.mDaxClient.batchGetItem(requestItems, returnConsumedCapacity);
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> requestItems) {
        return this.mDaxClient.batchGetItem(requestItems);
    }

    public BatchWriteItemResult batchWriteItem(BatchWriteItemRequest request) {
        return this.mDaxClient.batchWriteItem(request);
    }

    public BatchWriteItemResult batchWriteItem(Map<String, List<WriteRequest>> requestItems) {
        return this.mDaxClient.batchWriteItem(requestItems);
    }

    public CreateTableResult createTable(CreateTableRequest request) {
        return this.mDaxClient.createTable(request);
    }

    public CreateTableResult createTable(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput) {
        return this.mDaxClient.createTable(attributeDefinitions, tableName, keySchema, provisionedThroughput);
    }

    public DeleteItemResult deleteItem(DeleteItemRequest request) {
        return this.mDaxClient.deleteItem(request);
    }

    public DeleteItemResult deleteItem(String tableName, Map<String, AttributeValue> key) {
        return this.mDaxClient.deleteItem(tableName, key);
    }

    public DeleteItemResult deleteItem(String tableName, Map<String, AttributeValue> key, String returnValues) {
        return this.mDaxClient.deleteItem(tableName, key, returnValues);
    }

    public DeleteTableResult deleteTable(DeleteTableRequest request) {
        return this.mDaxClient.deleteTable(request);
    }

    public DeleteTableResult deleteTable(String tableName) {
        return this.mDaxClient.deleteTable(tableName);
    }

    public DescribeLimitsResult describeLimits(DescribeLimitsRequest request) {
        return this.mDaxClient.describeLimits(request);
    }

    public DescribeTableResult describeTable(DescribeTableRequest request) {
        return this.mDaxClient.describeTable(request);
    }

    public DescribeTableResult describeTable(String tableName) {
        return this.mDaxClient.describeTable(tableName);
    }

    public GetItemResult getItem(GetItemRequest request) {
        return this.mDaxClient.getItem(request);
    }

    public GetItemResult getItem(String tableName, Map<String, AttributeValue> key) {
        return this.mDaxClient.getItem(tableName, key);
    }

    public GetItemResult getItem(String tableName, Map<String, AttributeValue> key, Boolean consistentRead) {
        return this.mDaxClient.getItem(tableName, key, consistentRead);
    }

    public ListTablesResult listTables(ListTablesRequest request) {
        return this.mDaxClient.listTables(request);
    }

    public ListTablesResult listTables() {
        return this.mDaxClient.listTables();
    }

    public ListTablesResult listTables(String exclusiveStartTableName) {
        return this.mDaxClient.listTables(exclusiveStartTableName);
    }

    public ListTablesResult listTables(String exclusiveStartTableName, Integer limit) {
        return this.mDaxClient.listTables(exclusiveStartTableName, limit);
    }

    public ListTablesResult listTables(Integer limit) {
        return this.mDaxClient.listTables(limit);
    }

    public PutItemResult putItem(PutItemRequest request) {
        return this.mDaxClient.putItem(request);
    }

    public PutItemResult putItem(String tableName, Map<String, AttributeValue> item) {
        return this.mDaxClient.putItem(tableName, item);
    }

    public PutItemResult putItem(String tableName, Map<String, AttributeValue> item, String returnValues) {
        return this.mDaxClient.putItem(tableName, item, returnValues);
    }

    public QueryResult query(QueryRequest request) {
        return this.mDaxClient.query(request);
    }

    public ScanResult scan(ScanRequest request) {
        return this.mDaxClient.scan(request);
    }

    public ScanResult scan(String tableName, List<String> attributesToGet) {
        return this.mDaxClient.scan(tableName, attributesToGet);
    }

    public ScanResult scan(String tableName, Map<String, Condition> scanFilter) {
        return this.mDaxClient.scan(tableName, scanFilter);
    }

    public ScanResult scan(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter) {
        return this.mDaxClient.scan(tableName, attributesToGet, scanFilter);
    }

    public UpdateItemResult updateItem(UpdateItemRequest request) {
        return this.mDaxClient.updateItem(request);
    }

    public UpdateItemResult updateItem(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates) {
        return this.mDaxClient.updateItem(tableName, key, attributeUpdates);
    }

    public UpdateItemResult updateItem(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues) {
        return this.mDaxClient.updateItem(tableName, key, attributeUpdates, returnValues);
    }

    public UpdateTableResult updateTable(UpdateTableRequest request) {
        return this.mDaxClient.updateTable(request);
    }

    public UpdateTableResult updateTable(String tableName, ProvisionedThroughput provisionedThroughput) {
        return this.mDaxClient.updateTable(tableName, provisionedThroughput);
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.mDaxClient.getCachedResponseMetadata(request);
    }

    public AmazonDynamoDBWaiters waiters() {
        return this.mDaxClient.waiters();
    }

    @Override
    public List<AttributeDefinition> defineKeySchema(String tableName) throws AmazonClientException {
        return this.mDaxClient.defineKeySchema(tableName);
    }

    @Override
    public Long defineAttributeListId(List<String> attributeNames, List<String> keyNames) throws AmazonClientException {
        return this.mDaxClient.defineAttributeListId(attributeNames, keyNames);
    }

    @Override
    public Long defineAttributeListId(List<String> attributeNames) throws AmazonClientException {
        return this.mDaxClient.defineAttributeListId(attributeNames);
    }

    @Override
    public List<String> defineAttributeList(Long attributeListId) throws AmazonClientException {
        return this.mDaxClient.defineAttributeList(attributeListId);
    }

    @Override
    public List<ServiceEndpoint> endpoints() throws AmazonClientException {
        return this.mDaxClient.endpoints();
    }

    @Override
    public List<Integer> services() throws AmazonClientException {
        return this.mDaxClient.services();
    }

    @Override
    public List<Integer> methods(int serviceId) throws AmazonClientException {
        return this.mDaxClient.methods(serviceId);
    }
}

