/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.bits.dynamodb.DynamoNumerals;
import com.amazon.dax.client.exceptions.DaxServiceException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.model.AmazonDynamoDBException;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.IdempotentParameterMismatchException;
import com.amazonaws.services.dynamodbv2.model.InternalServerErrorException;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionSizeLimitExceededException;
import com.amazonaws.services.dynamodbv2.model.LimitExceededException;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.TransactionCanceledException;
import com.amazonaws.services.dynamodbv2.model.TransactionConflictException;
import com.amazonaws.services.dynamodbv2.model.TransactionInProgressException;

public class ExceptionTranslator {
    public static final String NOT_IMPLEMENTED = "NotImplementedException";

    public static AmazonClientException translateException(DaxServiceException e) {
        int[] codes = e.getCodeSeq();
        if (codes.length < 2) {
            return e;
        }
        switch (codes[1]) {
            case 23: {
                if (codes.length <= 2) break;
                switch (codes[2]) {
                    case 24: {
                        return new ResourceNotFoundException(e.getServiceErrorMessage());
                    }
                    case 35: {
                        return new ResourceInUseException(e.getServiceErrorMessage());
                    }
                }
                break;
            }
            case 37: {
                if (codes.length <= 3) break;
                switch (codes[3]) {
                    case 39: {
                        AmazonServiceException ase = null;
                        if (codes.length > 4) {
                            switch (codes[4]) {
                                case 40: {
                                    ase = new ProvisionedThroughputExceededException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 41: {
                                    ase = new ResourceNotFoundException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 43: {
                                    ase = new ConditionalCheckFailedException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 45: {
                                    ase = new ResourceInUseException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 46: {
                                    ase = ExceptionTranslator.createValidationException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 47: {
                                    ase = new InternalServerErrorException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 48: {
                                    ase = new ItemCollectionSizeLimitExceededException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 49: {
                                    ase = new LimitExceededException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 50: {
                                    ase = new AmazonDynamoDBException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 57: {
                                    ase = new TransactionConflictException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 58: {
                                    ase = new TransactionCanceledException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 59: {
                                    ase = new TransactionInProgressException(e.getServiceErrorMessage());
                                    break;
                                }
                                case 60: {
                                    ase = new IdempotentParameterMismatchException(e.getServiceErrorMessage());
                                }
                            }
                        }
                        if (ase == null) {
                            ase = new AmazonDynamoDBException(e.getMessage());
                        }
                        ase.setRequestId(e.getRequestId());
                        ase.setStatusCode(e.getStatusCode());
                        ase.setErrorCode(e.getErrorCode());
                        return ase;
                    }
                    case 44: {
                        return ExceptionTranslator.createValidationException(NOT_IMPLEMENTED);
                    }
                }
            }
        }
        return e;
    }

    public static AmazonServiceException createValidationException(String errorMessage) {
        return new DaxServiceException(errorMessage, DynamoNumerals.ErrorCodes.VALIDATION_ERROR.mErrorCode);
    }
}

