/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.bits.LazyClock;
import com.amazon.dax.client.dynamodbv2.SimpleCache;
import com.amazonaws.AmazonClientException;
import java.util.AbstractMap;
import java.util.Map;

public class RefreshingCache<K, V> {
    private final SimpleCache<K, Map.Entry<V, Long>> mCache;
    private final LazyClock mClock;
    private final long mTimeToLive;

    public RefreshingCache(int size, Fetcher<K, V> fetcher, long timeToLiveMillis) {
        this(size, fetcher, timeToLiveMillis, LazyClock.instance());
    }

    public RefreshingCache(int size, Fetcher<K, V> fetcher, long timeToLiveMillis, long clockDelayMillis) {
        this(size, fetcher, timeToLiveMillis, LazyClock.custom(clockDelayMillis));
    }

    private RefreshingCache(int size, Fetcher<K, V> fetcher, long timeToLive, LazyClock clock) {
        this.mCache = this.createCache(size, fetcher);
        this.mClock = clock;
        this.mTimeToLive = timeToLive;
    }

    public V get(K key) {
        Map.Entry<V, Long> innerValue = this.mCache.get(key);
        if (innerValue == null || innerValue.getValue() + this.mTimeToLive < this.mClock.getCurrentTime()) {
            this.mCache.remove(key);
            innerValue = this.mCache.get(key);
        }
        return innerValue == null ? null : (V)innerValue.getKey();
    }

    public V put(K key, V value) {
        AbstractMap.SimpleEntry<Long, Long> newInnerValue = new AbstractMap.SimpleEntry<Long, Long>((Long)value, this.mClock.getCurrentTime());
        Map.Entry oldInnerValue = this.mCache.put(key, newInnerValue);
        return oldInnerValue == null ? null : (V)oldInnerValue.getKey();
    }

    private SimpleCache<K, Map.Entry<V, Long>> createCache(int size, final Fetcher<K, V> fetcher) {
        return new SimpleCache<K, Map.Entry<V, Long>>(size){

            @Override
            protected Map.Entry<V, Long> fetch(K key) throws AmazonClientException {
                return new AbstractMap.SimpleEntry(fetcher.fetch(key), RefreshingCache.this.mClock.getCurrentTime());
            }
        };
    }

    public static interface Fetcher<K, V> {
        public V fetch(K var1);
    }
}

