/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.org.antlr.v4.runtime.misc;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class Utils {
    public static <T> String join(Iterator<T> iter, String separator) {
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static <T> String join(T[] array, String separator) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            builder.append(array[i]);
            if (i >= array.length - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static int numNonnull(Object[] data) {
        int n = 0;
        if (data == null) {
            return n;
        }
        for (Object o : data) {
            if (o == null) continue;
            ++n;
        }
        return n;
    }

    public static <T> void removeAllElements(Collection<T> data, T value) {
        if (data == null) {
            return;
        }
        while (data.contains(value)) {
            data.remove(value);
        }
    }

    public static String escapeWhitespace(String s, boolean escapeSpaces) {
        StringBuilder buf = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c == ' ' && escapeSpaces) {
                buf.append('\u00b7');
                continue;
            }
            if (c == '\t') {
                buf.append("\\t");
                continue;
            }
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\r') {
                buf.append("\\r");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static void writeFile(String fileName, String content) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        BufferedWriter w = new BufferedWriter(fw);
        w.write(content);
        ((Writer)w).close();
    }

    public static void waitForClose(final Window window) throws InterruptedException {
        final Object lock = new Object();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    while (window.isVisible()) {
                        try {
                            lock.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        };
        t.start();
        window.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent arg0) {
                Object object = lock;
                synchronized (object) {
                    window.setVisible(false);
                    lock.notify();
                }
            }
        });
        t.join();
    }
}

