/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.retry;

import com.amazon.dax.client.cluster.Cluster;
import com.amazon.dax.client.exceptions.AmbiguousWriteFailureException;
import com.amazon.dax.client.retry.ClusterBaseRetryHandler;
import com.amazon.dax.client.retry.WriteRetryHandler;
import com.amazon.dax.client.utils.Utils;
import com.amazonaws.AmazonClientException;
import com.amazonaws.retry.v2.BackoffStrategy;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;

public class ClusterWriteRetryHandler
extends ClusterBaseRetryHandler {
    public ClusterWriteRetryHandler(BackoffStrategy backoffStrategy, int maxRetries, Cluster cluster, long recoveryDuration, TimeUnit recoveryDurationUnit) {
        super(cluster, recoveryDuration, recoveryDurationUnit, new WriteRetryHandler(backoffStrategy, maxRetries));
    }

    @Override
    protected boolean shouldWaitForClusterRecoveryBeforeRetrying() {
        if (super.shouldWaitForClusterRecoveryBeforeRetrying()) {
            return true;
        }
        return this.lastException().getCause() instanceof ConnectException;
    }

    @Override
    public AmazonClientException toAce(Exception lastException) {
        if (Utils.isWriteFailureAmbiguous(lastException)) {
            return new AmbiguousWriteFailureException(lastException);
        }
        return super.toAce(lastException);
    }
}

