/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.utils;

import com.amazon.cbor.EndOfStreamException;
import com.amazon.dax.bits.disco.ServiceEndpoint;
import com.amazon.dax.client.dynamodbv2.Function;
import com.amazon.dax.client.exceptions.DaxServiceException;
import com.amazon.dax.client.exceptions.DecoderException;
import com.amazon.dax.client.exceptions.MalformedResultException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.InternalServerErrorException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class Utils {
    private static final int[] ERROR_CODE_SEQUENCE_FOR_IO_TIMEOUT_EXCEPTION = new int[]{1, 37, 38, 53};
    private static final int[] ERROR_CODE_SEQUENCE_FOR_DYNAMO_RESPONSE_DECODER_EXCEPTION = new int[]{1, 37, 38, 55};

    public static <K, V> V mapGetOrDefault(Map<K, V> map, K key, V defaultValue) {
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    public static String stringJoin(CharSequence delimiter, CharSequence ... elements) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            result.append(elements[i]);
            if (i >= elements.length - 1) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static boolean shutdownAndAwaitTermination(ExecutorService executorService, long timeoutMillis) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
        }
        catch (InterruptedException ie) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    public static <T extends AmazonWebServiceRequest, R> Future<R> doSubmit(ExecutorService executor, final Function<T, R> operation, final T request, final AsyncHandler<T, R> callback) {
        return executor.submit(new Callable<R>(){

            @Override
            public R call() throws Exception {
                Object result;
                try {
                    result = operation.apply(request);
                }
                catch (Exception ex) {
                    if (callback != null) {
                        callback.onError(ex);
                    }
                    throw ex;
                }
                if (callback != null) {
                    callback.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    public static boolean isWriteFailureAmbiguous(Throwable e) {
        DaxServiceException dse;
        if (e instanceof DecoderException || e instanceof MalformedResultException) {
            return true;
        }
        if (e instanceof DaxServiceException && (Arrays.equals(ERROR_CODE_SEQUENCE_FOR_IO_TIMEOUT_EXCEPTION, (dse = (DaxServiceException)((Object)e)).getCodeSeq()) || Arrays.equals(ERROR_CODE_SEQUENCE_FOR_DYNAMO_RESPONSE_DECODER_EXCEPTION, dse.getCodeSeq()))) {
            return true;
        }
        if (e instanceof InternalServerErrorException) {
            return true;
        }
        if (e instanceof AmazonClientException) {
            AmazonClientException ace = (AmazonClientException)e;
            Throwable causedBy = ace.getCause();
            if (causedBy instanceof EndOfStreamException || causedBy instanceof SocketTimeoutException || causedBy instanceof SocketException && !(causedBy instanceof ConnectException)) {
                return true;
            }
            if (causedBy instanceof AmazonClientException) {
                return Utils.isWriteFailureAmbiguous(causedBy);
            }
        }
        return e instanceof RuntimeException && !(e instanceof AmazonClientException);
    }

    public static Map<String, AttributeValue> extractKey(Map<String, AttributeValue> item, List<AttributeDefinition> tableKeys) {
        HashMap<String, AttributeValue> keys = new HashMap<String, AttributeValue>();
        for (AttributeDefinition keyDef : tableKeys) {
            String keyName = keyDef.getAttributeName();
            keys.put(keyName, item.get(keyName));
        }
        return keys;
    }

    public static String serviceEndpointsToString(Set<ServiceEndpoint> endpoints) {
        if (endpoints == null || endpoints.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ServiceEndpoint e : endpoints) {
            try {
                sb.append(e.role()).append(' ').append(new InetSocketAddress(InetAddress.getByAddress(e.address()), e.port()));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            sb.append(", ");
        }
        int len = sb.length();
        sb.delete(len - 2, len);
        return sb.toString();
    }
}

