/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.cbor;

import com.amazon.cbor.CborOutputStream;
import com.amazon.cbor.Decoder;
import com.amazon.cbor.IntRef;
import com.amazon.cbor.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class Cbor
extends CborOutputStream {
    protected Cbor() {
        super(new ByteArrayOutputStream());
    }

    public static Object tag(long value, Object obj) throws IOException {
        return new Tag(value, obj);
    }

    public static Object indefinite(String ... parts) throws IOException {
        return new Indefinite(127, parts);
    }

    public static Object indefinite(byte[] ... parts) throws IOException {
        return new Indefinite(95, (Object[])parts);
    }

    public static Object indefinite(Map<?, ?> parts) throws IOException {
        Object[] kvs = new Object[parts.size() * 2];
        int i = 0;
        for (Map.Entry<?, ?> en : parts.entrySet()) {
            kvs[i++] = en.getKey();
            kvs[i++] = en.getValue();
        }
        return new Indefinite(191, kvs);
    }

    public static Object indefinite(List<?> parts) throws IOException {
        return new Indefinite(159, parts.toArray());
    }

    public static Object indefinite(Object ... parts) throws IOException {
        return new Indefinite(159, parts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] pack(Object obj) throws IOException {
        try (Cbor c = new Cbor();){
            c.writeObject(obj);
            byte[] byArray = c.bytes();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] packList(List<?> objects) throws IOException {
        try (Cbor c = new Cbor();){
            c.writeList(objects);
            byte[] byArray = c.bytes();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] packList(Object ... objects) throws IOException {
        try (Cbor c = new Cbor();){
            c.writeList(objects);
            byte[] byArray = c.bytes();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] packMap(Map<?, ?> objects) throws IOException {
        try (Cbor c = new Cbor();){
            c.writeMap(objects);
            byte[] byArray = c.bytes();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] packMap(Object ... objects) throws IOException {
        try (Cbor c = new Cbor();){
            c.writeMap(objects);
            byte[] byArray = c.bytes();
            return byArray;
        }
    }

    private byte[] bytes() throws IOException {
        return this.getBytesForTest();
    }

    private void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.writeNull();
            return;
        }
        if (obj instanceof byte[]) {
            this.writeBytes((byte[])obj);
            return;
        }
        if (obj instanceof String) {
            this.writeString((String)obj);
            return;
        }
        if (obj instanceof Integer) {
            this.writeInt((Integer)obj);
            return;
        }
        if (obj instanceof Long) {
            this.writeLong((Long)obj);
            return;
        }
        if (obj instanceof Double) {
            this.writeDouble((Double)obj);
            return;
        }
        if (obj instanceof Float) {
            this.writeFloat(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof BigDecimal) {
            this.writeBigDecimal((BigDecimal)obj);
            return;
        }
        if (obj instanceof BigInteger) {
            this.writeBigInteger((BigInteger)obj);
            return;
        }
        if (obj instanceof Boolean) {
            this.writeBoolean((Boolean)obj);
            return;
        }
        if (obj instanceof ByteBuffer) {
            this.writeBinary((ByteBuffer)obj);
            return;
        }
        if (obj instanceof List) {
            this.writeList((List)obj);
            return;
        }
        if (obj instanceof Map) {
            this.writeMap((Map)obj);
            return;
        }
        if (obj instanceof Tag) {
            Tag t = (Tag)obj;
            this.writeTag(t.value);
            this.writeObject(t.data);
            return;
        }
        if (obj instanceof Indefinite) {
            Indefinite d = (Indefinite)obj;
            this.write(d.type);
            for (Object c : d.parts) {
                this.writeObject(c);
            }
            this.write(255);
            return;
        }
        throw new IllegalArgumentException("unsupported object: " + obj);
    }

    private void writeMap(Map<?, ?> objects) throws IOException {
        this.writeMapHeader(objects.size());
        for (Map.Entry<?, ?> entry : objects.entrySet()) {
            this.writeObject(entry.getKey());
            this.writeObject(entry.getValue());
        }
    }

    private void writeMap(Object ... objects) throws IOException {
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("Must pass an even number of objects");
        }
        this.writeMapHeader(objects.length / 2);
        for (int i = 0; i < objects.length; i += 2) {
            this.writeObject(objects[i]);
            this.writeObject(objects[i + 1]);
        }
    }

    private void writeList(List<?> objects) throws IOException {
        this.writeArrayHeader(objects.size());
        for (Object obj : objects) {
            this.writeObject(obj);
        }
    }

    private void writeList(Object[] objects) throws IOException {
        this.writeArrayHeader(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            this.writeObject(objects[i]);
        }
    }

    public static String pretty(byte[] src) {
        return Cbor.pretty(src, 0);
    }

    public static String pretty(byte[] src, int srcOffset) {
        return Cbor.pretty(src, new IntRef(srcOffset));
    }

    public static String pretty(byte[] src, IntRef ref) {
        if (src == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder();
        Cbor.pretty(src, ref, sb);
        return sb.toString();
    }

    private static void pretty(byte[] src, IntRef offset, StringBuilder sb) {
        int srcOffset = offset.value;
        if (srcOffset >= src.length) {
            return;
        }
        int type = src[srcOffset++] & 0xFF;
        long value = 0L;
        switch (type & 0x1F) {
            default: {
                value = type & 0x1F;
                break;
            }
            case 27: {
                value = ((long)src[srcOffset++] & 0xFFL) << 56 | ((long)src[srcOffset++] & 0xFFL) << 48 | ((long)src[srcOffset++] & 0xFFL) << 40 | ((long)src[srcOffset++] & 0xFFL) << 32;
            }
            case 26: {
                value |= ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16;
            }
            case 25: {
                value |= ((long)src[srcOffset++] & 0xFFL) << 8;
            }
            case 24: {
                value |= (long)src[srcOffset++] & 0xFFL;
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                throw new IllegalStateException("illegal type: " + type);
            }
            case 31: {
                value = -1L;
            }
        }
        offset.value = srcOffset;
        block8 : switch (type >> 5) {
            case 0: {
                sb.append(Utils.longToUnsignedString(value));
                break;
            }
            case 1: {
                long v = value ^ 0xFFFFFFFFFFFFFFFFL;
                sb.append(Long.toString(v));
                break;
            }
            case 5: {
                sb.append('{');
                if ((type & 0x1F) == 31) {
                    while (src[offset.value] != -1) {
                        Cbor.pretty(src, offset, sb);
                        sb.append(':');
                        Cbor.pretty(src, offset, sb);
                        sb.append(',');
                    }
                    ++offset.value;
                } else {
                    int sz = (int)value;
                    for (int i = 0; i < sz; ++i) {
                        Cbor.pretty(src, offset, sb);
                        sb.append(':');
                        Cbor.pretty(src, offset, sb);
                        sb.append(',');
                    }
                }
                sb.append('}');
                break;
            }
            case 4: {
                sb.append('[');
                if ((type & 0x1F) == 31) {
                    while (src[offset.value] != -1) {
                        Cbor.pretty(src, offset, sb);
                        sb.append(',');
                    }
                    ++offset.value;
                } else {
                    int sz = (int)value;
                    for (int i = 0; i < sz; ++i) {
                        Cbor.pretty(src, offset, sb);
                        if (i >= sz - 1) continue;
                        sb.append(',');
                    }
                }
                sb.append(']');
                break;
            }
            case 2: {
                sb.append("0x");
                if ((type & 0x1F) == 31) {
                    while (src[offset.value] != -1) {
                        int start = sb.length();
                        Cbor.pretty(src, offset, sb);
                        sb.delete(start, start + 2);
                    }
                    ++offset.value;
                    break;
                }
                int i = 0;
                while ((long)i < value) {
                    sb.append(Character.forDigit((src[i + offset.value] & 0xF0) >>> 4, 16)).append(Character.forDigit(src[i + offset.value] & 0xF, 16));
                    ++i;
                }
                offset.value = (int)((long)offset.value + value);
                break;
            }
            case 3: {
                sb.append('\"');
                if ((type & 0x1F) == 31) {
                    while (src[offset.value] != -1) {
                        StringBuilder part = new StringBuilder();
                        Cbor.pretty(src, offset, part);
                        sb.append(part.subSequence(1, part.length() - 1));
                    }
                    ++offset.value;
                } else {
                    int len = (int)value;
                    block41: for (int i = 0; i < len; ++i) {
                        int b = src[i + offset.value];
                        switch (b) {
                            case 34: 
                            case 92: {
                                sb.append('\\');
                            }
                        }
                        int c = b;
                        if (c < 0) {
                            switch (c >> 4 & 3) {
                                default: {
                                    if (++i >= len) break block41;
                                    c = (c & 0x1F) << 6 | src[i + offset.value] & 0x3F;
                                    break;
                                }
                                case 2: {
                                    if (i + 2 >= len) break block41;
                                    c = (c & 0xF) << 12 | (src[++i + offset.value] & 0x3F) << 6 | src[++i + offset.value] & 0x3F;
                                    break;
                                }
                                case 3: {
                                    if (i + 3 >= len) break block41;
                                    c = (c & 7) << 18 | (src[++i + offset.value] & 0x3F) << 12 | (src[++i + offset.value] & 0x3F) << 6 | src[++i + offset.value] & 0x3F;
                                    sb.appendCodePoint(c);
                                    continue block41;
                                }
                            }
                        }
                        sb.append((char)c);
                    }
                    offset.value += len;
                }
                sb.append('\"');
                break;
            }
            case 6: {
                sb.append(Utils.longToUnsignedString(value));
                sb.append("::");
                Cbor.pretty(src, offset, sb);
                break;
            }
            case 7: {
                switch (type & 0x1F) {
                    case 20: {
                        sb.append("false");
                        break block8;
                    }
                    case 21: {
                        sb.append("true");
                        break block8;
                    }
                    case 22: {
                        sb.append("null");
                        break block8;
                    }
                    case 25: {
                        sb.append(Decoder.float16to32((int)value));
                        break block8;
                    }
                    case 26: {
                        sb.append(Float.intBitsToFloat((int)value));
                        break block8;
                    }
                    case 27: {
                        sb.append(Double.longBitsToDouble(value));
                        break block8;
                    }
                    case 31: {
                        break block8;
                    }
                }
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        }
    }

    private static class Indefinite {
        final int type;
        final Object[] parts;

        Indefinite(int type, Object[] parts) {
            this.type = type;
            this.parts = parts;
        }
    }

    private static class Tag {
        final long value;
        final Object data;

        Tag(long value, Object data) {
            this.value = value;
            this.data = data;
        }
    }
}

